/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.common;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LevelFactory;

public class LevelImpl
implements Level,
Serializable {
    int value = 0;
    String name = null;
    String stringValue = null;

    public LevelImpl(String n, int val) {
        this.value = val;
        this.name = n;
        this.stringValue = String.valueOf(val);
    }

    public LevelImpl(String n, String val, LevelFactory lf) {
        this.stringValue = val;
        this.value = LevelImpl.evaluate(val, lf);
        this.name = n;
    }

    public int hashCode() {
        return this.value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int evaluate(String expr, LevelFactory lf) {
        int firstOperande = 0;
        int secondOperande = 0;
        int operator = 0;
        StringTokenizer st = new StringTokenizer(expr, " +-", true);
        while (st.hasMoreTokens()) {
            String elem = st.nextToken();
            if (elem.equalsIgnoreCase("FATAL")) {
                firstOperande = BasicLevel.FATAL;
                continue;
            }
            if (elem.equalsIgnoreCase("ERROR")) {
                firstOperande = BasicLevel.ERROR;
                continue;
            }
            if (elem.equalsIgnoreCase("WARN")) {
                firstOperande = BasicLevel.WARN;
                continue;
            }
            if (elem.equalsIgnoreCase("INFO")) {
                firstOperande = BasicLevel.INFO;
                continue;
            }
            if (elem.equalsIgnoreCase("DEBUG")) {
                firstOperande = BasicLevel.DEBUG;
                continue;
            }
            if (Character.isDigit(elem.charAt(0))) {
                try {
                    secondOperande = Integer.parseInt(elem);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (Character.isLetter(elem.charAt(0))) {
                Level l = lf.getLevel(elem);
                if (l == null) {
                    return 0;
                }
                firstOperande = l.getIntValue();
                continue;
            }
            if (elem.charAt(0) == '+') {
                operator = 1;
                continue;
            }
            if (elem.charAt(0) == '-') {
                operator = 2;
                continue;
            }
            if (!Character.isSpaceChar(elem.charAt(0))) continue;
        }
        if (firstOperande != 0) {
            if (secondOperande == 0 || operator == 0) return firstOperande;
            switch (operator) {
                case 1: {
                    return firstOperande + secondOperande;
                }
                case 2: {
                    return firstOperande - secondOperande;
                }
            }
            return 0;
        } else {
            if (secondOperande == 0) return 0;
            return secondOperande;
        }
    }

    public String toString() {
        return "(name=" + this.name + ", val=" + this.value + ", sval=" + this.stringValue + ")";
    }

    public boolean isComparableWith(Level o) {
        return o instanceof LevelImpl;
    }

    public int compareTo(Level o) {
        return this.value - o.getIntValue();
    }

    public int getIntValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }
}

