/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core;

import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.Information;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.RemoteRegistry;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.lifecycle.AbstractLifeCycle;
import org.ow2.petals.registry.api.lifecycle.LifeCycle;
import org.ow2.petals.registry.api.transport.MessageSender;

public class RemoteRegistryImpl
implements RemoteRegistry {
    private final Log log = LogFactory.getLog(RemoteRegistryImpl.class);
    private URI uri;
    private String name;
    private MessageSender messageSender;
    private final LifeCycle lifeCycle = new AbstractLifeCycle(){

        protected void doInit(Context context) throws LifeCycleException {
            RemoteRegistryImpl.this.log.debug((Object)"FIXME : Check the foreign registry at initialization?");
        }
    };

    public Resource get(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get the resoucre on path " + path));
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.get(path, information);
    }

    public List<Resource> getAll(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get all the resources under path " + path));
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.getAll(path, information);
    }

    public boolean put(String path, Resource resource, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Put the resource " + resource));
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.put(path, resource, information);
    }

    public boolean delete(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Delete the resource at " + path));
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.delete(path, information);
    }

    public List<Resource> query(Query query, Information info) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Query resources with " + query));
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.query(query, info);
    }

    public URI getURI() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LifeCycle.STATE getState() {
        return this.lifeCycle.getState();
    }

    public void init(Context context) throws LifeCycleException {
        this.lifeCycle.init(context);
    }

    public boolean isInitialized() {
        return this.lifeCycle.isInitialized();
    }

    public boolean isNotInitialized() {
        return this.lifeCycle.isNotInitialized();
    }

    public boolean isRunning() {
        return this.lifeCycle.isRunning();
    }

    public boolean isStarted() {
        return this.lifeCycle.isStarted();
    }

    public boolean isStopped() {
        return this.lifeCycle.isStopped();
    }

    public void start() throws LifeCycleException {
        this.lifeCycle.start();
    }

    public void stop() throws LifeCycleException {
        this.lifeCycle.stop();
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public MessageSender getMessageSender() {
        return this.messageSender;
    }

    public void setMessageSender(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RemoteRegistryImpl [name=");
        builder.append(this.name);
        builder.append(", uri=");
        builder.append(this.uri);
        builder.append("]");
        return builder.toString();
    }
}

