/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.repository;

import java.util.List;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.context.Workspace;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.exception.RepositoryException;
import org.ow2.petals.registry.api.lifecycle.LifeCycle;
import org.ow2.petals.registry.api.repository.Repository;
import org.ow2.petals.registry.api.util.Assert;
import org.ow2.petals.registry.api.util.ResourceUtil;
import org.ow2.petals.registry.core.repository.RepositoryLifecycle;

public abstract class AbstractRepository
implements Repository {
    protected LifeCycle lifeCycle;
    protected String name;
    protected Workspace workspace;
    protected Context context;

    public AbstractRepository() {
        this.createLifeCycle();
    }

    public void createLifeCycle() {
        if (this.lifeCycle == null) {
            this.lifeCycle = new RepositoryLifecycle(this);
        }
    }

    public final Resource get(String key, boolean b) throws RegistryException {
        if (!this.isStarted()) {
            throw new LifeCycleException("Can not get a resource when repository is in state " + this.getState());
        }
        if (ResourceUtil.isDirectory((String)key)) {
            throw new RepositoryException("Can not get a single resource from a directory path");
        }
        Resource r = null;
        r = this.doGet(key);
        return r;
    }

    public List<Resource> getAll(String path, boolean b) throws RegistryException {
        if (!this.isStarted()) {
            throw new LifeCycleException("Can not get a resource when repository is in state " + this.getState());
        }
        if (!ResourceUtil.isDirectory((String)path)) {
            throw new RepositoryException("Can not get a directory listing from a single resource path");
        }
        List<Resource> r = null;
        r = this.doGetAll(path);
        return r;
    }

    public final synchronized boolean put(String path, Resource resource, boolean b) throws RegistryException {
        if (!this.isStarted()) {
            throw new LifeCycleException("Can not put a resource when repository is in state " + this.getState());
        }
        if (path == null) {
            throw new RepositoryException("Can not put the resource under a null path...");
        }
        if (ResourceUtil.isDirectory((String)path)) {
            throw new RepositoryException("Can not put the resource under a directory path '" + path + "'");
        }
        if (resource != null && !path.equals(resource.getPath())) {
            resource.setPath(path);
        }
        boolean success = false;
        this.doPut(path, resource);
        success = true;
        return success;
    }

    public final boolean delete(String key, boolean b) throws RegistryException {
        if (!this.isStarted()) {
            throw new LifeCycleException("Can not delete a resource when repository is in state " + this.getState());
        }
        boolean success = false;
        this.doDelete(key);
        success = true;
        return success;
    }

    public final int clean() throws RegistryException {
        int result = 0;
        if (!this.isStarted()) {
            throw new LifeCycleException("Can not clean the repository when the repository is in state " + this.getState());
        }
        result = this.doClean();
        return result;
    }

    public final long size() throws RegistryException {
        long result = 0L;
        if (!this.isStarted()) {
            throw new LifeCycleException("Can not get the size of the repository when the repository is in state " + this.getState());
        }
        result = this.doSize();
        return result;
    }

    public int keepOnly(String registryName) throws RegistryException {
        int result = 0;
        if (!this.isStarted()) {
            throw new LifeCycleException("Can not keep only data for registry " + registryName + " in state " + this.getState());
        }
        result = this.doKeepOnly(registryName);
        return result;
    }

    protected abstract int doKeepOnly(String var1) throws RegistryException;

    public int deleteDataFromRegistry(String registryName) throws RegistryException {
        int result = 0;
        if (!this.isStarted()) {
            throw new LifeCycleException("Can not delete data from other registries in the repository when the repository is in state " + this.getState());
        }
        result = this.doDeleteDataFromRegistry(registryName);
        return result;
    }

    protected abstract int doDeleteDataFromRegistry(String var1) throws RegistryException;

    public List<Resource> query(Query query, boolean b) throws RegistryException {
        List<Resource> result = null;
        if (!this.isStarted()) {
            throw new LifeCycleException("Can not clean the repository when the repository is in state " + this.getState());
        }
        result = this.doQuery(query);
        return result;
    }

    protected abstract Resource doGet(String var1) throws RegistryException;

    protected abstract List<Resource> doGetAll(String var1) throws RegistryException;

    protected abstract boolean doPut(String var1, Resource var2) throws RegistryException;

    protected abstract boolean doDelete(String var1) throws RegistryException;

    protected abstract int doClean() throws RegistryException;

    protected abstract long doSize() throws RegistryException;

    protected abstract List<Resource> doQuery(Query var1) throws RegistryException;

    public Context getContext() {
        return this.context;
    }

    protected void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public LifeCycle.STATE getState() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.getState();
    }

    public void init(Context context) throws LifeCycleException {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        Assert.notNull((Object)context);
        this.context = context;
        this.context.init();
        this.workspace = context.getWorkspace();
        this.lifeCycle.init(context);
    }

    public boolean isInitialized() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isInitialized();
    }

    public boolean isNotInitialized() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isNotInitialized();
    }

    public boolean isRunning() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isRunning();
    }

    public boolean isStarted() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isStarted();
    }

    public boolean isStopped() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isStopped();
    }

    public void start() throws LifeCycleException {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        this.lifeCycle.start();
    }

    public void stop() throws LifeCycleException {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        this.lifeCycle.stop();
    }
}

