/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;

public class AbstractComponent
implements BindingController {
    private Component fcComp;
    private Set fcSingletonItfNames = new HashSet();
    private Set fcCollectionItfNames = new HashSet();
    private Map fcBindings = new HashMap();

    public String[] listFc() {
        HashSet names = new HashSet(this.fcBindings.keySet());
        names.addAll(this.fcSingletonItfNames);
        String[] result = names.toArray(new String[names.size()]);
        return result;
    }

    public Object lookupFc(String clientItfName) {
        if (clientItfName.equals("component")) {
            return this.fcComp;
        }
        if (this.fcSingletonItfNames.contains(clientItfName)) {
            return this.fcBindings.get(clientItfName);
        }
        Iterator iter = this.fcCollectionItfNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!clientItfName.startsWith(name)) continue;
            return this.fcBindings.get(clientItfName);
        }
        return null;
    }

    public void bindFc(String clientItfName, Object serverItf) {
        if (clientItfName.equals("component")) {
            this.initFcComp(serverItf);
            return;
        }
        if (this.fcSingletonItfNames.contains(clientItfName)) {
            this.fcBindings.put(clientItfName, serverItf);
            return;
        }
        Iterator iter = this.fcCollectionItfNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!clientItfName.startsWith(name)) continue;
            this.fcBindings.put(clientItfName, serverItf);
            return;
        }
    }

    public void unbindFc(String clientItfName) {
        if (this.fcSingletonItfNames.contains(clientItfName)) {
            this.fcBindings.remove(clientItfName);
            return;
        }
        Iterator iter = this.fcCollectionItfNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!clientItfName.startsWith(name)) continue;
            this.fcBindings.remove(clientItfName);
            return;
        }
    }

    private void initFcComp(Object serverItf) {
        if (!(serverItf instanceof Component)) {
            String msg = "The instance bound to the component interface should implement " + Component.class.getName();
            throw new RuntimeException(msg);
        }
        this.fcComp = (Component)serverItf;
        Type fcType = this.fcComp.getFcType();
        if (!(fcType instanceof ComponentType)) {
            String msg = "The component bound to the component interface should be of type " + ComponentType.class.getName();
            throw new RuntimeException(msg);
        }
        InterfaceType[] fcItfTypes = ((ComponentType)fcType).getFcInterfaceTypes();
        for (int i = 0; i < fcItfTypes.length; ++i) {
            if (!fcItfTypes[i].isFcClientItf()) continue;
            Set set = fcItfTypes[i].isFcCollectionItf() ? this.fcCollectionItfNames : this.fcSingletonItfNames;
            set.add(fcItfTypes[i].getFcItfName());
        }
    }
}

