/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jndi.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.ServiceUnavailableException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.communication.jndi.agent.AbstractJNDIAgentServiceImpl;
import org.ow2.petals.communication.jndi.agent.JNDIAgentService;
import org.ow2.petals.communication.jndi.agent.util.RegistryUtil;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=JNDIAgentService.class)})
public class StandaloneJNDIAgentServiceImpl
extends AbstractJNDIAgentServiceImpl
implements BindingController,
LifeCycleController {
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;

    @Override
    public boolean containsContext(String string) throws ServiceUnavailableException {
        return this.data.containsKey(string);
    }

    @Override
    public Map<String, Serializable> getContext(String string) throws ServiceUnavailableException {
        this.log.start((Object)string);
        Hashtable<String, Serializable> hashtable = (Hashtable<String, Serializable>)this.data.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Serializable>();
            this.data.put(string, hashtable);
        }
        this.log.end();
        return hashtable;
    }

    @Override
    public void removeContext(String string) throws ServiceUnavailableException {
        this.log.call((Object)string);
        this.data.remove(string);
    }

    public String getFcState() {
        return null;
    }

    private void initData() {
        this.log.start();
        this.data = new Hashtable();
        this.data.put("/", new HashMap());
        this.log.end();
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Communication.JNDIAgentService"));
        this.log.start();
        this.domainConfiguration = this.configurationService.getDomainConfiguration();
        if (this.domainConfiguration.getJndiConfiguration() == null) {
            this.initData();
            this.registryUtil = new RegistryUtil(this);
        }
        this.log.end();
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

