/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jndi.client;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.communication.jndi.agent.JNDIAgentService;
import org.ow2.petals.communication.jndi.client.InitialContextDecorator;
import org.ow2.petals.communication.jndi.client.JNDIService;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=JNDIService.class)})
public class JNDIServiceImpl
implements BindingController,
LifeCycleController,
JNDIService {
    protected Context usersContext;
    protected LoggingUtil log;
    @Requires(name="jndiAgent", signature=JNDIAgentService.class)
    private JNDIAgentService jndiAgentService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private DomainConfiguration domainConfiguration;
    private InitialContextDecorator initialContextDecorator;

    public String getFcState() {
        return null;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Communication.JNDIService"));
        this.log.call();
        this.domainConfiguration = this.configurationService.getDomainConfiguration();
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.start();
        if (this.initialContextDecorator != null) {
            try {
                try {
                    this.initialContextDecorator.closeInitialContextDecorator();
                }
                catch (NamingException namingException) {
                    this.log.error((Object)namingException);
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.initialContextDecorator = null;
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.initialContextDecorator = null;
            }
        }
        this.log.end();
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public synchronized InitialContext getInitialContext() throws NamingException {
        this.log.call();
        if (this.initialContextDecorator == null) {
            this.log.debug((Object)"Create a new InitialContext decorator");
            Hashtable<String, Object> hashtable = this.getJNDIEnv();
            this.log.debug((Object)("JNDI properties used : " + hashtable));
            this.initialContextDecorator = new InitialContextDecorator(hashtable, this.log, this.jndiAgentService);
        }
        return this.initialContextDecorator;
    }

    @Override
    public synchronized Context getUsersContext() throws NamingException {
        this.log.call();
        if (this.usersContext == null) {
            try {
                this.usersContext = (Context)this.getInitialContext().lookup("users");
            }
            catch (NameNotFoundException nameNotFoundException) {
                this.usersContext = this.getInitialContext().createSubcontext("users");
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                this.usersContext = (Context)this.getInitialContext().lookup("users");
            }
        }
        return this.usersContext;
    }

    private Hashtable<String, Object> getJNDIEnv() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.domainConfiguration.getJndiConfiguration() == null || this.domainConfiguration.getJndiConfiguration().getJndiFactory() == null) {
            hashtable.put("org.ow2.petals.communication.jndi.agent.local", Boolean.toString(true));
            hashtable.put("java.naming.factory.initial", "org.ow2.petals.communication.jndi.client.naming.NamingContextFactory");
        } else {
            hashtable.put("java.naming.factory.initial", this.domainConfiguration.getJndiConfiguration().getJndiFactory());
            hashtable.put("java.naming.provider.url", this.domainConfiguration.getJndiConfiguration().getJndiProviderUrl().toString());
            hashtable.put("java.naming.security.principal", this.domainConfiguration.getJndiConfiguration().getJndiSecurityPrincipal());
            hashtable.put("java.naming.security.credentials", this.domainConfiguration.getJndiConfiguration().getJndiSecurityCredentials());
            hashtable.put("java.naming.batchsize", String.valueOf(this.domainConfiguration.getJndiConfiguration().getJndiBatchSize()));
            hashtable.put("java.naming.poolsize", String.valueOf(this.domainConfiguration.getJndiConfiguration().getJndiPoolSize()));
            hashtable.put("java.naming.factory.logger", this.log);
        }
        return hashtable;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("jndiAgent")) {
            if (!JNDIAgentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + JNDIAgentService.class.getName());
            }
            this.jndiAgentService = (JNDIAgentService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("jndiAgent");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("jndiAgent")) {
            return this.jndiAgentService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("jndiAgent")) {
            this.jndiAgentService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

