/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.fractal.util.Fractal;
import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.ComponentLifeCycle;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.SharedLibraryLifeCycle;
import org.ow2.petals.container.lifecycle.SharedLibraryLifeCycleImpl;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceAssembly;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.server.Binding;
import org.ow2.petals.kernel.server.FractalHelper;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ContainerService.class)})
public class ContainerServiceImpl
implements BindingController,
LifeCycleController,
ContainerService {
    public static final String FRACTAL_CONTAINER_SERVICE_NAME = "ContainerServiceImpl";
    public static final String CONFIGURATION_ITF = "configuration";
    public static final String ADMIN_ITF = "admin";
    public static final String CLASSLOADER_ITF = "classloader";
    public static final String ROUTER_ITF = "router";
    public static final String REPOSITORY_ITF = "repository";
    public static final String ENDPOINT_ITF = "endpoint";
    public static final String ENDPOINT_PROPERTIES_ITF = "endpointpropertiesfinder";
    public static final String JNDI_ITF = "jndi";
    public static final String SYSTEMSTATE_ITF = "systemstate";
    public static final String CONTAINER_ITF = "container";
    public static final String TRANSACTIONMANAGER_ITF = "transactionManager";
    private LoggingUtil log;
    private org.objectweb.fractal.api.Component comp;
    private org.objectweb.fractal.api.Component parentcontainer;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public org.objectweb.fractal.api.Component getParentContainer() {
        return this.parentcontainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.objectweb.fractal.api.Component createInstaller(Component component) throws PetalsException {
        org.objectweb.fractal.api.Component component2 = null;
        try {
            component2 = FractalHelper.createNewComponent(Installer.class.getName());
            NameController nameController = Fractal.getNameController((org.objectweb.fractal.api.Component)component2);
            nameController.setFcName("Installer." + component.getIdentification().getName());
            ContentController contentController = Fractal.getContentController((org.objectweb.fractal.api.Component)this.parentcontainer);
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            org.objectweb.fractal.api.Component component3 = this.parentcontainer;
            synchronized (component3) {
                arrayList.add(new Binding(CONFIGURATION_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(CONFIGURATION_ITF)));
                arrayList.add(new Binding(ADMIN_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(ADMIN_ITF)));
                arrayList.add(new Binding(CLASSLOADER_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(CLASSLOADER_ITF)));
                arrayList.add(new Binding(ROUTER_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(ROUTER_ITF)));
                arrayList.add(new Binding(REPOSITORY_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(REPOSITORY_ITF)));
                arrayList.add(new Binding(ENDPOINT_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(ENDPOINT_ITF)));
                arrayList.add(new Binding(JNDI_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(JNDI_ITF)));
                arrayList.add(new Binding(SYSTEMSTATE_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(SYSTEMSTATE_ITF)));
                try {
                    contentController.getFcInternalInterface(TRANSACTIONMANAGER_ITF);
                    arrayList.add(new Binding(TRANSACTIONMANAGER_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(TRANSACTIONMANAGER_ITF)));
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {}
                try {
                    contentController.getFcInternalInterface(ENDPOINT_PROPERTIES_ITF);
                    arrayList.add(new Binding(ENDPOINT_PROPERTIES_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(ENDPOINT_PROPERTIES_ITF)));
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {}
                org.objectweb.fractal.api.Component component4 = FractalHelper.getComponentByName(contentController, FRACTAL_CONTAINER_SERVICE_NAME);
                arrayList.add(new Binding(CONTAINER_ITF, (org.objectweb.fractal.api.Interface)component4.getFcInterface("service")));
            }
            FractalHelper.addComponent(component2, this.parentcontainer, arrayList);
        }
        catch (ADLException aDLException) {
            throw new PetalsException((Throwable)aDLException);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new PetalsException((Throwable)illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new PetalsException((Throwable)illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new PetalsException((Throwable)illegalBindingException);
        }
        return component2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.objectweb.fractal.api.Component createComponentLifeCycle(Component component) throws PetalsException {
        org.objectweb.fractal.api.Component component2 = null;
        try {
            ContentController contentController = Fractal.getContentController((org.objectweb.fractal.api.Component)this.parentcontainer);
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            org.objectweb.fractal.api.Component component3 = this.parentcontainer;
            synchronized (component3) {
                arrayList.add(new Binding(CONFIGURATION_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(CONFIGURATION_ITF)));
                arrayList.add(new Binding(ADMIN_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(ADMIN_ITF)));
                arrayList.add(new Binding(JNDI_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(JNDI_ITF)));
                arrayList.add(new Binding(SYSTEMSTATE_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(SYSTEMSTATE_ITF)));
                component2 = FractalHelper.createNewComponent(ComponentLifeCycle.class.getName());
                NameController nameController = Fractal.getNameController((org.objectweb.fractal.api.Component)component2);
                nameController.setFcName("ComponentLifeCycle." + component.getIdentification().getName());
            }
            FractalHelper.addComponent(component2, this.parentcontainer, arrayList);
        }
        catch (ADLException aDLException) {
            throw new PetalsException((Throwable)aDLException);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new PetalsException((Throwable)illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new PetalsException((Throwable)illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new PetalsException((Throwable)illegalBindingException);
        }
        return component2;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.comp = (org.objectweb.fractal.api.Component)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public void removeComponentLifeCycle(Component component) throws PetalsException {
        try {
            ContentController contentController = Fractal.getContentController((org.objectweb.fractal.api.Component)this.getParentContainer());
            org.objectweb.fractal.api.Component component2 = FractalHelper.getRecursiveComponentByName(contentController, "ComponentLifeCycle." + component.getIdentification().getName());
            FractalHelper.stopComponent(component2);
            BindingController bindingController = Fractal.getBindingController((org.objectweb.fractal.api.Component)component2);
            int n = 0;
            while (n < bindingController.listFc().length) {
                bindingController.unbindFc(bindingController.listFc()[n]);
                ++n;
            }
            contentController.removeFcSubComponent(component2);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new PetalsException((Throwable)illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new PetalsException((Throwable)illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new PetalsException((Throwable)illegalBindingException);
        }
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void removeInstaller(String string) throws PetalsException {
        try {
            ContentController contentController = Fractal.getContentController((org.objectweb.fractal.api.Component)this.getParentContainer());
            org.objectweb.fractal.api.Component component = FractalHelper.getRecursiveComponentByName(contentController, "Installer." + string);
            FractalHelper.stopComponent(component);
            BindingController bindingController = Fractal.getBindingController((org.objectweb.fractal.api.Component)component);
            int n = 0;
            while (n < bindingController.listFc().length) {
                if (bindingController.lookupFc(bindingController.listFc()[n]) != null) {
                    bindingController.unbindFc(bindingController.listFc()[n]);
                }
                ++n;
            }
            contentController.removeFcSubComponent(component);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new PetalsException((Throwable)illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new PetalsException((Throwable)illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new PetalsException((Throwable)illegalBindingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.objectweb.fractal.api.Component createServiceAssemblyLifeCycle(ServiceAssembly serviceAssembly) throws PetalsException {
        org.objectweb.fractal.api.Component component = null;
        try {
            ContentController contentController = Fractal.getContentController((org.objectweb.fractal.api.Component)this.parentcontainer);
            component = FractalHelper.createNewComponent(ServiceAssemblyLifeCycle.class.getName());
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            org.objectweb.fractal.api.Component component2 = this.parentcontainer;
            synchronized (component2) {
                arrayList.add(new Binding(SYSTEMSTATE_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(SYSTEMSTATE_ITF)));
                arrayList.add(new Binding(ROUTER_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(ROUTER_ITF)));
            }
            component2 = Fractal.getNameController((org.objectweb.fractal.api.Component)component);
            component2.setFcName("ServiceAssemblyLifeCycle." + serviceAssembly.getIdentification().getName());
            FractalHelper.addComponent(component, this.parentcontainer, arrayList);
        }
        catch (ADLException aDLException) {
            throw new PetalsException((Throwable)aDLException);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new PetalsException((Throwable)illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new PetalsException((Throwable)illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new PetalsException((Throwable)illegalBindingException);
        }
        return component;
    }

    public void removeServiceAssemblyLifeCycle(ServiceAssemblyLifeCycle serviceAssemblyLifeCycle) throws PetalsException {
        try {
            ContentController contentController = Fractal.getContentController((org.objectweb.fractal.api.Component)this.getParentContainer());
            org.objectweb.fractal.api.Component component = serviceAssemblyLifeCycle.getComponent();
            FractalHelper.stopComponent(component);
            BindingController bindingController = Fractal.getBindingController((org.objectweb.fractal.api.Component)component);
            int n = 0;
            while (n < bindingController.listFc().length) {
                bindingController.unbindFc(bindingController.listFc()[n]);
                ++n;
            }
            contentController.removeFcSubComponent(component);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new PetalsException((Throwable)illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new PetalsException((Throwable)illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new PetalsException((Throwable)illegalBindingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.objectweb.fractal.api.Component createSharedLibraryLifeCycle(Jbi.SharedLibrary sharedLibrary) throws PetalsException {
        org.objectweb.fractal.api.Component component = null;
        try {
            ContentController contentController = Fractal.getContentController((org.objectweb.fractal.api.Component)this.parentcontainer);
            component = FractalHelper.createNewComponent(SharedLibraryLifeCycleImpl.class.getName());
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            org.objectweb.fractal.api.Component component2 = this.parentcontainer;
            synchronized (component2) {
                arrayList.add(new Binding(CLASSLOADER_ITF, (org.objectweb.fractal.api.Interface)contentController.getFcInternalInterface(CLASSLOADER_ITF)));
            }
            component2 = Fractal.getNameController((org.objectweb.fractal.api.Component)component);
            component2.setFcName("SharedLibraryLifeCycle." + sharedLibrary.getIdentification().getName() + "-" + sharedLibrary.getVersion());
            FractalHelper.addComponent(component, this.parentcontainer, arrayList);
        }
        catch (ADLException aDLException) {
            throw new PetalsException((Throwable)aDLException);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new PetalsException((Throwable)illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new PetalsException((Throwable)illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new PetalsException((Throwable)illegalBindingException);
        }
        return component;
    }

    public void removeSharedLibraryLifeCycle(String string) throws PetalsException {
        try {
            ContentController contentController = Fractal.getContentController((org.objectweb.fractal.api.Component)this.getParentContainer());
            org.objectweb.fractal.api.Component component = FractalHelper.getRecursiveComponentByName(contentController, "SharedLibraryLifeCycle." + string);
            ((SharedLibraryLifeCycle)component.getFcInterface("service")).unLoadSharedLibrary();
            FractalHelper.stopComponent(component);
            BindingController bindingController = Fractal.getBindingController((org.objectweb.fractal.api.Component)component);
            int n = 0;
            while (n < bindingController.listFc().length) {
                bindingController.unbindFc(bindingController.listFc()[n]);
                ++n;
            }
            contentController.removeFcSubComponent(component);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (IllegalContentException illegalContentException) {
            throw new PetalsException((Throwable)illegalContentException);
        }
        catch (IllegalLifeCycleException illegalLifeCycleException) {
            throw new PetalsException((Throwable)illegalLifeCycleException);
        }
        catch (IllegalBindingException illegalBindingException) {
            throw new PetalsException((Throwable)illegalBindingException);
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws NoSuchInterfaceException, PetalsException {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Container.ContainerService"));
        this.log.call();
        try {
            SuperController superController = Fractal.getSuperController((org.objectweb.fractal.api.Component)this.comp);
            if (superController.getFcSuperComponents().length != 1) {
                throw new PetalsException("Error in fractal architecture");
            }
            this.parentcontainer = superController.getFcSuperComponents()[0];
        }
        catch (PetalsException petalsException) {
            this.log.error((Object)"Failed to start Container service", (Throwable)petalsException);
            throw petalsException;
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            this.log.error((Object)"Failed to start Container service", (Throwable)noSuchInterfaceException);
            throw noSuchInterfaceException;
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }
}

