/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.component.context;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.InstallationContext;
import org.ow2.petals.jbi.component.context.ComponentContextForInstallation;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallationContextImpl
implements InstallationContext {
    private List<String> classPathElements;
    private String componentClassName;
    private String componentName;
    private ComponentContext context;
    private boolean install;
    private DocumentFragment installationDescriptorExtension;
    private String installRoot;

    public InstallationContextImpl(Component component, ComponentContext componentContext, boolean bl) {
        Object object;
        Object object2;
        this.context = new ComponentContextForInstallation(componentContext);
        this.componentClassName = component.getComponentClassName().getContent();
        this.componentName = component.getIdentification().getName();
        this.install = bl;
        if (component.getComponentClassPath() != null && (object2 = component.getComponentClassPath().getPathElement()) != null) {
            object = new ArrayList<String>();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object object3 = (String)iterator.next();
                ((String)object3).trim();
                if (File.separatorChar == '\\') {
                    object.add(((String)object3).replace('/', '\\'));
                    continue;
                }
                object.add(((String)object3).replace('\\', '/'));
            }
            this.setClassPathElements((List)object);
        }
        this.installRoot = componentContext.getInstallRoot();
        if (component.getAnyOrAny() != null) {
            object2 = null;
            object = null;
            for (Object object3 : component.getAnyOrAny()) {
                if (object2 == null) {
                    object = object3.getOwnerDocument();
                    object2 = object.createDocumentFragment();
                }
                object2.appendChild(object.importNode((Node)object3, true));
            }
            this.installationDescriptorExtension = object2;
        }
    }

    public List<String> getClassPathElements() {
        return this.classPathElements;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public DocumentFragment getInstallationDescriptorExtension() {
        return this.installationDescriptorExtension;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public boolean isInstall() {
        return this.install;
    }

    public void setClassPathElements(List list) {
        if (list == null) {
            throw new IllegalArgumentException("classPathElements must not be null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("classPathElements must not be empty");
        }
        for (Object e : list) {
            if (!(e instanceof String)) {
                throw new IllegalArgumentException("classPathElements must contain element of type String");
            }
            String string = (String)e;
            String string2 = "\\".equals(File.separator) ? "/" : "\\";
            int n = string.indexOf(string2);
            if (n > -1) {
                throw new IllegalArgumentException("classpath ill-formed : classPathElements contains an invalid file separator '" + string2 + "'");
            }
            File file = new File(string);
            if (!file.isAbsolute()) continue;
            throw new IllegalArgumentException("classpath ill-formed : classPathElements should not contain absolute paths");
        }
        this.classPathElements = new ArrayList<String>(list);
    }

    public void setInstall(boolean bl) {
        this.install = bl;
    }
}

