/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management;

import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.Task;
import org.ow2.petals.util.LoggingUtil;

public class TaskProcessor {
    protected List<Task> taskList = new ArrayList<Task>();
    protected Context context;
    protected LoggingUtil log;

    public TaskProcessor(Context context, LoggingUtil loggingUtil) {
        this.context = context;
        this.log = loggingUtil;
    }

    public void addTask(Task task) {
        this.taskList.add(task);
    }

    public Throwable process() {
        Throwable throwable = null;
        int n = 0;
        while (n < this.taskList.size() && throwable == null) {
            try {
                this.taskList.get(n).execute(this.context);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                this.unprocess(n - 1);
            }
            ++n;
        }
        return throwable;
    }

    public boolean unprocess(int n) {
        boolean bl = true;
        int n2 = n;
        while (n2 >= 0) {
            try {
                this.taskList.get(n2).undo(this.context);
            }
            catch (Throwable throwable) {
                bl = false;
                this.log.error((Object)"Error during task unprocessing", throwable);
            }
            --n2;
        }
        return bl;
    }

    public boolean unprocess() {
        return this.unprocess(this.taskList.size() - 1);
    }
}

