/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.logging;

import com.ebmwebsourcing.easycommons.logger.LoggerHelper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.jbi.management.logging.LoggerService;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=LoggerService.class)})
public class LoggerServiceImpl
implements LifeCycleController,
LoggerService {
    protected LoggingUtil log;

    public String[] getAllLevels() {
        Level[] levelArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        Level[] levelArray2 = levelArray = com.ebmwebsourcing.easycommons.logger.Level.getLevels();
        int n = levelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray2[n2];
            arrayList.add(level.getName());
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[][] getAllLoggers() {
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (enumeration.hasMoreElements()) {
            linkedList.add(enumeration.nextElement());
        }
        String[][] stringArray = new String[linkedList.size()][2];
        int n = 0;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n][0] = string = (String)iterator.next();
            stringArray[n++][1] = this.getLevelForLogger(string);
        }
        return stringArray;
    }

    public String getFcState() {
        return null;
    }

    public String getLevelForLogger(String string) {
        if (string == null) {
            throw new IllegalArgumentException("'logger' parameter must not be null");
        }
        return LoggerHelper.getLevelOrParentLevel((Logger)Logger.getLogger(string)).getName();
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void setLevelForLogger(String string, String string2) {
        Logger.getLogger(string).setLevel(Level.parse(string2));
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void shutdown() throws Exception {
        this.log.call();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger(LoggerServiceImpl.class.getName()));
        this.log.start();
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

