/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.deploy;

import java.net.URL;
import java.net.URLDecoder;
import javax.jbi.JBIException;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.Task;
import org.ow2.petals.jbi.management.admin.AdminService;

public class CreateAndRegisterSULifeCycleTask
implements Task {
    protected AdminService adminService;

    public CreateAndRegisterSULifeCycleTask(AdminService adminService) {
        this.adminService = adminService;
    }

    public void execute(Context context) throws Exception {
        URL uRL = context.getSuInstallUrl();
        ServiceUnit serviceUnit = context.getSuDescriptorInSa();
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = context.getSaLifeCycle();
        ServiceUnitLifeCycle serviceUnitLifeCycle = new ServiceUnitLifeCycle(serviceUnit, URLDecoder.decode(uRL.getPath()), this.adminService);
        this.registerSULifeCycle(serviceUnitLifeCycle, serviceAssemblyLifeCycle);
    }

    public void undo(Context context) throws Exception {
        if (context.getSuDescriptorInSa() != null && context.getSaLifeCycle() != null) {
            this.unregisterSULifeCycle(context.getSaLifeCycle(), context.getSuDescriptorInSa());
        }
    }

    private void registerSULifeCycle(ServiceUnitLifeCycle serviceUnitLifeCycle, ServiceAssemblyLifeCycle serviceAssemblyLifeCycle) throws ManagementException {
        try {
            serviceAssemblyLifeCycle.registerSU(serviceUnitLifeCycle);
        }
        catch (JBIException jBIException) {
            throw new ManagementException("Error while registering the service unit '" + serviceUnitLifeCycle.getSuName() + "' life cycle into the service assembly life cycle '" + serviceAssemblyLifeCycle.getServiceAssembly().getIdentification().getName() + "'", jBIException);
        }
    }

    private void unregisterSULifeCycle(ServiceAssemblyLifeCycle serviceAssemblyLifeCycle, ServiceUnit serviceUnit) {
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : serviceAssemblyLifeCycle.getServiceUnitLifeCycles()) {
            if (!serviceUnitLifeCycle.getSuName().equals(serviceUnit.getIdentification().getName())) continue;
            serviceAssemblyLifeCycle.unregisterSU(serviceUnitLifeCycle);
            break;
        }
    }
}

