/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.deploy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.Task;
import org.ow2.petals.system.repository.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieveSAAndSUInstallRootsTask
implements Task {
    protected RepositoryService repositoryService;

    public RetrieveSAAndSUInstallRootsTask(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public void execute(Context context) throws Exception {
        Jbi jbi = context.getDescriptor();
        URL uRL = this.repositoryService.getServiceAssemblyInstallDirectory(jbi.getServiceAssembly().getIdentification().getName()).toURI().toURL();
        Map<String, URL> map = this.retrieveSUInstallUrls(uRL, jbi);
        context.setInstallUrl(uRL);
        context.setSuInstallUrls(map);
    }

    protected Map<String, URL> retrieveSUInstallUrls(URL uRL, Jbi jbi) throws MalformedURLException {
        HashMap<String, URL> hashMap = new HashMap<String, URL>();
        List list = jbi.getServiceAssembly().getServiceUnit();
        for (ServiceUnit serviceUnit : list) {
            String string = serviceUnit.getIdentification().getName();
            hashMap.put(string, new File(uRL.getPath(), string).toURI().toURL());
        }
        return hashMap;
    }

    @Override
    public void undo(Context context) throws Exception {
    }
}

