/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.undeploy;

import javax.jbi.JBIException;
import javax.xml.namespace.QName;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.Connection;
import org.ow2.petals.jbi.descriptor.original.generated.Connections;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceAssembly;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.util.LoggingUtil;

public class RemoveAllConnectionsTask
extends AbstractLoggableTask {
    protected EndpointRegistry endpointRegistry;

    public RemoveAllConnectionsTask(LoggingUtil loggingUtil, EndpointRegistry endpointRegistry) {
        super(loggingUtil);
        this.endpointRegistry = endpointRegistry;
    }

    public void execute(Context context) throws Exception {
        if (context.getSaLifeCycle() != null) {
            this.removeConnections(context.getSaLifeCycle());
        }
    }

    protected void removeConnections(ServiceAssemblyLifeCycle serviceAssemblyLifeCycle) {
        ServiceAssembly serviceAssembly = serviceAssemblyLifeCycle.getServiceAssembly();
        Connections connections = serviceAssembly.getConnections();
        if (serviceAssembly != null && connections != null) {
            for (Connection connection : connections.getConnection()) {
                if (connection == null || connection.getConsumer() == null) continue;
                QName qName = connection.getConsumer().getInterfaceName();
                QName qName2 = connection.getConsumer().getServiceName();
                String string = connection.getConsumer().getEndpointName();
                QName qName3 = connection.getProvider().getServiceName();
                String string2 = connection.getProvider().getEndpointName();
                if (string2 == null || qName3 == null) continue;
                if (qName != null) {
                    try {
                        this.endpointRegistry.deregisterConnection(qName, qName3, string2);
                    }
                    catch (JBIException jBIException) {
                        this.log.error((Object)"Unable to unregister a connection with a resolved interface", (Throwable)jBIException);
                    }
                    continue;
                }
                if (qName2 == null || string == null) continue;
                try {
                    this.endpointRegistry.deregisterConnection(qName2, string, qName3, string2);
                }
                catch (JBIException jBIException) {
                    this.log.error((Object)"Unable to unregister a connection with an unresolved interface", (Throwable)jBIException);
                }
            }
        }
    }

    public void undo(Context context) throws Exception {
    }
}

