/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.component;

import org.ow2.petals.container.lifecycle.SharedLibraryLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.Task;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.kernel.api.server.PetalsException;

public class RegisterComponentInSLTask
implements Task {
    private final AdminService adminService;

    public RegisterComponentInSLTask(AdminService adminService) {
        this.adminService = adminService;
    }

    public void execute(Context context) throws Exception {
        Jbi jbi = context.getDescriptor();
        if (jbi.getComponent().getSharedLibraryList() != null) {
            for (Component.SharedLibrary sharedLibrary : jbi.getComponent().getSharedLibraryList()) {
                SharedLibraryLifeCycle sharedLibraryLifeCycle = this.adminService.getSharedLibraryByName(String.valueOf(sharedLibrary.getContent()) + "-" + sharedLibrary.getVersion());
                if (sharedLibraryLifeCycle == null) {
                    throw new PetalsException("The component depends on the Shared Library '" + sharedLibrary.getContent() + "' with version '" + sharedLibrary.getVersion() + "' which is not installed");
                }
                sharedLibraryLifeCycle.registerComponent(jbi.getComponent().getIdentification().getName());
            }
        }
    }

    public void undo(Context context) throws Exception {
        Jbi jbi = context.getDescriptor();
        if (jbi.getComponent().getSharedLibraryList() != null) {
            for (Component.SharedLibrary sharedLibrary : jbi.getComponent().getSharedLibraryList()) {
                SharedLibraryLifeCycle sharedLibraryLifeCycle = this.adminService.getSharedLibraryByName(String.valueOf(sharedLibrary.getContent()) + "-" + sharedLibrary.getVersion());
                if (sharedLibraryLifeCycle == null) continue;
                sharedLibraryLifeCycle.unregisterComponent(jbi.getComponent().getIdentification().getName());
            }
        }
    }
}

