/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.security.auth.Subject;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.jaas.GroupPrincipal;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.jbi.security.AuthorizationEntry;
import org.ow2.petals.jbi.security.AuthorizationException;
import org.ow2.petals.jbi.security.AuthorizationMap;
import org.ow2.petals.jbi.security.DefaultAuthorizationMap;
import org.ow2.petals.jbi.security.DefaultAuthorizationParser;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class AuthorizationModule
implements LifeCycleController,
SenderModule {
    protected LoggingUtil log;
    public static final String CONFIGURATION = "authorization.cfg";
    private AuthorizationMap authorizationMap;

    public String getFcState() {
        return null;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IOException, URISyntaxException, AuthorizationException {
        this.log = new LoggingUtil(Logger.getLogger("Petals.JBI-Messaging.AuthorizationModule"));
        this.log.call();
        URL uRL = this.getClass().getResource("/authorization.cfg");
        if (uRL == null) {
            IOException iOException = new IOException("Can not load the authorization resource from classpath");
            this.log.error((Object)"Failed to start Authorization Module", (Throwable)iOException);
            throw iOException;
        }
        try {
            DefaultAuthorizationParser defaultAuthorizationParser = new DefaultAuthorizationParser(uRL.toURI());
            this.authorizationMap = defaultAuthorizationParser.parse();
            if (this.authorizationMap == null) {
                this.authorizationMap = new DefaultAuthorizationMap(new ArrayList<AuthorizationEntry>(0));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.log.error((Object)"Failed to start Authorization Module", (Throwable)uRISyntaxException);
            throw uRISyntaxException;
        }
        catch (AuthorizationException authorizationException) {
            this.log.error((Object)"Failed to start Authorization Module", (Throwable)authorizationException);
            throw authorizationException;
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws RoutingException {
        this.log.call();
    }

    @Override
    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeWrapper messageExchangeWrapper) throws RoutingException {
        this.authorizeSend(messageExchangeWrapper);
    }

    protected void authorizeSend(MessageExchangeWrapper messageExchangeWrapper) throws RoutingException {
        javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint;
        if (messageExchangeWrapper.getRole() == MessageExchange.Role.PROVIDER && messageExchangeWrapper.getStatus() != ExchangeStatus.DONE && (serviceEndpoint = messageExchangeWrapper.getEndpoint()) != null) {
            Set<Principal> set = this.authorizationMap.getAccessControlList(serviceEndpoint, messageExchangeWrapper.getOperation());
            if (this.log.isDebugEnabled()) {
                for (Principal object : set) {
                    this.log.debug((Object)("Server defined ACL for operation : " + messageExchangeWrapper.getOperation().toString()));
                    this.log.debug((Object)(String.valueOf(object.getName()) + "(" + object.getClass().getName() + ")"));
                }
            }
            if (!set.contains(GroupPrincipal.ALL)) {
                Subject subject = messageExchangeWrapper.getMessage("in").getSecuritySubject();
                if (subject == null) {
                    throw new SecurityException("User not authenticated (security subject is null)");
                }
                set.retainAll(subject.getPrincipals());
                this.log.debug((Object)("ACLS size after retain is : " + set.size()));
                if (set.size() == 0) {
                    throw new SecurityException("Endpoint '" + serviceEndpoint.getEndpointName() + "' / Operation '" + messageExchangeWrapper.getOperation() + "' is not authorized for this user");
                }
            }
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

