/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.exchange.PersistedMessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.jbi.messaging.routing.module.flow.PriorityModifier;
import org.ow2.petals.system.persistence.PersistenceService;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class), @Interface(name="prioritymodifier", signature=PriorityModifier.class)})
public class PriorityOrdererModule
implements NotificationListener,
BindingController,
LifeCycleController,
SenderModule,
PriorityModifier {
    private LoggingUtil log;
    @Requires(name="persistence", signature=PersistenceService.class)
    private PersistenceService persistenceService;
    public static final String PROPERTY_ROUTER_PRIORITY = "org.petals.ow2.router.priority";
    public static final long TIMEOUT_MANAGER_PERIOD = 1000L;
    private Deque<MessageExchangeWrapper> exchangePriority0;
    private Deque<MessageExchangeWrapper> exchangePriority1;
    private Deque<MessageExchangeWrapper> exchangePriority2;
    private Deque<MessageExchangeWrapper> exchangePriority3;
    private Map<MessageExchangeWrapper, Long> exchangeTimeouts;
    private AtomicLong pendingExchanges;
    private PriorityProcessor priorityProcessor;
    private Timer timeoutManagerTimer;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeWrapper messageExchangeWrapper) throws RoutingException {
        String string = (String)messageExchangeWrapper.getProperty(PROPERTY_ROUTER_PRIORITY);
        if (string == null) return;
        String string2 = messageExchangeWrapper.getExchangeId();
        synchronized (string2) {
            Deque<MessageExchangeWrapper> deque;
            if ("3".equals(string)) {
                deque = this.exchangePriority3;
                synchronized (deque) {
                    this.log.debug((Object)("Add Exchange with Id '" + messageExchangeWrapper.getExchangeId() + "' to priority 3"));
                    this.exchangePriority3.add(messageExchangeWrapper);
                }
            }
            if ("2".equals(string)) {
                deque = this.exchangePriority2;
                synchronized (deque) {
                    this.log.debug((Object)("Add Exchange with Id '" + messageExchangeWrapper.getExchangeId() + "' to priority 2"));
                    this.exchangePriority2.add(messageExchangeWrapper);
                }
            }
            if ("1".equals(string)) {
                deque = this.exchangePriority1;
                synchronized (deque) {
                    this.log.debug((Object)("Add Exchange with Id '" + messageExchangeWrapper.getExchangeId() + "' to priority 1"));
                    this.exchangePriority1.add(messageExchangeWrapper);
                }
            }
            if ("0".equals(string)) {
                deque = this.exchangePriority0;
                synchronized (deque) {
                    this.log.debug((Object)("Add Exchange with Id '" + messageExchangeWrapper.getExchangeId() + "' to priority 0"));
                    this.exchangePriority0.add(messageExchangeWrapper);
                    this.exchangeTimeouts.put(messageExchangeWrapper, (Long)messageExchangeWrapper.getProperty("org.ow2.petals.router.timetolive"));
                }
            }
            if (this.pendingExchanges.getAndIncrement() == 0L) {
                this.timeoutManagerTimer = new Timer("Router - Priority orderer module - Timeout manager");
                this.timeoutManagerTimer.schedule((TimerTask)new TimeoutManager(), 1000L, 1000L);
                LockSupport.unpark(this.priorityProcessor);
            }
            try {
                try {
                    messageExchangeWrapper.getExchangeId().wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!(this.exchangePriority3.remove(messageExchangeWrapper) || this.exchangePriority2.remove(messageExchangeWrapper) || this.exchangePriority1.remove(messageExchangeWrapper))) {
                        if (!this.exchangePriority0.remove(messageExchangeWrapper)) throw new RoutingException("Message Exchange with Id '" + messageExchangeWrapper.getExchangeId() + "' has been interrupted from priority ordering", interruptedException);
                    }
                    this.pendingExchanges.decrementAndGet();
                    throw new RoutingException("Message Exchange with Id '" + messageExchangeWrapper.getExchangeId() + "' has been interrupted from priority ordering", interruptedException);
                }
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                messageExchangeWrapper.setProperty(PROPERTY_ROUTER_PRIORITY, null);
                throw throwable;
            }
            messageExchangeWrapper.setProperty(PROPERTY_ROUTER_PRIORITY, null);
            return;
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("persistence")) {
            if (!PersistenceService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + PersistenceService.class.getName());
            }
            this.persistenceService = (PersistenceService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("persistence");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("persistence")) {
            return this.persistenceService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object object) {
        if ("java.management.memory.threshold.exceeded".equals(notification.getType())) {
            Iterator<MessageExchangeWrapper> iterator;
            this.log.info((Object)"Memory threshold reached, persist some pending exchange if any");
            int n = this.exchangePriority0.size() + this.exchangePriority1.size() + this.exchangePriority2.size() + this.exchangePriority3.size();
            int n2 = 0;
            PersistedMessageExchangeWrapper persistedMessageExchangeWrapper = null;
            Deque<MessageExchangeWrapper> deque = this.exchangePriority0;
            synchronized (deque) {
                iterator = this.exchangePriority0.iterator();
                while (iterator.hasNext()) {
                    try {
                        persistedMessageExchangeWrapper = (PersistedMessageExchangeWrapper)iterator.next();
                        if (persistedMessageExchangeWrapper.isMessageExchangeStored()) continue;
                        persistedMessageExchangeWrapper.persistExchange(this.persistenceService);
                        this.log.debug((Object)("Persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"));
                        ++n2;
                    }
                    catch (SQLException sQLException) {
                        this.log.warning((Object)("Failed to persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"), (Throwable)sQLException);
                    }
                    catch (IOException iOException) {
                        this.log.warning((Object)("Failed to store a monitored exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"), (Throwable)iOException);
                    }
                }
            }
            if (n2 < n / 2) {
                deque = this.exchangePriority1;
                synchronized (deque) {
                    iterator = this.exchangePriority1.iterator();
                    int n3 = this.exchangePriority1.size() / 2;
                    while (iterator.hasNext() && n3 > 0) {
                        try {
                            persistedMessageExchangeWrapper = (PersistedMessageExchangeWrapper)iterator.next();
                            if (persistedMessageExchangeWrapper.isMessageExchangeStored()) continue;
                            persistedMessageExchangeWrapper.persistExchange(this.persistenceService);
                            this.log.debug((Object)("Persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"));
                            ++n2;
                            ++n3;
                        }
                        catch (SQLException sQLException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"), (Throwable)sQLException);
                        }
                        catch (IOException iOException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"), (Throwable)iOException);
                        }
                    }
                }
            }
            if (n2 < n / 2) {
                deque = this.exchangePriority2;
                synchronized (deque) {
                    iterator = this.exchangePriority2.iterator();
                    int n4 = this.exchangePriority2.size() / 2;
                    while (iterator.hasNext() && n4 > 0) {
                        try {
                            persistedMessageExchangeWrapper = (PersistedMessageExchangeWrapper)iterator.next();
                            if (persistedMessageExchangeWrapper.isMessageExchangeStored()) continue;
                            persistedMessageExchangeWrapper.persistExchange(this.persistenceService);
                            this.log.debug((Object)("Persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"));
                            ++n2;
                            ++n4;
                        }
                        catch (SQLException sQLException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"), (Throwable)sQLException);
                        }
                        catch (IOException iOException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"), (Throwable)iOException);
                        }
                    }
                }
            }
            if (n2 < n / 2) {
                deque = this.exchangePriority3;
                synchronized (deque) {
                    iterator = this.exchangePriority3.iterator();
                    int n5 = this.exchangePriority3.size() / 2;
                    while (iterator.hasNext() && n5 > 0) {
                        try {
                            if (persistedMessageExchangeWrapper.isMessageExchangeStored()) continue;
                            persistedMessageExchangeWrapper = (PersistedMessageExchangeWrapper)iterator.next();
                            persistedMessageExchangeWrapper.persistExchange(this.persistenceService);
                            this.log.debug((Object)("Persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"));
                            ++n2;
                            ++n5;
                        }
                        catch (SQLException sQLException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"), (Throwable)sQLException);
                        }
                        catch (IOException iOException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + persistedMessageExchangeWrapper.getExchangeId() + "'"), (Throwable)iOException);
                        }
                    }
                }
            }
        }
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("persistence")) {
            this.persistenceService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyPriority(MessageExchangeWrapper messageExchangeWrapper, short s) throws RoutingException {
        this.log.call((Object)("Exchange Id '" + messageExchangeWrapper.getExchangeId() + "' - Priority " + s));
        boolean bl = false;
        Deque<MessageExchangeWrapper> deque = this.exchangePriority3;
        synchronized (deque) {
            bl = this.exchangePriority3.remove(messageExchangeWrapper);
        }
        if (!bl) {
            deque = this.exchangePriority2;
            synchronized (deque) {
                bl = this.exchangePriority2.remove(messageExchangeWrapper);
            }
        }
        if (!bl) {
            deque = this.exchangePriority1;
            synchronized (deque) {
                bl = this.exchangePriority1.remove(messageExchangeWrapper);
            }
        }
        if (!bl) {
            deque = this.exchangePriority0;
            synchronized (deque) {
                bl = this.exchangePriority0.remove(messageExchangeWrapper);
                this.exchangeTimeouts.remove(messageExchangeWrapper);
            }
        }
        if (!bl) {
            throw new RoutingException("The Message exchange with Id '" + messageExchangeWrapper.getExchangeId() + "' is no more in priority queues");
        }
        if (s == 3) {
            deque = this.exchangePriority3;
            synchronized (deque) {
                this.exchangePriority3.add(messageExchangeWrapper);
            }
        } else if (s == 2) {
            deque = this.exchangePriority2;
            synchronized (deque) {
                this.exchangePriority2.add(messageExchangeWrapper);
            }
        } else if (s == 1) {
            deque = this.exchangePriority1;
            synchronized (deque) {
                this.exchangePriority1.add(messageExchangeWrapper);
            }
        } else if (s == 0) {
            deque = this.exchangePriority0;
            synchronized (deque) {
                this.exchangePriority0.add(messageExchangeWrapper);
                this.exchangeTimeouts.put(messageExchangeWrapper, (Long)messageExchangeWrapper.getProperty("org.ow2.petals.router.timetolive"));
            }
        } else {
            throw new RoutingException("Priority " + s + " is not supported");
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.JBI-Messaging.PriorityOrdererModule"));
        this.log.call();
        this.pendingExchanges = new AtomicLong();
        this.exchangePriority0 = new ArrayDeque<MessageExchangeWrapper>();
        this.exchangePriority1 = new ArrayDeque<MessageExchangeWrapper>();
        this.exchangePriority2 = new ArrayDeque<MessageExchangeWrapper>();
        this.exchangePriority3 = new ArrayDeque<MessageExchangeWrapper>();
        this.exchangeTimeouts = new ConcurrentHashMap<MessageExchangeWrapper, Long>();
        for (MemoryPoolMXBean platformManagedObject2 : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!MemoryType.HEAP.equals((Object)platformManagedObject2.getType()) || !platformManagedObject2.isUsageThresholdSupported()) continue;
            long l = platformManagedObject2.getUsage().getMax();
            Double d = new Double((double)l * 0.8);
            platformManagedObject2.setUsageThreshold(d.longValue());
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        ((NotificationEmitter)((Object)memoryMXBean)).addNotificationListener(this, null, null);
        this.priorityProcessor = new PriorityProcessor();
        this.priorityProcessor.start();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
        this.priorityProcessor.isRunning = false;
        LockSupport.unpark(this.priorityProcessor);
        if (this.timeoutManagerTimer != null) {
            this.timeoutManagerTimer.cancel();
        }
    }

    private class PriorityProcessor
    extends Thread {
        public boolean isRunning = true;

        private PriorityProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.isRunning) {
                String string;
                if (PriorityOrdererModule.this.pendingExchanges.get() == 0L) {
                    if (PriorityOrdererModule.this.timeoutManagerTimer != null) {
                        PriorityOrdererModule.this.timeoutManagerTimer.cancel();
                        PriorityOrdererModule.this.timeoutManagerTimer = null;
                    }
                    LockSupport.park(this);
                }
                int n = 3;
                MessageExchangeWrapper messageExchangeWrapper = null;
                Deque deque = PriorityOrdererModule.this.exchangePriority3;
                synchronized (deque) {
                    while (n > 0) {
                        messageExchangeWrapper = (MessageExchangeWrapper)PriorityOrdererModule.this.exchangePriority3.pollLast();
                        if (messageExchangeWrapper != null) {
                            string = messageExchangeWrapper.getExchangeId();
                            synchronized (string) {
                                messageExchangeWrapper.getExchangeId().notify();
                            }
                            PriorityOrdererModule.this.pendingExchanges.decrementAndGet();
                            n = (short)(n - 1);
                            continue;
                        }
                        n = 0;
                    }
                }
                n = 2;
                messageExchangeWrapper = null;
                deque = PriorityOrdererModule.this.exchangePriority2;
                synchronized (deque) {
                    while (n > 0) {
                        messageExchangeWrapper = (MessageExchangeWrapper)PriorityOrdererModule.this.exchangePriority2.pollLast();
                        if (messageExchangeWrapper != null) {
                            string = messageExchangeWrapper.getExchangeId();
                            synchronized (string) {
                                messageExchangeWrapper.getExchangeId().notify();
                            }
                            PriorityOrdererModule.this.pendingExchanges.decrementAndGet();
                            n = (short)(n - 1);
                            continue;
                        }
                        n = 0;
                    }
                }
                messageExchangeWrapper = null;
                deque = PriorityOrdererModule.this.exchangePriority1;
                synchronized (deque) {
                    messageExchangeWrapper = (MessageExchangeWrapper)PriorityOrdererModule.this.exchangePriority1.pollLast();
                    if (messageExchangeWrapper != null) {
                        string = messageExchangeWrapper.getExchangeId();
                        synchronized (string) {
                            messageExchangeWrapper.getExchangeId().notify();
                        }
                        PriorityOrdererModule.this.pendingExchanges.decrementAndGet();
                    }
                }
            }
        }
    }

    private class TimeoutManager
    extends TimerTask {
        private TimeoutManager() {
        }

        public void run() {
            long l = System.currentTimeMillis();
            for (MessageExchangeWrapper messageExchangeWrapper : PriorityOrdererModule.this.exchangeTimeouts.keySet()) {
                Long l2 = (Long)PriorityOrdererModule.this.exchangeTimeouts.get(messageExchangeWrapper);
                if (l2 == null || l <= l2) continue;
                messageExchangeWrapper.setTimeout(true);
                PriorityOrdererModule.this.log.debug((Object)("Exchange with Id '" + messageExchangeWrapper.getExchangeId() + "' is in send timeout"));
                try {
                    PriorityOrdererModule.this.modifyPriority(messageExchangeWrapper, (short)3);
                }
                catch (RoutingException routingException) {}
            }
        }
    }
}

