/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader.locator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.ow2.petals.system.classloader.locator.LocatorAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileLocator
extends LocatorAbstract {
    private JarFile file;

    public JarFileLocator(URL uRL) throws IOException {
        String string = uRL.getFile();
        this.file = new JarFile(string);
    }

    @Override
    public boolean hasDirectory(String string) {
        boolean bl = false;
        Enumeration<JarEntry> enumeration = this.file.entries();
        while (enumeration.hasMoreElements() && !bl) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFile(String string) {
        ZipEntry zipEntry = this.file.getEntry(string);
        return zipEntry != null;
    }

    @Override
    public List<String> listContent(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<JarEntry> enumeration = this.file.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().startsWith(string)) continue;
            arrayList.add(zipEntry.getName());
        }
        return arrayList;
    }
}

