/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.local;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.transport.TransportException;
import org.ow2.petals.transport.TransportListener;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.transport.util.TransporterUtil;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=Transporter.class)})
public class LocalTransporterImpl
implements BindingController,
LifeCycleController,
Transporter {
    @Requires(name="transportlistener", signature=TransportListener.class)
    private TransportListener transportListener;
    private LoggingUtil log;
    private List<MessageExchange> pendingSyncExchanges;
    private boolean stopTraffic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTraffic() {
        this.log.start();
        this.stopTraffic = true;
        boolean bl = true;
        while (bl) {
            try {
                Iterator<MessageExchange> iterator = this.pendingSyncExchanges.iterator();
                while (iterator.hasNext()) {
                    MessageExchange messageExchange;
                    MessageExchange messageExchange2 = messageExchange = iterator.next();
                    synchronized (messageExchange2) {
                        messageExchange.notify();
                    }
                }
                bl = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.log.end();
    }

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MessageExchangeWrapper messageExchangeWrapper, TransportSendContext transportSendContext) throws TransportException {
        this.log.start();
        this.checkTransporterState();
        this.transportListener.exchangeSent(messageExchangeWrapper);
        if (TransporterUtil.getSyncMode(messageExchangeWrapper, true)) {
            this.pendingSyncExchanges.remove(messageExchangeWrapper);
            MessageExchangeWrapper messageExchangeWrapper2 = messageExchangeWrapper;
            synchronized (messageExchangeWrapper2) {
                messageExchangeWrapper.notify();
            }
        } else {
            this.transportListener.onExchange(messageExchangeWrapper);
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSync(MessageExchangeWrapper messageExchangeWrapper, TransportSendContext transportSendContext) throws TransportException {
        boolean bl;
        this.log.start();
        this.checkTransporterState();
        try {
            bl = TransporterUtil.setSendSyncProperties(messageExchangeWrapper);
        }
        catch (MessagingException messagingException) {
            throw new TransportException(messagingException);
        }
        this.transportListener.exchangeSent(messageExchangeWrapper);
        MessageExchangeWrapper messageExchangeWrapper2 = messageExchangeWrapper;
        synchronized (messageExchangeWrapper2) {
            if (bl) {
                messageExchangeWrapper.notify();
            } else {
                this.pendingSyncExchanges.add((MessageExchange)messageExchangeWrapper);
            }
            try {
                if (!bl) {
                    this.transportListener.onExchange(messageExchangeWrapper);
                }
                messageExchangeWrapper.wait(transportSendContext.timeout);
            }
            catch (InterruptedException interruptedException) {
                throw new TransportException("Failed to receive the response message of a synchronous send", interruptedException);
            }
        }
        if (!TransporterUtil.updateSyncProperties(messageExchangeWrapper) && this.pendingSyncExchanges.contains(messageExchangeWrapper)) {
            this.checkTransporterState();
            this.pendingSyncExchanges.remove(messageExchangeWrapper);
            messageExchangeWrapper.setTimeout(true);
            this.log.warning((Object)("Failed to send synchronously the exchange: " + messageExchangeWrapper.getExchangeId() + ". Timeout occured"));
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws Exception {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Transporter.LocalTransporter"));
        this.log.call();
        this.pendingSyncExchanges = new Vector<MessageExchange>(100);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws Exception {
        this.log.call();
    }

    private void checkTransporterState() throws TransportException {
        if (this.stopTraffic) {
            Thread.currentThread().interrupt();
            throw new TransportException("The Transporter traffic is stopped", new InterruptedException());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("transportlistener")) {
            if (!TransportListener.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TransportListener.class.getName());
            }
            this.transportListener = (TransportListener)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("transportlistener");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("transportlistener")) {
            return this.transportListener;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("transportlistener")) {
            this.transportListener = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

