/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.dragon.connection.api.service.EeType;
import org.ow2.dragon.connection.api.service.FedPattern;
import org.ow2.dragon.connection.api.service.Node;
import org.ow2.dragon.connection.api.to.Endpoint;
import org.ow2.dragon.connection.api.to.EnvironmentFederation;
import org.ow2.dragon.connection.api.to.ExecutionEnvironment;
import org.ow2.dragon.connection.api.to.ExecutionEnvironmentManager;
import org.ow2.dragon.connection.api.to.HashMapEntryType;
import org.ow2.dragon.connection.api.to.Processor;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlReaders;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlWriters;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="webservice", signature=org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager.class), @Interface(name="service", signature=KernelWebService.class)})
public class DragonConnectionServiceImpl
implements BindingController,
LifeCycleController,
org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager,
KernelWebService {
    private Component component;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    private EndpointRegistry endpointRegistry;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(contingency=Contingency.OPTIONAL, name="topology", signature=TopologyService.class)
    private TopologyService topologyService;
    @Requires(name="adminService", signature=AdminService.class)
    private AdminService adminService;
    private LoggingUtil log;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.WS.DragonConnectionService"));
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public List<ExecutionEnvironment> getFederationMembers(String string) {
        ArrayList<ExecutionEnvironment> arrayList = new ArrayList<ExecutionEnvironment>();
        Set<ContainerConfiguration> set = this.getContainersConfiguration();
        for (ContainerConfiguration containerConfiguration : set) {
            if (!this.isInFederation(containerConfiguration, string)) continue;
            arrayList.add(this.getExecutionEnvironment(containerConfiguration));
        }
        return arrayList;
    }

    @Override
    public List<Endpoint> getHostedEndpointsOnExecEnv(String string) {
        return this.getEndpointsForContainer(string);
    }

    @Override
    public List<Endpoint> getHostedEndpointsOnProcessor(String string) {
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        Set<ContainerConfiguration> set = this.getContainersForProcessor(string);
        for (ContainerConfiguration containerConfiguration : set) {
            arrayList.addAll(this.getEndpointsForContainer(containerConfiguration.getName()));
        }
        return arrayList;
    }

    @Override
    public List<ExecutionEnvironment> getManagedExecutionEnvironments() {
        ArrayList<ExecutionEnvironment> arrayList = new ArrayList<ExecutionEnvironment>();
        Set<ContainerConfiguration> set = this.getContainersConfiguration();
        for (ContainerConfiguration containerConfiguration : set) {
            arrayList.add(this.getExecutionEnvironment(containerConfiguration));
        }
        return arrayList;
    }

    @Override
    public ExecutionEnvironmentManager getProperties() {
        ExecutionEnvironmentManager executionEnvironmentManager = new ExecutionEnvironmentManager();
        executionEnvironmentManager.setName("Manager@PEtALS-ESB:" + this.configurationService.getContainerConfiguration().getName());
        return executionEnvironmentManager;
    }

    private ExecutionEnvironment getExecutionEnvironment(ContainerConfiguration containerConfiguration) {
        EnvironmentFederation environmentFederation = new EnvironmentFederation();
        environmentFederation.setName(this.configurationService.getDomainConfiguration().getName());
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment();
        executionEnvironment.setEndpoints(new Node.Endpoints());
        executionEnvironment.setProperties(new Node.Properties());
        executionEnvironment.setIpv4Address(containerConfiguration.getHost());
        executionEnvironment.setEnvType(EeType.ESB);
        executionEnvironment.setType("PEtALS");
        executionEnvironment.setVersion(this.adminService.getSystemInfo());
        executionEnvironment.setName(containerConfiguration.getName());
        if (this.isStandalone()) {
            executionEnvironment.setRoleInFederation("standalone");
        } else {
            executionEnvironment.setRoleInFederation("peer");
        }
        environmentFederation.setPattern(FedPattern.DISTRIBUTED);
        executionEnvironment.setParentFederation(environmentFederation);
        List<Endpoint> list = this.getEndpointsForContainer(containerConfiguration.getName());
        executionEnvironment.getEndpoints().getEndpoint().addAll(list);
        executionEnvironment.setHostProcessor(this.getProcessor(containerConfiguration));
        executionEnvironment.getProperties().getProperty().addAll(this.getProperties(containerConfiguration));
        return executionEnvironment;
    }

    private Set<ContainerConfiguration> getContainersConfiguration() {
        Set<ContainerConfiguration> set = null;
        if (this.isStandalone()) {
            ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
            set = new HashSet<ContainerConfiguration>();
            set.add(containerConfiguration);
        } else {
            set = this.topologyService.getContainersConfiguration(null);
        }
        return set;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Endpoint> getEndpointsForContainer(String string) {
        List<ServiceEndpoint> list;
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        try {
            list = this.endpointRegistry.getEndpoints();
        }
        catch (RegistryException registryException) {
            return arrayList;
        }
        Iterator<ServiceEndpoint> iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceEndpoint serviceEndpoint = iterator.next();
            if (!string.equals(serviceEndpoint.getLocation().getContainerName())) continue;
            Endpoint endpoint = new Endpoint();
            QName qName = QName.valueOf(serviceEndpoint.getEndpointName());
            endpoint.setName(qName);
            try {
                Object var17_21;
                WSDL4ComplexWsdlReader wSDL4ComplexWsdlReader = null;
                WSDL4ComplexWsdlWriter wSDL4ComplexWsdlWriter = null;
                try {
                    Object object2;
                    wSDL4ComplexWsdlReader = WSDL4ComplexWsdlReaders.takeWSDL4ComplexWsdlReader();
                    Description description = wSDL4ComplexWsdlReader.read(serviceEndpoint.getDescription());
                    Map map = description.deleteImportedDocumentsInWsdl();
                    wSDL4ComplexWsdlWriter = WSDL4ComplexWsdlWriters.takeWSDL4ComplexWsdlWriter();
                    String string2 = wSDL4ComplexWsdlWriter.writeWSDL4ComplexWsdl(description);
                    endpoint.setWsdlDescription(string2);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (map != null) {
                        for (Object object2 : map.keySet()) {
                            try {
                                hashMap.put(((URI)object2).toString(), XMLHelper.createStringFromDOMDocument((Node)((Node)map.get(object2))));
                            }
                            catch (TransformerException transformerException) {
                                this.log.warning((Object)transformerException.getMessage());
                            }
                            catch (PoolException poolException) {
                                this.log.warning((Object)poolException.getMessage());
                            }
                        }
                    }
                    object2 = hashMap.entrySet().iterator();
                    while (true) {
                        block19: {
                            if (object2.hasNext()) break block19;
                            arrayList.add(endpoint);
                            break;
                        }
                        Map.Entry entry = object2.next();
                        HashMapEntryType hashMapEntryType = new HashMapEntryType();
                        hashMapEntryType.setKey((String)entry.getKey());
                        hashMapEntryType.setValue((String)entry.getValue());
                        endpoint.getWsdlDescriptionImports().getEntry().add(hashMapEntryType);
                    }
                }
                catch (Throwable throwable) {
                    var17_21 = null;
                    if (wSDL4ComplexWsdlReader != null) {
                        WSDL4ComplexWsdlReaders.releaseWSDL4ComplexWsdlReader((WSDL4ComplexWsdlReader)wSDL4ComplexWsdlReader);
                    }
                    if (wSDL4ComplexWsdlReader != null) {
                        WSDL4ComplexWsdlWriters.releaseWSDL4ComplexWsdlWriter(wSDL4ComplexWsdlWriter);
                    }
                    throw throwable;
                }
                {
                    var17_21 = null;
                    if (wSDL4ComplexWsdlReader != null) {
                        WSDL4ComplexWsdlReaders.releaseWSDL4ComplexWsdlReader((WSDL4ComplexWsdlReader)wSDL4ComplexWsdlReader);
                    }
                    if (wSDL4ComplexWsdlReader == null) continue;
                    WSDL4ComplexWsdlWriters.releaseWSDL4ComplexWsdlWriter((WSDL4ComplexWsdlWriter)wSDL4ComplexWsdlWriter);
                    continue;
                }
            }
            catch (WSDL4ComplexWsdlException wSDL4ComplexWsdlException) {
                this.log.warning((Object)wSDL4ComplexWsdlException.getMessage());
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.log.warning((Object)uRISyntaxException.getMessage());
                continue;
            }
            break;
        }
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        if (string.equals("adminService")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("endpoint");
        arrayList.add("configuration");
        arrayList.add("topology");
        arrayList.add("adminService");
        return arrayList.toArray(new String[0]);
    }

    private Processor getProcessor(ContainerConfiguration containerConfiguration) {
        Processor processor = new Processor();
        processor.setIpv4Address(containerConfiguration.getHost());
        processor.setName("ProcessorName-" + containerConfiguration.getName());
        processor.setType("Unknown");
        return processor;
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("topology")) {
            return this.topologyService;
        }
        if (string.equals("adminService")) {
            return this.adminService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private List<String> getProperties(ContainerConfiguration containerConfiguration) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Description=" + containerConfiguration.getDescription());
        arrayList.add("State=" + (Object)((Object)containerConfiguration.getState()));
        return arrayList;
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        if (string.equals("adminService")) {
            this.adminService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private Set<ContainerConfiguration> getContainersForProcessor(String string) {
        HashSet<ContainerConfiguration> hashSet = new HashSet<ContainerConfiguration>();
        Set<ContainerConfiguration> set = this.getContainersConfiguration();
        for (ContainerConfiguration containerConfiguration : set) {
            if (!string.equals(containerConfiguration.getName())) continue;
            hashSet.add(containerConfiguration);
        }
        return hashSet;
    }

    private boolean isInFederation(ContainerConfiguration containerConfiguration, String string) {
        return string.equals(containerConfiguration.getSubdomainName());
    }

    private boolean isStandalone() {
        return this.topologyService == null;
    }
}

