/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws.adapters;

import java.net.URI;
import java.net.URISyntaxException;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.configuration.JndiConfiguration;
import org.ow2.petals.kernel.configuration.SubDomainConfiguration;
import org.ow2.petals.kernel.ws.api.to.ContainerInformation;
import org.ow2.petals.kernel.ws.api.to.DomainInformation;
import org.ow2.petals.kernel.ws.api.to.JmxServiceInformation;
import org.ow2.petals.kernel.ws.api.to.JndiInformation;
import org.ow2.petals.kernel.ws.api.to.RegistryServiceInformation;
import org.ow2.petals.kernel.ws.api.to.SubdomainInformation;
import org.ow2.petals.kernel.ws.api.to.TransportServiceInformation;
import org.ow2.petals.kernel.ws.api.to.WebServiceServiceInformation;
import org.ow2.petals.topology.generated.SubdomainMode;

public class TopologyInformationToTopologyConfiguration {
    public static ContainerConfiguration containerInformationToContainerConfiguration(ContainerInformation containerInformation) throws PetalsException {
        WebServiceServiceInformation webServiceServiceInformation;
        RegistryServiceInformation registryServiceInformation;
        TransportServiceInformation transportServiceInformation;
        ContainerConfiguration containerConfiguration = new ContainerConfiguration();
        if (containerInformation == null) {
            return null;
        }
        containerConfiguration.setName(containerInformation.getName());
        containerConfiguration.setDescription(containerInformation.getDescription());
        containerConfiguration.setHost(containerInformation.getHost());
        containerConfiguration.setUser(containerInformation.getUser());
        containerConfiguration.setPassword(containerInformation.getPassword());
        JmxServiceInformation jmxServiceInformation = containerInformation.getJmxService();
        if (jmxServiceInformation != null) {
            containerConfiguration.setJmxRMIConnectorPort(jmxServiceInformation.getRmiPort());
        }
        if ((transportServiceInformation = containerInformation.getTransportService()) != null) {
            containerConfiguration.setTCPPort(transportServiceInformation.getTcpPort());
        }
        if ((registryServiceInformation = containerInformation.getRegistryService()) != null) {
            containerConfiguration.setRegistryPort(registryServiceInformation.getPort());
        }
        if ((webServiceServiceInformation = containerInformation.getWebserviceService()) != null) {
            containerConfiguration.setWebservicePort(webServiceServiceInformation.getPort());
            containerConfiguration.setWebservicePrefix(webServiceServiceInformation.getPrefix());
        }
        ContainerConfiguration.RegistryMode registryMode = null;
        switch (containerInformation.getNodeType()) {
            case MASTER: {
                registryMode = ContainerConfiguration.RegistryMode.MASTER;
                break;
            }
            case SLAVE: {
                registryMode = ContainerConfiguration.RegistryMode.SLAVE;
                break;
            }
            case PEER: {
                registryMode = ContainerConfiguration.RegistryMode.PEER;
                break;
            }
            case STANDALONE: {
                registryMode = ContainerConfiguration.RegistryMode.STANDALONE;
                break;
            }
            default: {
                throw new PetalsException("Unknown registry mode");
            }
        }
        containerConfiguration.setRegistryMode(registryMode);
        return containerConfiguration;
    }

    public static SubDomainConfiguration subdomainInformationToSubDomainConfiguration(SubdomainInformation subdomainInformation) throws PetalsException {
        SubdomainMode subdomainMode;
        SubDomainConfiguration subDomainConfiguration = new SubDomainConfiguration();
        if (subdomainInformation == null) {
            return null;
        }
        subDomainConfiguration.setName(subdomainInformation.getName());
        subDomainConfiguration.setDescription(subdomainInformation.getDescription());
        subDomainConfiguration.setNetworkTimeSynchronized(subdomainInformation.isNetworkTimeSynchronized());
        switch (subdomainInformation.getSubdomainMode()) {
            case MASTERSLAVE: {
                subdomainMode = SubdomainMode.MASTER_SLAVE;
                break;
            }
            case FLOODING: {
                subdomainMode = SubdomainMode.FLOODING;
                break;
            }
            case STANDALONE: {
                subdomainMode = SubdomainMode.STANDALONE;
                break;
            }
            default: {
                throw new PetalsException("Unknown subdomain mode");
            }
        }
        subDomainConfiguration.setMode(subdomainMode);
        return subDomainConfiguration;
    }

    public static DomainConfiguration domainInformationToDomainInformation(DomainInformation domainInformation) throws PetalsException {
        Object object;
        DomainConfiguration domainConfiguration = new DomainConfiguration();
        if (domainInformation == null) {
            return null;
        }
        domainConfiguration.setName(domainInformation.getName());
        domainConfiguration.setDescription(domainInformation.getDescription());
        JndiInformation jndiInformation = domainInformation.getJndi();
        if (jndiInformation != null) {
            try {
                object = new JndiConfiguration();
                domainConfiguration.setJndiConfiguration((JndiConfiguration)object);
                ((JndiConfiguration)object).setJndiProviderUrl(new URI(jndiInformation.getProviderUrl()));
                ((JndiConfiguration)object).setJndiFactory(jndiInformation.getFactory());
                ((JndiConfiguration)object).setJndiBatchSize(jndiInformation.getBatchSize());
                ((JndiConfiguration)object).setJndiPoolSize(jndiInformation.getPoolSize());
                ((JndiConfiguration)object).setJndiSecurityPrincipal(jndiInformation.getSecurityPrincipal());
                ((JndiConfiguration)object).setJndiSecurityCredentials(jndiInformation.getSecurityCredentials());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new PetalsException("No valid URI found for the JNDI provider URL", (Throwable)uRISyntaxException);
            }
        }
        switch (domainConfiguration.getMode()) {
            case STATIC: {
                object = DomainConfiguration.DomainMode.STATIC;
                break;
            }
            case STANDALONE: {
                object = DomainConfiguration.DomainMode.STANDALONE;
                break;
            }
            case DYNAMIC: {
                object = DomainConfiguration.DomainMode.DYNAMIC;
                break;
            }
            default: {
                throw new PetalsException("Unknown domain mode");
            }
        }
        domainConfiguration.setMode((DomainConfiguration.DomainMode)((Object)object));
        return domainConfiguration;
    }
}

