/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.petals.jaas.GroupPrincipal;
import org.ow2.petals.jaas.UserPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesLoginModule
implements LoginModule {
    private static final String USER_FILE = "org.ow2.petals.security.properties.user";
    private static final String GROUP_FILE = "org.ow2.petals.security.properties.group";
    private static final String DEBUG = "debug";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String usersFile;
    private String groupsFile;
    private final Properties users = new Properties();
    private final Properties groups = new Properties();
    private String user;
    private final Set<Principal> principals = new HashSet<Principal>();
    private File baseDir;
    private boolean debug;
    private static final Logger logger = Logger.getLogger(PropertiesLoginModule.class.getName());

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        logger.info("Initializing login module");
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.baseDir = System.getProperty("java.security.auth.login.config") != null ? new File(System.getProperty("java.security.auth.login.config")).getParentFile() : new File(".");
        this.usersFile = options.get(USER_FILE).toString();
        this.groupsFile = options.get(GROUP_FILE).toString();
        Object tmp = options.get(DEBUG);
        if (tmp == null) {
            tmp = Boolean.FALSE.toString();
        }
        this.debug = Boolean.valueOf(tmp.toString());
        if (this.debug) {
            logger.info("Base dir : " + this.baseDir.getAbsolutePath());
            logger.info("Users file : " + this.usersFile + ", Groups file : " + this.groupsFile);
        }
    }

    @Override
    public boolean login() throws LoginException {
        String password;
        if (this.debug) {
            logger.info("Login");
        }
        File file = new File(this.baseDir, this.usersFile);
        try {
            this.users.load(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load user properties file " + file.getAbsolutePath());
        }
        file = new File(this.baseDir, this.groupsFile);
        try {
            this.groups.load(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load group properties file " + file.getAbsolutePath());
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if ((password = this.users.getProperty(this.user)) == null) {
            throw new FailedLoginException("User " + this.user + " does not exist");
        }
        String tmpPasswordString = new String(tmpPassword);
        if (!password.equals(tmpPasswordString)) {
            throw new FailedLoginException("Password does not match, file one is '" + password + "', retrieved one is '" + tmpPasswordString + "'");
        }
        this.users.clear();
        if (this.debug) {
            logger.info("User '" + this.user + "' is logged in");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.debug) {
            logger.fine("Commit");
        }
        this.principals.add(new UserPrincipal(this.user));
        Enumeration<Object> groupsKeys = this.groups.keys();
        block0: while (groupsKeys.hasMoreElements()) {
            String[] groupUsers;
            String groupName = (String)groupsKeys.nextElement();
            for (String userInGroup : groupUsers = this.groups.getProperty(groupName).split(",")) {
                if (!this.user.equals(userInGroup)) continue;
                this.principals.add(new GroupPrincipal(groupName));
                continue block0;
            }
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clean();
        if (this.debug) {
            logger.fine("Commit done");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            logger.fine("Abort");
        }
        this.clean();
        logger.fine("Abort done");
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        logger.fine("Logout");
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        logger.fine("Logout done");
        return true;
    }

    private void clean() {
        logger.fine("Clean");
        this.groups.clear();
        this.user = null;
        logger.fine("Clean done");
    }
}

