#!/bin/sh


usage() {
	echo "The debug.sh script is used to start Petals in debug mode."
	echo "usage : debug.sh [-h|-?]  [-P <profilerId>] [-M <time|memory|thread>]"
	echo "     -h|? : prints the help message"
	echo "     -P <profilerId> : Petals is starting in profiling mode instead of debug mode."
	echo "                       The Java Profiling Agent is defined by <profilerId>."
	echo "                             Possible values are:"
	echo "                                    'eclipse'  : to use the eclipse agent controler."
	echo "                                    'netbeans' : to use the netbeans agent (default value)."
	echo "     -M <time|memory|thread>: In case of the Eclispe profiling, use this parameter"
	echo "                                 to define the profiler library to load (ie. Agent Controller)."
	echo "                                 Possible values are:"
	echo "                                    'CGProf'     : execution time analysis (default value)."
	echo "                                    'HeapProf'   : object allocation/heap analysis."
	echo "                                    'ThreadProf' : thread analysis."
}

DIRNAME=`dirname "$0"`

PETALS_HOME=`cd $DIRNAME/..; pwd`
if [ ! -d "$PETALS_HOME" ]; then
   echo "PETALS_HOME is not valid: $PETALS_HOME"
   exit 1
fi

DebugMode=true
JAVA_OPTS="-Djava.net.preferIPv4Stack=true -Djavax.xml.transform.TransformerFactory=net.sf.saxon.TransformerFactoryImpl -Xmx1024m -XX:MaxPermSize=256m -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,address=8000,suspend=y"


PROFILER="netbeans"
LIBRARY="CGProf"

while getopts 'h?P:M:' OPT; do
	case "$OPT" in
	h|\?)
		usage
		exit 0
		;;
	P)
		DebugMode=false
		PROFILER="$OPTARG"
		;;
	M)
		DebugMode=false
		LIBRARY="$OPTARG"
		;;
	*)
		usage
		exit 2
	esac
done

shift `expr $OPTIND - 1`

case "$DebugMode" in
false)
	case "$PROFILER" in
	eclipse)
		echo "Eclipse Java Profiling Agent activated."
		if [ -z $TPTP_AC_HOME ]; then
			echo "The TPTP_AC_HOME Agent Controler Home variable is not set. Please initialize it in your environment."
			exit 1
		fi

		export JAVA_PROFILER_HOME="$TPTP_AC_HOME/plugins/org.eclipse.tptp.javaprofiler"
		export LD_LIBRARY_PATH="$JAVA_PROFILER_HOME:$TPTP_AC_HOME/lib:$LD_LIBRARY_PATH"
		export PATH="$JAVA_PROFILER_HOME:$PATH:$TPTP_AC_HOME/bin"
		JAVA_OPTS="$JAVA_OPTS -agentlib:JPIBootLoader=JPIAgent:server=enabled"

		case "$LIBRARY" in
		time)
			JAVA_OPTS="$JAVA_OPTS;CGProf:execdetails=true"
			;;
		memory)
			JAVA_OPTS="$JAVA_OPTS;HeapProf:allocsites=true"
			;;
		thread)
			JAVA_OPTS="$JAVA_OPTS;ThreadProf"
			;;
		*)
			echo "Unknown profiler library to load: $LIBRARY."
			exit 1
		esac	
		;;
	netbeans)
		echo "NetBeans Java Profiling Agent activated."
		if [ -z "$NETBEANS_PROFILER_HOME" ]; then
			echo "The NETBEANS_PROFILER_HOME variable is not set. Please initialize it on your environment."
			exit 1
		fi

		JAVA_OPTS="$JAVA_OPTS -agentpath:$NETBEANS_PROFILER_HOME/lib/deployed/jdk15/linux/libprofilerinterface.so=$NETBEANS_PROFILER_HOME/lib,5140"
		;;
	*)
		echo "Unknown Profiler: $PROFILER."
		exit 1
	esac
	;;
true)
	echo "Debug mode activated."
	;;
esac

export JAVA_OPTS
eval "$PETALS_HOME/bin/petals-esb.sh"

