/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jndi.agent.util;

import java.io.Serializable;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.ServiceUnavailableException;
import org.ow2.petals.communication.jndi.agent.AbstractJNDIAgentServiceImpl;
import org.ow2.petals.communication.jndi.client.naming.JNDIConnection;
import org.ow2.petals.communication.jndi.client.naming.JNDILocalConnection;
import org.ow2.petals.communication.jndi.client.naming.NamingConnection;
import org.ow2.petals.communication.jndi.client.naming.NamingContextImpl;
import org.ow2.petals.util.LoggingUtil;

public class RegistryUtil {
    private static final String SUBCONTEXT_KEYWORD = "subcontext";
    private AbstractJNDIAgentServiceImpl jndiAgentServiceImpl;
    private LoggingUtil log;

    public RegistryUtil(AbstractJNDIAgentServiceImpl abstractJNDIAgentServiceImpl) {
        this.jndiAgentServiceImpl = abstractJNDIAgentServiceImpl;
        this.log = this.jndiAgentServiceImpl.getLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Object object, Object object2, Object object3) throws NamingException {
        String string;
        this.log.start();
        if (object2 instanceof String) {
            string = (String)object2;
            if (string.length() == 0) {
                throw new InvalidNameException("Naming key must not be an empty String");
            }
        } else {
            throw new InvalidNameException("Naming key must be non null and a String");
        }
        if (!(object instanceof String)) {
            throw new InvalidNameException("Naming context must be non null and a String");
        }
        String string2 = (String)object;
        if (!(object3 instanceof Serializable)) {
            throw new InvalidNameException("Naming value must be a Serializable");
        }
        String string3 = String.valueOf(string2) + string;
        String string4 = string.contains("/") ? string3.substring(0, string3.lastIndexOf("/") + 1) : string2;
        String string5 = string3.substring(string3.lastIndexOf("/") + 1);
        if (this.jndiAgentServiceImpl.containsContext(string4)) {
            Map<String, Serializable> map;
            Map<String, Serializable> map2 = map = this.jndiAgentServiceImpl.getContext(string4);
            synchronized (map2) {
                if (map.containsKey(string5)) {
                    throw new NameAlreadyBoundException(String.valueOf(string5) + " is already bound in context " + string4);
                }
                map.put(string5, (Serializable)object3);
            }
        } else {
            throw new NotContextException("Context " + string4 + " does not exists");
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSubcontext(Object object, Object object2) throws NamingException {
        Map<String, Serializable> map;
        String string;
        this.log.start();
        if (object2 instanceof String) {
            string = (String)object2;
            if (string.length() == 0) {
                throw new InvalidNameException("Naming key must not be an empty String");
            }
        } else {
            throw new InvalidNameException("Naming key must be non null and a String");
        }
        if (!(object instanceof String)) {
            throw new InvalidNameException("Naming context must be non null and a String");
        }
        String string2 = (String)object;
        String string3 = String.valueOf(string2) + string;
        String string4 = string.contains("/") ? string3.substring(0, string3.lastIndexOf("/") + 1) : string2;
        string3 = String.valueOf(string3) + "/";
        if (!this.jndiAgentServiceImpl.containsContext(string4)) {
            throw new NotContextException("Context " + string4 + " does not exists");
        }
        Map<String, Serializable> map2 = map = this.jndiAgentServiceImpl.getContext(string4);
        synchronized (map2) {
            if (map.containsKey(string3)) {
                throw new NameAlreadyBoundException(String.valueOf(string3) + " is already bound in context " + string4);
            }
            this.jndiAgentServiceImpl.getContext(string3);
            map.put(string3, (Serializable)((Object)SUBCONTEXT_KEYWORD));
        }
        this.log.end();
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySubcontext(Object object, Object object2) throws NamingException {
        Map<String, Serializable> map;
        String string;
        this.log.start();
        if (object2 instanceof String) {
            string = (String)object2;
            if (string.length() == 0) {
                throw new InvalidNameException("Naming key must not be an empty String");
            }
        } else {
            throw new InvalidNameException("Naming key must be non null and a String");
        }
        if (!(object instanceof String)) {
            throw new InvalidNameException("Naming context must be non null and a String");
        }
        String string2 = (String)object;
        String string3 = String.valueOf(string2) + string;
        String string4 = string.contains("/") ? string3.substring(0, string3.lastIndexOf("/") + 1) : string2;
        string3 = String.valueOf(string3) + "/";
        if (!this.jndiAgentServiceImpl.containsContext(string4)) {
            throw new NotContextException("Context " + string4 + " does not exists");
        }
        if (!this.jndiAgentServiceImpl.containsContext(string3)) {
            throw new NotContextException("Context " + string3 + " does not exists");
        }
        Map<String, Serializable> map2 = map = this.jndiAgentServiceImpl.getContext(string4);
        synchronized (map2) {
            map.remove(string3);
            Map<String, Serializable> map3 = this.jndiAgentServiceImpl.getContext(string3);
            for (String string5 : map3.keySet()) {
                if (!string5.contains("/")) continue;
                this.destroySubcontext(string5);
            }
            this.jndiAgentServiceImpl.removeContext(string3);
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameClassPair[] list(Object object, Object object2) throws NamingException {
        Map<String, Serializable> map;
        String string;
        this.log.start();
        if (object2 instanceof String) {
            string = (String)object2;
            if (string.length() == 0) {
                throw new InvalidNameException("Naming key must not be an empty String");
            }
        } else {
            throw new InvalidNameException("Naming key must be non null and a String");
        }
        if (!(object instanceof String)) {
            throw new InvalidNameException("Naming context must be non null and a String");
        }
        String string2 = (String)object;
        NameClassPair[] nameClassPairArray = null;
        String string3 = "/".equals(string2) && "/".equals(string) ? "/" : String.valueOf(string2) + string + "/";
        if (!this.jndiAgentServiceImpl.containsContext(string3)) {
            throw new NotContextException("Context " + string3 + " does not exists");
        }
        Map<String, Serializable> map2 = map = this.jndiAgentServiceImpl.getContext(string3);
        synchronized (map2) {
            nameClassPairArray = new NameClassPair[map.keySet().size()];
            int n = 0;
            for (Map.Entry<String, Serializable> entry : map.entrySet()) {
                String string4 = entry.getKey();
                String string5 = null;
                if (entry.getValue() != null) {
                    if (string4.contains("/")) {
                        String[] stringArray = string4.split("/");
                        string4 = stringArray[stringArray.length - 1];
                        string5 = NamingContextImpl.class.getName();
                    } else {
                        string5 = entry.getValue().getClass().getName();
                    }
                }
                nameClassPairArray[n] = new NameClassPair(string4, string5);
                ++n;
            }
        }
        this.log.end();
        return nameClassPairArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding[] listBindings(Object object, Object object2, boolean bl) throws NamingException {
        Map<String, Serializable> map;
        String string;
        this.log.start();
        if (object2 instanceof String) {
            string = (String)object2;
            if (string.length() == 0) {
                throw new InvalidNameException("Naming key must not be an empty String");
            }
        } else {
            throw new InvalidNameException("Naming key must be non null and a String");
        }
        if (!(object instanceof String)) {
            throw new InvalidNameException("Naming context must be non null and a String");
        }
        String string2 = (String)object;
        Binding[] bindingArray = null;
        String string3 = "/".equals(string2) && "/".equals(string) ? "/" : String.valueOf(string2) + string + "/";
        if (!this.jndiAgentServiceImpl.containsContext(string3)) {
            throw new NotContextException("Context " + string3 + " does not exists");
        }
        Map<String, Serializable> map2 = map = this.jndiAgentServiceImpl.getContext(string3);
        synchronized (map2) {
            bindingArray = new Binding[map.keySet().size()];
            int n = 0;
            for (Map.Entry<String, Serializable> entry : map.entrySet()) {
                String[] stringArray;
                String string4 = entry.getKey();
                String string5 = null;
                Serializable serializable = entry.getValue();
                if (serializable != null) {
                    if (SUBCONTEXT_KEYWORD.equals(serializable)) {
                        NamingConnection namingConnection;
                        stringArray = string4.split("/");
                        string4 = stringArray[stringArray.length - 1];
                        string5 = NamingContextImpl.class.getName();
                        if (bl) {
                            namingConnection = new JNDILocalConnection(this.jndiAgentServiceImpl);
                        } else {
                            URI uRI = this.jndiAgentServiceImpl.getDomainConfiguration().getJndiConfiguration().getJndiProviderUrl();
                            namingConnection = new JNDIConnection(uRI);
                        }
                        serializable = new NamingContextImpl(new Hashtable<String, Object>(), namingConnection, entry.getKey(), bl);
                    } else {
                        string5 = entry.getValue().getClass().getName();
                    }
                }
                if (serializable instanceof LinkRef) {
                    stringArray = ((LinkRef)serializable).getLinkName();
                    try {
                        serializable = stringArray.startsWith(".") ? this.lookup(object, stringArray.substring(1), bl) : this.lookup("/", stringArray, bl);
                    }
                    catch (NamingException namingException) {
                        namingException.printStackTrace();
                        throw namingException;
                    }
                }
                bindingArray[n] = new Binding(string4, string5, serializable);
                ++n;
            }
        }
        this.log.end();
        return bindingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable lookup(Object object, Object object2, boolean bl) throws NamingException {
        String string;
        this.log.start();
        if (object2 instanceof String) {
            string = (String)object2;
            if (string.length() == 0) {
                throw new InvalidNameException("Naming key must not be an empty String");
            }
        } else {
            throw new InvalidNameException("Naming key must be non null and a String");
        }
        if (!(object instanceof String)) {
            throw new InvalidNameException("Naming context must be non null and a String");
        }
        String string2 = (String)object;
        Serializable serializable = null;
        String string3 = String.valueOf(string2) + string;
        String string4 = string3.substring(string3.lastIndexOf("/") + 1);
        String string5 = string.contains("/") ? string3.substring(0, string3.lastIndexOf("/") + 1) : string2;
        if (!this.jndiAgentServiceImpl.containsContext(string5)) {
            throw new NotContextException("Context " + string5 + " does not exists");
        }
        Map<String, Serializable> map = this.jndiAgentServiceImpl.getContext(string5);
        Object object3 = map;
        synchronized (object3) {
            if (map.containsKey(String.valueOf(string3) + "/")) {
                NamingConnection namingConnection = null;
                if (bl) {
                    namingConnection = new JNDILocalConnection(this.jndiAgentServiceImpl);
                } else {
                    URI uRI = this.jndiAgentServiceImpl.getDomainConfiguration().getJndiConfiguration().getJndiProviderUrl();
                    namingConnection = new JNDIConnection(uRI);
                }
                serializable = new NamingContextImpl(new Hashtable<String, Object>(), namingConnection, String.valueOf(string3) + "/", bl);
            } else if (map.containsKey(string4)) {
                serializable = map.get(string4);
            } else {
                throw new NameNotFoundException(String.valueOf(string4) + " is not bound in the context " + string5);
            }
        }
        if (serializable instanceof LinkRef) {
            object3 = ((LinkRef)serializable).getLinkName();
            serializable = ((String)object3).startsWith(".") ? this.lookup(object, ((String)object3).substring(1), bl) : this.lookup("/", object3, bl);
        }
        this.log.end();
        return serializable;
    }

    public Object lookupLink(Object object, Object object2, boolean bl) throws NamingException {
        this.log.call();
        return this.lookup(object, object2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(Object object, Object object2, Object object3) throws NamingException {
        Map<String, Serializable> map;
        String string;
        this.log.start();
        if (object2 instanceof String) {
            string = (String)object2;
            if (string.length() == 0) {
                throw new InvalidNameException("Naming key must not be an empty String");
            }
        } else {
            throw new InvalidNameException("Naming key must be non null and a String");
        }
        if (!(object instanceof String)) {
            throw new InvalidNameException("Naming context must be non null and a String");
        }
        String string2 = (String)object;
        if (!(object3 instanceof Serializable)) {
            throw new InvalidNameException("Naming value must be a Serializable");
        }
        String string3 = String.valueOf(string2) + string;
        String string4 = string3.substring(string3.lastIndexOf("/") + 1);
        String string5 = string.contains("/") ? string3.substring(0, string3.lastIndexOf("/") + 1) : string2;
        if (!this.jndiAgentServiceImpl.containsContext(string5)) {
            throw new NotContextException("Context " + string5 + " does not exists");
        }
        Map<String, Serializable> map2 = map = this.jndiAgentServiceImpl.getContext(string5);
        synchronized (map2) {
            map.put(string4, (Serializable)object3);
        }
        this.log.end();
    }

    public void rename(Object object, Object object2, Object object3, boolean bl) throws NamingException {
        this.log.start();
        if (!(object2 instanceof String)) {
            throw new InvalidNameException("Old key must be non null and a String");
        }
        if (!(object3 instanceof String)) {
            throw new InvalidNameException("New key must be non null and a String");
        }
        if (!(object instanceof String)) {
            throw new InvalidNameException("Context name must be non null and a String");
        }
        if (((String)object2).length() == 0) {
            throw new InvalidNameException("Old key must not be an empty String");
        }
        if (((String)object3).length() == 0) {
            throw new InvalidNameException("New key must not be an empty String");
        }
        Serializable serializable = this.lookup(object, object2, bl);
        this.unbind(object, object2);
        this.bind(object, object3, serializable);
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(Object object, Object object2) throws NamingException {
        Map<String, Serializable> map;
        String string;
        this.log.start();
        if (object2 instanceof String) {
            string = (String)object2;
            if (string.length() == 0) {
                throw new InvalidNameException("Naming key must not be an empty String");
            }
        } else {
            throw new InvalidNameException("Naming key must be non null and a String");
        }
        if (!(object instanceof String)) {
            throw new InvalidNameException("Naming context must be non null and a String");
        }
        String string2 = (String)object;
        String string3 = String.valueOf(string2) + string;
        String string4 = string3.substring(string3.lastIndexOf("/") + 1);
        String string5 = string.contains("/") ? string3.substring(0, string3.lastIndexOf("/") + 1) : string2;
        if (!this.jndiAgentServiceImpl.containsContext(string5)) {
            throw new NotContextException("Context " + string5 + " does not exists");
        }
        Map<String, Serializable> map2 = map = this.jndiAgentServiceImpl.getContext(string5);
        synchronized (map2) {
            if (map.remove(string4) == null) {
                throw new NameNotFoundException(String.valueOf(string4) + " is not bound in the context " + string5);
            }
        }
        this.log.end();
    }

    private void destroySubcontext(String string) throws NotContextException, ServiceUnavailableException {
        if (!this.jndiAgentServiceImpl.containsContext(string)) {
            throw new NotContextException("Context " + string + " does not exists");
        }
        Map<String, Serializable> map = this.jndiAgentServiceImpl.getContext(string);
        for (String string2 : map.keySet()) {
            if (!string2.contains("/")) continue;
            this.destroySubcontext(string2);
        }
        this.jndiAgentServiceImpl.removeContext(string);
    }
}

