/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jndi.client.naming;

import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.ow2.petals.communication.jndi.agent.JNDIAgentService;
import org.ow2.petals.communication.jndi.agent.msg.request.RegistryRequest;
import org.ow2.petals.communication.jndi.agent.msg.response.AckResponse;
import org.ow2.petals.communication.jndi.agent.msg.response.CreateSubcontextResponse;
import org.ow2.petals.communication.jndi.agent.msg.response.ListBindingsResponse;
import org.ow2.petals.communication.jndi.agent.msg.response.ListResponse;
import org.ow2.petals.communication.jndi.agent.msg.response.LookupLinkResponse;
import org.ow2.petals.communication.jndi.agent.msg.response.LookupResponse;
import org.ow2.petals.communication.jndi.agent.msg.response.RegistryResponse;
import org.ow2.petals.communication.jndi.client.naming.NamingConnection;

public class JNDILocalConnection
implements NamingConnection {
    private JNDIAgentService jndiAgentService;

    public JNDILocalConnection(JNDIAgentService jNDIAgentService) {
        this.jndiAgentService = jNDIAgentService;
    }

    public Object send(RegistryRequest registryRequest) throws NamingException {
        RegistryResponse registryResponse = null;
        Object object = this.jndiAgentService.processRequest(registryRequest);
        switch (registryRequest.getType()) {
            case bind: {
                registryResponse = new AckResponse();
                break;
            }
            case createSubcontext: {
                registryResponse = new CreateSubcontextResponse((String)object);
                break;
            }
            case destroySubcontext: {
                registryResponse = new AckResponse();
                break;
            }
            case list: {
                registryResponse = new ListResponse((NameClassPair[])object);
                break;
            }
            case listBindings: {
                registryResponse = new ListBindingsResponse((Binding[])object);
                break;
            }
            case lookup: {
                registryResponse = new LookupResponse(object);
                break;
            }
            case lookupLink: {
                registryResponse = new LookupLinkResponse(object);
                break;
            }
            case ping: {
                registryResponse = new AckResponse();
                break;
            }
            case rebind: {
                registryResponse = new AckResponse();
                break;
            }
            case rename: {
                registryResponse = new AckResponse();
                break;
            }
            case unbind: {
                registryResponse = new AckResponse();
                break;
            }
        }
        return registryResponse.getArg1();
    }
}

