/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.lifecycle;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.management.ComponentLifeCycleMBean;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.communication.jndi.client.JNDIService;
import org.ow2.petals.container.lifecycle.AbstractLifeCycle;
import org.ow2.petals.container.lifecycle.ComponentLifeCycleInterface;
import org.ow2.petals.container.lifecycle.ForbiddenActionJBIException;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.container.thread.ComponentLifeCycleThread;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.messaging.endpoint.JBIServiceEndpointImpl;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.DeliveryChannel;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ComponentLifeCycleInterface.class)})
public class ComponentLifeCycle
extends AbstractLifeCycle
implements ComponentLifeCycleMBean,
BindingController,
LifeCycleController,
ComponentLifeCycleInterface {
    @Requires(name="systemstate", signature=SystemStateService.class)
    private SystemStateService systemStateService;
    @Requires(name="jndi", signature=JNDIService.class)
    protected JNDIService jndiService;
    @Requires(name="admin", signature=AdminService.class)
    protected AdminService adminService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private ContainerConfiguration containerConfiguration;
    private ComponentContext componentContext;
    protected ComponentLifeCycleThread componentLifeCycleThread;
    protected String installationRootPath;
    protected ServiceEndpoint address;
    protected InitialContext initialContext;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.startComponentLifeCycle();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stopComponentLifeCycle();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void init(ComponentContext componentContext, ComponentLifeCycleThread componentLifeCycleThread, Context context) throws JBIException, PetalsException {
        this.log.start();
        this.componentContext = componentContext;
        this.name = context.getDescriptor().getComponent().getIdentification().getName();
        this.installationRootPath = context.getInstallUrl().getPath();
        this.address = new JBIServiceEndpointImpl();
        this.address.setType(ServiceEndpoint.EndpointType.CONSUMER);
        this.address.getLocation().setComponentName(this.name);
        this.address.getLocation().setContainerName(this.containerConfiguration.getName());
        this.address.getLocation().setSubdomainName(this.containerConfiguration.getSubdomainName());
        this.componentLifeCycleThread = componentLifeCycleThread;
        this.setState("Shutdown");
        this.log.end();
    }

    public void doInit() throws JBIException {
        this.log.start();
        this.componentLifeCycleThread.doInit(this.componentContext);
        this.log.end();
    }

    public void doShutdown() throws JBIException {
        this.log.start();
        for (ServiceUnitLifeCycle object2 : this.adminService.getServiceUnitsLifeCyclesForComponent(this.name)) {
            if (this.forcedState || !"Started".equals(object2.state) && !"Stopped".equals(object2.state)) continue;
            throw new ForbiddenActionJBIException("Cannot shut down a component with SUs at state STARTED or STOPPED");
        }
        this.componentLifeCycleThread.doShutdown();
        DeliveryChannel deliveryChannel = this.componentContext.getDeliveryChannel();
        if (deliveryChannel != null && deliveryChannel.isOpened()) {
            deliveryChannel.close();
        }
        this.log.end();
    }

    public void doStart() throws JBIException {
        this.log.start();
        this.componentLifeCycleThread.doStart();
        this.log.end();
    }

    public void doStop() throws JBIException {
        this.log.start();
        for (ServiceUnitLifeCycle serviceUnitLifeCycle : this.adminService.getServiceUnitsLifeCyclesForComponent(this.name)) {
            if (this.forcedState || !"Started".equals(serviceUnitLifeCycle.state)) continue;
            throw new ForbiddenActionJBIException("Cannot stop a component with SUs at state STARTED");
        }
        this.componentLifeCycleThread.doStop();
        this.log.end();
    }

    public ObjectName getExtensionMBeanName() throws JBIException {
        return this.componentLifeCycleThread.getExtensionMBeanName();
    }

    public String getName() {
        return this.name;
    }

    public Logger getLogger() {
        return this.log.getLogger();
    }

    protected void setState(String string) throws JBIException {
        super.setState(string);
        try {
            this.systemStateService.updateComponentLifeCycleState(this.name, string);
        }
        catch (Exception exception) {
            String string2 = "Component state can't be persisted";
            this.log.error((Object)string2, (Throwable)exception);
            throw new JBIException(string2, (Throwable)exception);
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("systemstate")) {
            if (!SystemStateService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SystemStateService.class.getName());
            }
            this.systemStateService = (SystemStateService)object;
            return;
        }
        if (string.equals("jndi")) {
            if (!JNDIService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + JNDIService.class.getName());
            }
            this.jndiService = (JNDIService)object;
            return;
        }
        if (string.equals("admin")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void startComponentLifeCycle() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Container.Lifecycle.ComponentLifeCycle"));
        this.log.call();
        this.containerConfiguration = this.configurationService.getContainerConfiguration();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stopComponentLifeCycle() {
        this.log.start();
        this.setForcedState(true);
        if ("Started".equals(this.getCurrentState())) {
            try {
                this.doStop();
                this.doShutdown();
            }
            catch (JBIException jBIException) {
                this.log.error((Object)("Failed to stop the component '" + this.name + "'"), (Throwable)jBIException);
            }
        }
        if ("Stopped".equals(this.getCurrentState())) {
            try {
                this.doShutdown();
            }
            catch (JBIException jBIException) {
                this.log.error((Object)("Failed to shut down the component '" + this.name + "'"), (Throwable)jBIException);
            }
        }
        try {
            this.componentLifeCycleThread.shutdownThread();
        }
        catch (JBIException jBIException) {
            this.log.error((Object)("Failed to stop the life-cycle dedicated thread for the component '" + this.name + "'"), (Throwable)jBIException);
        }
        this.log.end();
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("systemstate");
        arrayList.add("jndi");
        arrayList.add("admin");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("systemstate")) {
            return this.systemStateService;
        }
        if (string.equals("jndi")) {
            return this.jndiService;
        }
        if (string.equals("admin")) {
            return this.adminService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("systemstate")) {
            this.systemStateService = null;
            return;
        }
        if (string.equals("jndi")) {
            this.jndiService = null;
            return;
        }
        if (string.equals("admin")) {
            this.adminService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected String getJBIArtifactType() {
        return "Component";
    }
}

