/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.thread;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.management.ObjectName;
import org.ow2.petals.container.thread.AbstractThread;
import org.ow2.petals.util.LoggingUtil;

public class ComponentLifeCycleThread
extends AbstractThread {
    private Component component;
    private ComponentContext context;
    private ObjectName objectName;
    public static final String INIT = "INIT";
    public static final String START = "START";
    public static final String STOP = "STOP";
    public static final String SHUTDOWN = "SHUTDOWN";
    public static final String MBEANNAME = "MBEANNAME";

    public ComponentLifeCycleThread(Component component, long l, LoggingUtil loggingUtil) {
        super(l, loggingUtil);
        this.component = component;
        this.setName(String.valueOf(component.toString()) + "-life Cycle Thread");
    }

    protected boolean doTask(String string) {
        boolean bl = true;
        try {
            if (INIT.equals(string)) {
                this.getComponent().getLifeCycle().init(this.context);
            } else if (START.equals(string)) {
                this.getComponent().getLifeCycle().start();
            } else if (STOP.equals(string)) {
                this.getComponent().getLifeCycle().stop();
            } else if (SHUTDOWN.equals(string)) {
                this.getComponent().getLifeCycle().shutDown();
            } else if (MBEANNAME.equals(string)) {
                this.objectName = this.getComponent().getLifeCycle().getExtensionMBeanName();
            } else if ("SHUTDOWNTHREAD".equals(string)) {
                bl = false;
                ExecutionContext.getProperties().clear();
            } else {
                this.jbiException = new JBIException("Unknown action : " + string);
            }
        }
        catch (Throwable throwable) {
            this.jbiException = new JBIException("Life cycle exception on " + string, throwable);
        }
        return bl;
    }

    public Component getComponent() {
        return this.component;
    }

    public void doStart() throws JBIException {
        this.execute(START);
    }

    public void doStop() throws JBIException {
        this.execute(STOP);
    }

    public void doShutdown() throws JBIException {
        this.execute(SHUTDOWN);
    }

    public void doInit(ComponentContext componentContext) throws JBIException {
        this.context = componentContext;
        this.execute(INIT);
    }

    public ObjectName getExtensionMBeanName() {
        try {
            this.execute(MBEANNAME);
        }
        catch (JBIException jBIException) {
            jBIException.printStackTrace();
        }
        ObjectName objectName = this.objectName;
        this.objectName = null;
        return objectName;
    }
}

