/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.autoload;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimerTask;
import org.ow2.petals.jbi.management.autoload.ArchiveFileFilter;
import org.ow2.petals.jbi.management.autoload.AutoLoaderServiceImpl;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.NioUtil;

public class InstallDirectoryScanner
extends TimerTask {
    private final File installDir;
    private final AutoLoaderServiceImpl autoLoader;
    private final ArchiveFileFilter archiveFilter;
    private final List<File> previousArchives = new ArrayList<File>();
    private final LoggingUtil logger;

    public InstallDirectoryScanner(AutoLoaderServiceImpl autoLoaderServiceImpl, File file, LoggingUtil loggingUtil) {
        this.installDir = file;
        this.autoLoader = autoLoaderServiceImpl;
        this.archiveFilter = ArchiveFileFilter.getInstance();
        this.logger = loggingUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        File[] fileArray = this.installDir.listFiles(this.archiveFilter);
        if (fileArray != null) {
            ArrayList<File> arrayList = new ArrayList<File>();
            List<File> list = this.previousArchives;
            synchronized (list) {
                Serializable serializable;
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    serializable = fileArray2[n2];
                    if (!this.previousArchives.contains(serializable)) {
                        arrayList.add((File)serializable);
                    }
                    ++n2;
                }
                this.previousArchives.clear();
                serializable = new ArrayList();
                for (File file : arrayList) {
                    if (NioUtil.checkAccess(file)) continue;
                    serializable.add(file);
                }
                arrayList.removeAll((Collection<?>)((Object)serializable));
                if (!arrayList.isEmpty()) {
                    this.autoLoader.install(arrayList);
                    this.previousArchives.addAll(arrayList);
                }
            }
        } else {
            this.logger.warning((Object)("Error when the autoloader scanned the directory '" + this.installDir.getPath() + "'. Perhaps, the directory was deleted !"));
        }
    }
}

