/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.autoload;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import org.ow2.petals.jbi.management.autoload.ArchiveFileFilter;
import org.ow2.petals.jbi.management.autoload.AutoLoaderServiceImpl;
import org.ow2.petals.util.LoggingUtil;

public class InstalledDirectoryScanner
extends TimerTask {
    private final ArchiveFileFilter archiveFilter;
    private final AutoLoaderServiceImpl autoLoader;
    private final File installedDir;
    private final List<File> previousArchives = new ArrayList<File>();
    private final LoggingUtil logger;

    public InstalledDirectoryScanner(AutoLoaderServiceImpl autoLoaderServiceImpl, File file, LoggingUtil loggingUtil) {
        this.installedDir = file;
        this.autoLoader = autoLoaderServiceImpl;
        this.archiveFilter = ArchiveFileFilter.getInstance();
        this.logger = loggingUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        File[] fileArray = this.installedDir.listFiles(this.archiveFilter);
        if (fileArray != null) {
            List<File> list = Arrays.asList(fileArray);
            ArrayList<File> arrayList = new ArrayList<File>();
            List<File> list2 = this.previousArchives;
            synchronized (list2) {
                for (File file : this.previousArchives) {
                    if (list.contains(file)) continue;
                    arrayList.add(file);
                }
                this.previousArchives.clear();
                if (!arrayList.isEmpty()) {
                    this.autoLoader.resolveJBIArtefactDependencies(arrayList);
                    this.autoLoader.uninstall(arrayList);
                }
                this.previousArchives.addAll(list);
            }
        } else {
            this.logger.warning((Object)("Error when the autoloader scanned the directory '" + this.installedDir.getPath() + "'. Perhaps, the directory was deleted !"));
        }
    }
}

