/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.installation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.management.ComponentLifeCycleMBean;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.ComponentLifeCycle;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.container.lifecycle.SharedLibraryLifeCycle;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.TaskProcessor;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.installation.InstallationService;
import org.ow2.petals.jbi.management.task.installation.InstallationTaskFactory;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.generated.Component;
import org.ow2.petals.systemstate.generated.SharedLibrary;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.ParameterCheckHelper;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=InstallationService.class)})
public class InstallationServiceImpl
implements BindingController,
LifeCycleController,
InstallationService {
    @Requires(name="admin", signature=AdminService.class)
    protected AdminService adminService;
    protected InitialContext componentInitialContext;
    @Requires(name="container", signature=ContainerService.class)
    protected ContainerService container;
    protected InstallationTaskFactory installationTaskFactory;
    protected LoggingUtil log;
    @Requires(name="repository", signature=RepositoryService.class)
    protected RepositoryService repositoryService;
    @Requires(name="router", signature=RouterService.class)
    protected RouterService router;
    @Requires(name="systemstate", signature=SystemStateService.class)
    protected SystemStateService systemStateService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean forceUnloadInstaller(String string) {
        this.log.start((Object)("Component Name : " + string));
        boolean bl = false;
        try {
            this.forceShutdownComponent(string);
        }
        catch (JBIException jBIException) {}
        try {
            this.uninstallComponent(string);
        }
        catch (JBIException jBIException) {}
        bl = this.unloadInstaller(string, true);
        this.log.end();
        return bl;
    }

    public String[] getInstalledComponentsForSharedLibrary(String string) throws Exception {
        this.log.call();
        String[] stringArray = new String[]{};
        SharedLibraryLifeCycle sharedLibraryLifeCycle = this.adminService.getSharedLibraryByName(string);
        if (sharedLibraryLifeCycle == null) {
            throw new Exception("Shared Library '" + string + "' is not installed");
        }
        stringArray = sharedLibraryLifeCycle.getRegisteredComponents().toArray(stringArray);
        return stringArray;
    }

    public String[] getInstalledSharedLibraries() {
        this.log.call();
        Set<String> set = this.adminService.getSharedLibraries().keySet();
        return set.toArray(new String[set.size()]);
    }

    public String[] getInstallers() {
        Installer[] installerArray;
        this.log.call();
        ArrayList<String> arrayList = new ArrayList<String>();
        Installer[] installerArray2 = installerArray = this.adminService.getInstallers();
        int n = installerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Installer installer = installerArray2[n2];
            arrayList.add(installer.getComponentName());
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Logger getLogger() {
        return this.log.getLogger();
    }

    public String installSharedLibrary(String string) {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "slZipURL", this.log);
        Context context = null;
        try {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = new File(string).toURI().toURL();
            }
            context = this.createInstallationContext(uRL);
            TaskProcessor taskProcessor = this.createSLInstallationProcessor(context, uRL);
            Throwable throwable = taskProcessor.process();
            if (throwable != null) {
                throw new Exception("The installation of the Shared Library '" + string + "' failed.", throwable);
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("Unable to install the shared library at location '" + string + "'"), (Throwable)exception);
            throw new RuntimeException(ExceptionUtil.getExtendedMessage((Exception)exception));
        }
        this.log.info((Object)("Shared Library '" + context.getEntityName() + "' with version '" + context.getEntityVersion() + "' installed"));
        this.log.end();
        return context.getEntityName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectName loadInstaller(String string) {
        block7: {
            ObjectName objectName;
            this.log.start();
            try {
                block8: {
                    Throwable throwable;
                    StringBuilder stringBuilder;
                    ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
                    Installer installer = this.adminService.getInstallerByName(string);
                    if (installer == null) break block7;
                    try {
                        installer.initBootstrap(false);
                        break block8;
                    }
                    catch (Exception exception) {
                        stringBuilder = new StringBuilder("Failed to initialize Component Bootstrap");
                        this.log.error((Object)stringBuilder.toString(), (Throwable)exception);
                        stringBuilder.append("\nCaused by: ").append(exception.getMessage());
                        throwable = exception.getCause();
                    }
                    while (true) {
                        if (throwable == null) {
                            throw new RuntimeException(stringBuilder.toString());
                        }
                        if (throwable.getMessage() != null) {
                            stringBuilder.append("\nCaused by: " + throwable.getMessage());
                        }
                        throwable = throwable.getCause();
                    }
                }
                this.log.info((Object)("Installer of the component '" + string + "' loaded"));
                objectName = this.adminService.getInstallerMBeanNameByName(string);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.log.end();
                throw throwable;
            }
            this.log.end();
            return objectName;
        }
        Object var6_8 = null;
        this.log.end();
        return null;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("admin")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        if (string.equals("container")) {
            if (!ContainerService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ContainerService.class.getName());
            }
            this.container = (ContainerService)object;
            return;
        }
        if (string.equals("repository")) {
            if (!RepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RepositoryService.class.getName());
            }
            this.repositoryService = (RepositoryService)object;
            return;
        }
        if (string.equals("router")) {
            if (!RouterService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterService.class.getName());
            }
            this.router = (RouterService)object;
            return;
        }
        if (string.equals("systemstate")) {
            if (!SystemStateService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SystemStateService.class.getName());
            }
            this.systemStateService = (SystemStateService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public ObjectName loadNewInstaller(String string) {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "installZipURL", this.log);
        Context context = null;
        try {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = new File(string).toURI().toURL();
            }
            context = this.createInstallationContext(uRL);
            TaskProcessor taskProcessor = this.createComponentInstallationProcessor(context, uRL);
            Throwable throwable = taskProcessor.process();
            if (throwable != null) {
                throw new Exception(throwable);
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("Unable to load a new installer at location '" + string + "'"), (Throwable)exception);
            throw new RuntimeException(ExceptionUtil.getExtendedMessage((Exception)exception));
        }
        this.log.info((Object)("A new installer for the component '" + context.getEntityName() + "' is loaded"));
        this.log.end();
        return context.getInstallerObjectName();
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("admin");
        arrayList.add("container");
        arrayList.add("repository");
        arrayList.add("router");
        arrayList.add("systemstate");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("admin")) {
            return this.adminService;
        }
        if (string.equals("container")) {
            return this.container;
        }
        if (string.equals("repository")) {
            return this.repositoryService;
        }
        if (string.equals("router")) {
            return this.router;
        }
        if (string.equals("systemstate")) {
            return this.systemStateService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("admin")) {
            this.adminService = null;
            return;
        }
        if (string.equals("container")) {
            this.container = null;
            return;
        }
        if (string.equals("repository")) {
            this.repositoryService = null;
            return;
        }
        if (string.equals("router")) {
            this.router = null;
            return;
        }
        if (string.equals("systemstate")) {
            this.systemStateService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void shutdown() throws Exception {
        this.log.call();
        this.unloadAllInstallers(true);
        this.uninstallAllSharedLibraries();
    }

    public String[] shutdownAllComponents() {
        this.log.call();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Component component : this.systemStateService.getComponentStateHolders()) {
            try {
                this.shutdownComponent(component.getName());
                arrayList.add(component.getName());
            }
            catch (JBIException jBIException) {}
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean shutdownComponent(String string) throws JBIException {
        return this.shutdownComponent(string, false);
    }

    public String[] startAllComponents() {
        this.log.call();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Component component : this.systemStateService.getComponentStateHolders()) {
            try {
                this.startComponent(component.getName());
                arrayList.add(component.getName());
            }
            catch (JBIException jBIException) {}
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean startComponent(String string) throws JBIException {
        this.log.start((Object)("Component Name : " + string));
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        ComponentLifeCycleMBean componentLifeCycleMBean = null;
        componentLifeCycleMBean = this.adminService.isEngine(string) ? this.adminService.getEngineComponentLifeCycleByName(string) : this.adminService.getBindingComponentLifeCycleByName(string);
        try {
            if (componentLifeCycleMBean == null) {
                throw new JBIException("The component '" + string + "' is not installed");
            }
            componentLifeCycleMBean.start();
        }
        catch (JBIException jBIException) {
            this.log.error((Object)("Unable to start the component '" + string + "'"), (Throwable)jBIException);
            throw jBIException;
        }
        this.log.info((Object)("Component '" + string + "' started"));
        this.log.end();
        return true;
    }

    public String[] stopAllComponents() {
        this.log.call();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Component component : this.systemStateService.getComponentStateHolders()) {
            try {
                this.stopComponent(component.getName());
                arrayList.add(component.getName());
            }
            catch (JBIException jBIException) {}
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean stopComponent(String string) throws JBIException {
        return this.stopComponent(string, false);
    }

    public String[] uninstallAllComponents() {
        this.log.call();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Component component : this.systemStateService.getComponentStateHolders()) {
            try {
                this.uninstallComponent(component.getName());
                arrayList.add(component.getName());
            }
            catch (JBIException jBIException) {}
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] uninstallAllSharedLibraries() {
        this.log.call();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SharedLibrary sharedLibrary : this.systemStateService.getSharedLibraryStateHolders()) {
            if (!this.uninstallSharedLibrary(sharedLibrary.getName())) continue;
            arrayList.add(sharedLibrary.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean uninstallComponent(String string) throws JBIException {
        this.log.start((Object)("Component Name : " + string));
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        if (!this.systemStateService.isComponentInstalled(string)) {
            throw new JBIException("The component '" + string + "' is not installed");
        }
        try {
            this.loadInstaller(string);
        }
        catch (RuntimeException runtimeException) {
            throw new JBIException(runtimeException.getMessage());
        }
        Installer installer = this.adminService.getInstallerByName(string);
        try {
            if (installer == null) {
                throw new JBIException("The installer of the component '" + string + "' is not loaded");
            }
            installer.uninstall();
        }
        catch (JBIException jBIException) {
            this.log.error((Object)("Unable to uninstall the component '" + string + "'"), (Throwable)jBIException);
            throw jBIException;
        }
        this.log.info((Object)("Component '" + string + "' uninstalled"));
        this.log.end();
        return true;
    }

    public boolean uninstallSharedLibrary(String string) {
        Object object;
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "slName", this.log);
        boolean bl = true;
        List<SharedLibrary> list = this.systemStateService.getSharedLibraryStateHolders(string);
        if (list.size() == 0) {
            for (SharedLibrary sharedLibrary : this.systemStateService.getSharedLibraryStateHolders()) {
                if (!string.startsWith(sharedLibrary.getName()) || string.length() <= sharedLibrary.getName().length() + 1) continue;
                object = string.substring(sharedLibrary.getName().length() + 1);
                if (!sharedLibrary.getVersion().equals(object)) continue;
                list.add(sharedLibrary);
                break;
            }
        }
        if (list.size() == 0) {
            throw new RuntimeException("No shared library with identification '" + string + "' is installed");
        }
        for (SharedLibrary sharedLibrary : list) {
            if (this.adminService.getSharedLibraryByName(String.valueOf(sharedLibrary.getName()) + "-" + sharedLibrary.getVersion()).getRegisteredComponents().size() != 0) {
                throw new RuntimeException("At least a component refers the shared library '" + sharedLibrary.getName() + "' with version '" + sharedLibrary.getVersion() + "'");
            }
            object = this.createSLUnInstallationContext(sharedLibrary.getName(), sharedLibrary.getVersion());
            TaskProcessor taskProcessor = this.createSLUnInstallationProcessor((Context)object);
            Throwable throwable = taskProcessor.process();
            if (throwable != null) {
                bl = false;
                this.log.warning((Object)("The uninstallation of the shared library '" + sharedLibrary.getName() + "' failed"), throwable);
                continue;
            }
            this.log.info((Object)("Shared library '" + string + "' with version '" + sharedLibrary.getVersion() + "' uninstalled"));
        }
        this.log.end();
        return bl;
    }

    public boolean uninstallSharedLibrary(String string, String string2) {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "slName", this.log);
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "version", this.log);
        boolean bl = true;
        SharedLibrary sharedLibrary = this.systemStateService.getSharedLibraryStateHolder(string, string2);
        if (sharedLibrary == null) {
            throw new RuntimeException("No shared library with identification '" + string + "' and version " + string2 + " is installed");
        }
        if (this.adminService.getSharedLibraryByName(String.valueOf(string) + "-" + string2).getRegisteredComponents().size() != 0) {
            throw new RuntimeException("At least a component refers the shared library '" + sharedLibrary.getName() + "'");
        }
        Context context = this.createSLUnInstallationContext(sharedLibrary.getName(), sharedLibrary.getVersion());
        TaskProcessor taskProcessor = this.createSLUnInstallationProcessor(context);
        Throwable throwable = taskProcessor.process();
        if (throwable != null) {
            bl = false;
            this.log.error((Object)("Unable to uninstall the shared library '" + sharedLibrary.getName() + "'"), throwable);
        } else {
            this.log.info((Object)("Shared library '" + string + "' with version '" + sharedLibrary.getVersion() + "' uninstalled"));
        }
        this.log.end();
        return bl;
    }

    public String[] unloadAllInstallers(boolean bl) {
        this.log.call();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Component> list = this.systemStateService.getComponentStateHolders();
        Collections.reverse(list);
        for (Component component : list) {
            if (bl) {
                if (!this.forceUnloadInstaller(component.getName())) continue;
                arrayList.add(component.getName());
                continue;
            }
            if (!this.unloadInstaller(component.getName(), true)) continue;
            arrayList.add(component.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean unloadInstaller(String string, boolean bl) {
        this.log.start();
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        boolean bl2 = true;
        try {
            if (this.systemStateService.getComponentStateHolder(string) == null) {
                throw new RuntimeException("The installer of the component '" + string + "' is not existing");
            }
            Context context = this.createComponentUninstallationContext(string);
            TaskProcessor taskProcessor = this.createComponentUnInstallationProcessor(context);
            Throwable throwable = taskProcessor.process();
            if (throwable != null) {
                throw new Exception(throwable);
            }
            this.log.info((Object)("Installer of the component '" + string + "' succesfully unloaded"));
        }
        catch (Exception exception) {
            this.log.error((Object)("Unable to unload the installer of the component '" + string + "'"), (Throwable)exception);
            bl2 = false;
        }
        this.log.end();
        return bl2;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.JBI-Management.InstallationService"));
        this.log.start();
        String string = this.configurationService.getContainerConfiguration().getRootDirectoryPath();
        this.installationTaskFactory = new InstallationTaskFactory(this.systemStateService, this.repositoryService, this.log, this.adminService, this.router, this.container, string);
        File file = new File(string, "work");
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (!file2.isDirectory() && file2.getName().endsWith(".success")) {
                file2.delete();
            }
            ++n2;
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }

    private TaskProcessor createComponentInstallationProcessor(Context context, URL uRL) {
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        String string = uRL.getProtocol();
        if (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("ftp")) {
            taskProcessor.addTask(this.installationTaskFactory.getDownloadTask());
        } else if (string.equalsIgnoreCase("file")) {
            taskProcessor.addTask(this.installationTaskFactory.getCopyArchiveToWorkDirTask());
        } else {
            throw new IllegalArgumentException("URL protocol not supported:" + string);
        }
        taskProcessor.addTask(this.installationTaskFactory.getExtractTask());
        taskProcessor.addTask(this.installationTaskFactory.getComponentCheckPackageTask());
        taskProcessor.addTask(this.installationTaskFactory.getRegisterComponentInSLTask());
        taskProcessor.addTask(this.installationTaskFactory.getCreateComponentFolderTask());
        taskProcessor.addTask(this.installationTaskFactory.getCreateComponentStateHolderTask());
        taskProcessor.addTask(this.installationTaskFactory.getCreateAndRegisterInstallerMBeanTask());
        taskProcessor.addTask(this.installationTaskFactory.getCopyArchiveToInstalledDirTask());
        return taskProcessor;
    }

    private Context createComponentUninstallationContext(String string) {
        Context context = new Context();
        context.setEntityName(string);
        return context;
    }

    private TaskProcessor createComponentUnInstallationProcessor(Context context) {
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        taskProcessor.addTask(this.installationTaskFactory.getUnregisterInstallerTask());
        taskProcessor.addTask(this.installationTaskFactory.getUnregisterComponentFromSLTask());
        taskProcessor.addTask(this.installationTaskFactory.getRemoveComponentStateHolderTask());
        taskProcessor.addTask(this.installationTaskFactory.getRemoveComponentFolderTask());
        taskProcessor.addTask(this.installationTaskFactory.getRemoveComponentArchiveTask());
        return taskProcessor;
    }

    private Context createInstallationContext(URL uRL) {
        Context context = new Context();
        context.setArchiveUrl(uRL);
        return context;
    }

    private TaskProcessor createSLInstallationProcessor(Context context, URL uRL) {
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        String string = uRL.getProtocol();
        if (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("ftp")) {
            taskProcessor.addTask(this.installationTaskFactory.getDownloadTask());
        } else if (string.equalsIgnoreCase("file")) {
            taskProcessor.addTask(this.installationTaskFactory.getCopyArchiveToWorkDirTask());
        } else {
            throw new IllegalArgumentException("URL protocol not supported:" + string);
        }
        taskProcessor.addTask(this.installationTaskFactory.getExtractTask());
        taskProcessor.addTask(this.installationTaskFactory.getSLCheckPackageTask());
        taskProcessor.addTask(this.installationTaskFactory.getCreateSLRepositoryTask());
        taskProcessor.addTask(this.installationTaskFactory.getCreateSLStateHolderTask());
        taskProcessor.addTask(this.installationTaskFactory.getCreateSLClassloaderTask());
        taskProcessor.addTask(this.installationTaskFactory.getCopyArchiveToInstalledDirTask());
        return taskProcessor;
    }

    private Context createSLUnInstallationContext(String string, String string2) {
        Context context = new Context();
        context.setEntityName(string);
        context.setEntityVersion(string2);
        return context;
    }

    private TaskProcessor createSLUnInstallationProcessor(Context context) {
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        taskProcessor.addTask(this.installationTaskFactory.getRemoveSLClassloaderTask());
        taskProcessor.addTask(this.installationTaskFactory.getRemoveSLStateHolderTask());
        taskProcessor.addTask(this.installationTaskFactory.getRemoveSLFolderTask());
        taskProcessor.addTask(this.installationTaskFactory.getRemoveSLArchiveTask());
        return taskProcessor;
    }

    private void forceShutdownComponent(String string) throws JBIException {
        this.log.call();
        ComponentLifeCycleMBean componentLifeCycleMBean = null;
        componentLifeCycleMBean = this.adminService.isEngine(string) ? this.adminService.getEngineComponentLifeCycleByName(string) : this.adminService.getBindingComponentLifeCycleByName(string);
        if (componentLifeCycleMBean != null) {
            String string2 = componentLifeCycleMBean.getCurrentState();
            if ("Started".equals(string2)) {
                this.stopComponent(string, true);
                this.shutdownComponent(string, true);
            } else if ("Stopped".equals(string2)) {
                this.shutdownComponent(string, true);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shutdownComponent(String string, boolean bl) throws JBIException {
        this.log.start((Object)("Component Name : " + string));
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        ComponentLifeCycleMBean componentLifeCycleMBean = null;
        componentLifeCycleMBean = this.adminService.isEngine(string) ? this.adminService.getEngineComponentLifeCycleByName(string) : this.adminService.getBindingComponentLifeCycleByName(string);
        try {
            if (componentLifeCycleMBean == null) {
                throw new JBIException("The component '" + string + "' is not installed");
            }
            ((ComponentLifeCycle)componentLifeCycleMBean).setForcedState(bl);
            try {
                componentLifeCycleMBean.shutDown();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ((ComponentLifeCycle)componentLifeCycleMBean).setForcedState(false);
                throw throwable;
            }
            {
                Object var4_6 = null;
                ((ComponentLifeCycle)componentLifeCycleMBean).setForcedState(false);
            }
        }
        catch (JBIException jBIException) {
            this.log.error((Object)("Unable to shutdown the component '" + string + "'"), (Throwable)jBIException);
            throw jBIException;
        }
        this.log.info((Object)("Component '" + string + "' shut down"));
        this.log.end();
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean stopComponent(String string, boolean bl) throws JBIException {
        this.log.start((Object)("Component Name : " + string));
        ParameterCheckHelper.isNullOrEmptyParameterWithLog(string, "componentName", this.log);
        ComponentLifeCycleMBean componentLifeCycleMBean = null;
        componentLifeCycleMBean = this.adminService.isEngine(string) ? this.adminService.getEngineComponentLifeCycleByName(string) : this.adminService.getBindingComponentLifeCycleByName(string);
        try {
            if (componentLifeCycleMBean == null) {
                throw new JBIException("The component '" + string + "' is not installed");
            }
            ((ComponentLifeCycle)componentLifeCycleMBean).setForcedState(bl);
            try {
                componentLifeCycleMBean.stop();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ((ComponentLifeCycle)componentLifeCycleMBean).setForcedState(false);
                throw throwable;
            }
            {
                Object var4_6 = null;
                ((ComponentLifeCycle)componentLifeCycleMBean).setForcedState(false);
            }
        }
        catch (JBIException jBIException) {
            this.log.error((Object)("Unable to stop the component '" + string + "'"), (Throwable)jBIException);
            throw jBIException;
        }
        this.log.info((Object)("Component '" + string + "' stopped"));
        this.log.end();
        return true;
    }
}

