/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.jbi.management.logging.LoggingService;
import org.ow2.petals.jbi.management.logging.LoggingServiceImpl;
import org.ow2.petals.jbi.management.logging.LoggingServiceMBean;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=LoggingServiceMBean.class)})
public class LoggingServiceMBeanImpl
implements BindingController,
LifeCycleController,
LoggingServiceMBean {
    @Requires(name="logging", signature=LoggingService.class)
    protected LoggingService loggingService;
    private final LoggingUtil log = new LoggingUtil(Logger.getLogger(LoggingServiceImpl.class.getName()));

    public String[] getLevels() {
        List<String> list = this.loggingService.getLevels();
        return list.toArray(new String[list.size()]);
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log.call();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
    }

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logging")) {
            if (!LoggingService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + LoggingService.class.getName());
            }
            this.loggingService = (LoggingService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("logging");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("logging")) {
            return this.loggingService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logging")) {
            this.loggingService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

