/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.AbstractFileManipulationTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;

public class DownloadTask
extends AbstractFileManipulationTask {
    private static final AtomicLong DOWNLOAD_ID = new AtomicLong(0L);
    private static final SimpleDateFormat FOLDER_DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy-hhmmss");

    public DownloadTask(LoggingUtil loggingUtil, String string) {
        super(loggingUtil, string);
    }

    private static synchronized String getCurrentDateAsString() {
        return FOLDER_DATE_FORMAT.format(new Date(System.currentTimeMillis()));
    }

    public void execute(Context context) throws Exception {
        URL uRL = context.getArchiveUrl();
        URL uRL2 = this.downloadEntityPackage(uRL);
        context.setArchiveUrl(uRL2);
    }

    public void undo(Context context) throws Exception {
        URL uRL = context.getArchiveUrl();
        if (uRL != null) {
            try {
                FileUtils.forceDelete((File)new File(uRL.getPath()));
            }
            catch (IOException iOException) {
                this.log.error((Object)("Failed to clean downloaded artefact " + uRL));
            }
        }
    }

    private URL downloadEntityPackage(URL uRL) throws PetalsException {
        URL uRL2 = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.verifyThatResourceExist(uRL, uRLConnection);
            String string = this.retrieveFileName(uRL);
            uRL2 = this.recordTheZipFileInWorkDirectory(uRL, uRLConnection, string);
        }
        catch (IOException iOException) {
            throw new PetalsException("Can't read distant file: " + uRL);
        }
        return uRL2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL recordTheZipFileInWorkDirectory(URL uRL, URLConnection uRLConnection, String string) throws FileNotFoundException, IOException, MalformedURLException {
        URL uRL2;
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            inputStream = uRL.openStream();
            File file = new File(this.getWorkDirectory(), String.valueOf(string) + "-downloaded-" + DownloadTask.getCurrentDateAsString() + "-" + DOWNLOAD_ID.getAndIncrement() + ".zip");
            fileOutputStream = new FileOutputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            uRL2 = file.toURI().toURL();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                this.log.warning((Object)("Failed to clean the downloaded archive '" + uRL.toExternalForm() + "'"), (Throwable)iOException);
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (IOException iOException) {
            this.log.warning((Object)("Failed to clean the downloaded archive '" + uRL.toExternalForm() + "'"), (Throwable)iOException);
            return uRL2;
        }
        if (inputStream != null) {
            inputStream.close();
        }
        if (fileOutputStream == null) return uRL2;
        fileOutputStream.close();
        return uRL2;
    }

    private String retrieveFileName(URL uRL) {
        String string;
        String string2 = uRL.getPath();
        String string3 = string2.substring(string2.lastIndexOf(47) + 1, string2.lastIndexOf(46));
        if (!string3.contains(".") && (string = uRL.getQuery()) != null) {
            string3 = string.substring(string.lastIndexOf(61) + 1);
        }
        return string3;
    }

    private void verifyThatResourceExist(URL uRL, URLConnection uRLConnection) throws IOException, PetalsException {
        if ("http".equalsIgnoreCase(uRL.getProtocol())) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            int n = httpURLConnection.getResponseCode();
            this.log.debug((Object)("HTTP Response code: " + n));
            if (n != 200) {
                throw new PetalsException("Unable to download the remote resource " + uRL + " [HTTP " + n + "]");
            }
            String string = httpURLConnection.getContentType();
            if (string != null) {
                if (!(string.startsWith("application/x-zip") || string.startsWith("application/x-zip-compressed") || string.startsWith("application/zip") || string.startsWith("application/zip-compressed"))) {
                    throw new PetalsException("The remote resource [" + uRL + "] is not a valid JBI archive: " + string);
                }
            } else {
                throw new PetalsException("The remote resource [" + uRL.toExternalForm() + "] is not a valid JBI archive. It's content-type is undefined.");
            }
        }
    }
}

