/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.deploy;

import javax.jbi.JBIException;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractLoggableTask;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.server.FractalHelper;
import org.ow2.petals.util.LoggingUtil;

public class RegisterSALifeCycleTask
extends AbstractLoggableTask {
    protected AdminService adminService;
    protected ContainerService containerService;

    public RegisterSALifeCycleTask(LoggingUtil loggingUtil, AdminService adminService, ContainerService containerService) {
        super(loggingUtil);
        this.adminService = adminService;
        this.containerService = containerService;
    }

    public void execute(Context context) throws Exception {
        Jbi jbi = context.getDescriptor();
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.createSALifeCycle(jbi);
        serviceAssemblyLifeCycle.init(jbi.getServiceAssembly());
        this.adminService.registerServiceAssembly(serviceAssemblyLifeCycle, jbi.getServiceAssembly().getIdentification().getName());
        context.setSaLifeCycle(serviceAssemblyLifeCycle);
    }

    protected ServiceAssemblyLifeCycle createSALifeCycle(Jbi jbi) throws JBIException, ADLException, NoSuchInterfaceException, IllegalLifeCycleException, PetalsException {
        Component component = this.containerService.createServiceAssemblyLifeCycle(jbi.getServiceAssembly());
        FractalHelper.startComponent(component);
        ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = (ServiceAssemblyLifeCycle)component.getFcInterface("/content");
        return serviceAssemblyLifeCycle;
    }

    public void undo(Context context) throws Exception {
        if (context.getDescriptor() != null) {
            Jbi jbi = context.getDescriptor();
            try {
                this.adminService.unregisterServiceAssembly(jbi.getServiceAssembly().getIdentification().getName());
            }
            catch (ManagementException managementException) {
                this.log.error((Object)("Failed to revert a RegisterSALifeCycleTask: " + managementException.getMessage()));
            }
        }
        if (context.getSaLifeCycle() != null) {
            try {
                this.containerService.removeServiceAssemblyLifeCycle(context.getSaLifeCycle());
            }
            catch (PetalsException petalsException) {
                this.log.error((Object)("Failed to revert a RegisterSALifeCycleTask: " + petalsException.getMessage()));
            }
        }
        context.setSaLifeCycle(null);
    }
}

