/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.sl;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.io.File;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.task.AbstractCheckPackageTask;
import org.ow2.petals.jbi.management.task.installation.InstallationUtils;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;

public class SLCheckPackageTask
extends AbstractCheckPackageTask {
    private AdminService adminService;

    public SLCheckPackageTask(LoggingUtil loggingUtil, AdminService adminService) {
        super(loggingUtil);
        this.adminService = adminService;
    }

    protected void checkPackage(Jbi jbi, File file) throws PetalsException {
        Jbi.SharedLibrary sharedLibrary = jbi.getSharedLibrary();
        if (sharedLibrary == null) {
            throw new PetalsException("The shared-library element was not found in JBI Descriptor within installation package: " + file.getAbsolutePath());
        }
        String string = sharedLibrary.getIdentification().getName();
        String string2 = sharedLibrary.getVersion();
        if (StringHelper.isNullOrEmpty((String)string)) {
            throw new PetalsException("The Shared Library name must be non null and non empty :" + file.getAbsolutePath());
        }
        if (StringHelper.isNullOrEmpty((String)string2)) {
            throw new PetalsException("The Shared Library version must be non null and non empty :" + file.getAbsolutePath());
        }
        if (this.adminService.getSharedLibraryByName(String.valueOf(string) + "-" + string2) != null) {
            throw new PetalsException("Other Shared Library package already exists loaded in the component framework: " + string);
        }
        InstallationUtils.checkClassPathElements(file, sharedLibrary.getSharedLibraryClassPath().getPathElement());
    }

    protected String extractEntityName(Jbi jbi) {
        return jbi.getSharedLibrary().getIdentification().getName();
    }

    protected String extractEntityVersion(Jbi jbi) {
        return jbi.getSharedLibrary().getVersion();
    }
}

