/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.jbi.component.Component;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.descriptor.original.generated.LinkType;
import org.ow2.petals.jbi.messaging.control.ExchangeCheckerClient;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.jbi.messaging.routing.module.endpoint.EndpointOrderer;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class EndpointResolverModule
implements BindingController,
LifeCycleController,
SenderModule {
    public static final String HIGHEST = "highest";
    public static final int NUMBER_STRATEGY_PARAMETERS = 4;
    public static final String PROPERTY_STRATEGY_PROTOCOLS = "org.ow2.petals.routing.strategy";
    public static final String RANDOM = "random";
    public static final String STRATEGY_SEPARATOR = ",";
    private static List<Object> defaultStrategyParameters;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    private EndpointRegistry endpointRegistry;
    @Requires(name="checker", signature=ExchangeCheckerClient.class)
    private ExchangeCheckerClient exchangeCheckerService;
    private LoggingUtil log;
    @Requires(contingency=Contingency.OPTIONAL, name="topology", signature=TopologyService.class)
    private TopologyService topologyService;
    private EndpointOrderer endpointOrderer;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private static final List<Object> analyseStrategy(String string) throws RoutingException {
        Float f;
        Float f2;
        Float f3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, STRATEGY_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList2.add(stringTokenizer.nextToken().trim());
        }
        if (arrayList2.size() != 4) {
            throw new RoutingException("4 parameters are required for a routing strategy '" + string + "'");
        }
        String string2 = ((String)arrayList2.get(0)).toLowerCase();
        try {
            f3 = Float.valueOf((String)arrayList2.get(1));
            f2 = Float.valueOf((String)arrayList2.get(2));
            f = Float.valueOf((String)arrayList2.get(3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RoutingException("Impossible to convert a parameter to a float for the routing strategy '" + string + "'");
        }
        if (!string2.equals(HIGHEST) && !string2.equals(RANDOM)) {
            throw new RoutingException("the " + string2 + " routing strategy is unknown");
        }
        if (f3.floatValue() < 0.0f || f2.floatValue() < 0.0f || f.floatValue() < 0.0f) {
            throw new RoutingException("Negative parameter is forbidden in routing strategy");
        }
        if (f3.floatValue() == 0.0f && f2.floatValue() == 0.0f && f.floatValue() == 0.0f) {
            throw new RoutingException("Weightings '0,0,0' is forbidden");
        }
        arrayList.add(string2);
        arrayList.add(f3);
        arrayList.add(f2);
        arrayList.add(f);
        return arrayList;
    }

    private static final List<Object> getStrategy(MessageExchange messageExchange) throws RoutingException {
        String string = (String)messageExchange.getProperty(PROPERTY_STRATEGY_PROTOCOLS);
        List<Object> list = string == null ? defaultStrategyParameters : EndpointResolverModule.analyseStrategy(string);
        return list;
    }

    @Override
    public final void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeWrapper messageExchangeWrapper) throws RoutingException {
        this.log.call();
        if (MessageExchange.Role.CONSUMER.equals(messageExchangeWrapper.getRole())) {
            List<ServiceEndpoint> list = this.resolveEndpoints(componentContext.getComponent(), (MessageExchange)messageExchangeWrapper);
            for (ServiceEndpoint serviceEndpoint : list) {
                map.put(serviceEndpoint, new TransportSendContext(serviceEndpoint.getLocation()));
            }
        } else {
            ServiceEndpoint serviceEndpoint = (ServiceEndpoint)messageExchangeWrapper.getConsumerEndpoint();
            map.put(serviceEndpoint, new TransportSendContext(serviceEndpoint.getLocation()));
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws RoutingException {
        this.log = new LoggingUtil(Logger.getLogger("Petals.JBI-Messaging.EndpointResolverModule"));
        this.log.call();
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        try {
            defaultStrategyParameters = EndpointResolverModule.analyseStrategy(containerConfiguration.getRouterStrategy());
        }
        catch (RoutingException routingException) {
            this.log.error((Object)"Failed to start Endpoint Resolver module", (Throwable)((Object)routingException));
            throw routingException;
        }
        this.endpointOrderer = new EndpointOrderer(this.log, containerConfiguration, this.topologyService);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws RoutingException {
        this.log.call();
    }

    private final List<ServiceEndpoint> getEnabledEndpoints(kindSearch kindSearch2, Component component, QName qName, MessageExchange messageExchange, LinkType linkType) throws RegistryException {
        this.log.call();
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        ServiceEndpoint[] serviceEndpointArray = null;
        serviceEndpointArray = kindSearch2 == kindSearch.SERVICE_SEARCH ? this.endpointRegistry.getInternalEndpointsForService(qName, linkType) : this.endpointRegistry.getInternalEndpointsForInterface(qName, linkType);
        ServiceEndpoint[] serviceEndpointArray2 = serviceEndpointArray;
        int n = serviceEndpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceEndpoint serviceEndpoint = serviceEndpointArray2[n2];
            if (this.isExchangeOK(component, serviceEndpoint, messageExchange)) {
                arrayList.add(serviceEndpoint);
            }
            ++n2;
        }
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("checker")) {
            if (!ExchangeCheckerClient.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ExchangeCheckerClient.class.getName());
            }
            this.exchangeCheckerService = (ExchangeCheckerClient)object;
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("endpoint");
        arrayList.add("checker");
        arrayList.add("topology");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        if (string.equals("checker")) {
            return this.exchangeCheckerService;
        }
        if (string.equals("topology")) {
            return this.topologyService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private final ServiceEndpoint getEndpointForEndpoint(ServiceEndpoint serviceEndpoint, LinkType linkType) throws RoutingException {
        this.log.call();
        ServiceEndpoint serviceEndpoint2 = serviceEndpoint;
        if (serviceEndpoint.getType() == ServiceEndpoint.EndpointType.INTERNAL && linkType == LinkType.SOFT) {
            throw new RoutingException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' is not a SOFT link");
        }
        if (serviceEndpoint.getType() == ServiceEndpoint.EndpointType.LINKED && linkType == LinkType.HARD) {
            throw new RoutingException("The target endpoint '" + serviceEndpoint.getEndpointName() + "' is not an HARD link");
        }
        if (serviceEndpoint.getType() != ServiceEndpoint.EndpointType.INTERNAL) {
            try {
                serviceEndpoint2 = this.endpointRegistry.getEndpoint(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
            }
            catch (RegistryException registryException) {
                throw new RoutingException((Throwable)((Object)registryException));
            }
        }
        return serviceEndpoint2;
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("checker")) {
            this.exchangeCheckerService = null;
            return;
        }
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private final List<ServiceEndpoint> getEndpointsForInterface(QName qName, MessageExchange messageExchange, Component component, LinkType linkType) throws RoutingException {
        List<ServiceEndpoint> list;
        this.log.call();
        try {
            list = this.getEnabledEndpoints(kindSearch.INTERFACE_SEARCH, component, qName, messageExchange, linkType);
        }
        catch (RegistryException registryException) {
            throw new RoutingException((Throwable)((Object)registryException));
        }
        List<Object> list2 = EndpointResolverModule.getStrategy(messageExchange);
        List<ServiceEndpoint> list3 = null;
        if (list.size() == 0) {
            throw new RoutingException("No endpoint(s) matching the target interface '" + qName + "' for Message Exchange with id '" + messageExchange.getExchangeId() + "'");
        }
        list3 = list.size() == 1 ? list : this.endpointOrderer.orderEndpoints(list, list2);
        return list3;
    }

    private final List<ServiceEndpoint> getEndpointsForService(QName qName, MessageExchange messageExchange, Component component, LinkType linkType) throws RoutingException {
        List<ServiceEndpoint> list;
        this.log.call();
        try {
            list = this.getEnabledEndpoints(kindSearch.SERVICE_SEARCH, component, qName, messageExchange, linkType);
        }
        catch (RegistryException registryException) {
            throw new RoutingException((Throwable)((Object)registryException));
        }
        List<ServiceEndpoint> list2 = null;
        if (list.size() == 0) {
            throw new RoutingException("No endpoint(s) matching the target service '" + qName + "' for Message Exchange with id '" + messageExchange.getExchangeId() + "'");
        }
        if (list.size() == 1) {
            list2 = list;
        } else {
            List<Object> list3 = EndpointResolverModule.getStrategy(messageExchange);
            list2 = this.endpointOrderer.orderEndpoints(list, list3);
        }
        return list2;
    }

    private final boolean isExchangeOK(Component component, ServiceEndpoint serviceEndpoint, MessageExchange messageExchange) {
        this.log.call();
        boolean bl = true;
        if (!(!this.configurationService.getContainerConfiguration().isExchangeValidation() || component.isExchangeWithProviderOkay((javax.jbi.servicedesc.ServiceEndpoint)serviceEndpoint, messageExchange) && this.exchangeCheckerService.isExchangeWithConsumerOkayForComponent(serviceEndpoint, messageExchange))) {
            bl = false;
        }
        return bl;
    }

    private final List<ServiceEndpoint> resolveEndpoints(Component component, MessageExchange messageExchange) throws RoutingException {
        this.log.start();
        ServiceEndpoint serviceEndpoint = (ServiceEndpoint)messageExchange.getEndpoint();
        QName qName = messageExchange.getService();
        QName qName2 = messageExchange.getInterfaceName();
        LinkType linkType = LinkType.STANDARD;
        if (messageExchange.getProperty("org.ow2.petals.router.provider.linktype") != null) {
            linkType = LinkType.fromValue((String)((String)messageExchange.getProperty("org.ow2.petals.router.provider.linktype")));
        }
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        if (serviceEndpoint != null) {
            ServiceEndpoint serviceEndpoint2 = this.getEndpointForEndpoint(serviceEndpoint, linkType);
            if (serviceEndpoint2 != null) {
                arrayList.add(serviceEndpoint2);
            }
        } else if (qName != null) {
            arrayList = this.getEndpointsForService(qName, messageExchange, component, linkType);
            if (qName2 != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ServiceEndpoint serviceEndpoint3 = (ServiceEndpoint)iterator.next();
                    if (((QName)serviceEndpoint3.getInterfacesName().get(0)).equals(qName2)) continue;
                    iterator.remove();
                }
            }
        } else if (qName2 != null) {
            arrayList = this.getEndpointsForInterface(qName2, messageExchange, component, linkType);
        }
        if (arrayList.size() == 0) {
            throw new RoutingException("Failed to find an endpoint for the Message Exchange with id '" + messageExchange.getExchangeId() + "'");
        }
        this.log.end();
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum kindSearch {
        INTERFACE_SEARCH,
        SERVICE_SEARCH;

    }
}

