/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.management.deployment.DeploymentService;
import org.ow2.petals.jbi.management.installation.InstallationService;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.kernel.admin.PetalsAdminInterface;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.configuration.SubDomainConfiguration;
import org.ow2.petals.kernel.server.PetalsStopThread;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=PetalsAdminInterface.class)})
public class PetalsAdminServiceImpl
implements BindingController,
LifeCycleController,
PetalsAdminInterface {
    protected LoggingUtil log;
    @Requires(name="deployment", signature=DeploymentService.class)
    protected DeploymentService deployment;
    @Requires(name="installation", signature=InstallationService.class)
    protected InstallationService installation;
    @Requires(contingency=Contingency.OPTIONAL, name="topology", signature=TopologyService.class)
    protected TopologyService topologyService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    private EndpointRegistry registry;
    private ContainerConfiguration containerConfiguration;
    private SubDomainConfiguration subDomainConfiguration;
    private DomainConfiguration domainConfiguration;
    private PetalsStopThread petalsStopThread;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public Properties retrieveServerProperties() {
        return this.configurationService.getServerProperties();
    }

    @Override
    public Set<Map<String, String>> retrieveTopology() throws PetalsException {
        this.log.start();
        HashSet<Map<String, String>> hashSet = new HashSet<Map<String, String>>();
        hashSet.add(this.getDomainMap());
        Set<SubDomainConfiguration> set = this.getSubDomainsConfiguration();
        for (SubDomainConfiguration object2 : set) {
            hashSet.add(this.getSubdomainMap(object2));
        }
        Set<ContainerConfiguration> set2 = this.getContainersConfiguration();
        for (Object containerConfiguration : set2) {
            Map<String, String> map = this.getContainerMap((ContainerConfiguration)containerConfiguration);
            hashSet.add(map);
        }
        this.log.end();
        return hashSet;
    }

    @Override
    public void shutdownContainer() throws Exception {
        this.log.start();
        this.log.info((Object)"PEtALS is shutting down...");
        this.log.info((Object)"  1/3 Undeploy Service Assemblies...");
        try {
            this.deployment.shutdown();
        }
        catch (Exception exception) {
            this.log.error((Object)"Can not shut down the Deployment service.", (Throwable)exception);
        }
        this.log.info((Object)"  2/3 Uninstall Shared Libraries and Components...");
        try {
            this.installation.shutdown();
        }
        catch (Exception exception) {
            this.log.error((Object)"Can not shut down the Installation service", (Throwable)exception);
        }
        this.log.info((Object)"  3/3 Stopping the server...");
        this.petalsStopThread.start();
        this.log.end();
    }

    @Override
    public void stopContainer() throws Exception {
        this.log.start();
        this.log.info((Object)"PEtALS is stopping...");
        this.petalsStopThread.start();
        this.log.end();
    }

    @Override
    public void setPetalsStopThread(PetalsStopThread petalsStopThread) {
        this.petalsStopThread = petalsStopThread;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IllegalLifeCycleException {
        this.log = new LoggingUtil(Logger.getLogger("Petals.PetalsAdminService"));
        this.log.call();
        this.containerConfiguration = this.configurationService.getContainerConfiguration();
        this.subDomainConfiguration = this.configurationService.getSubDomainConfiguration();
        this.domainConfiguration = this.configurationService.getDomainConfiguration();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws IllegalLifeCycleException {
        this.log.call();
    }

    private Set<ContainerConfiguration> getContainersConfiguration() throws PetalsException {
        this.log.start();
        HashSet<ContainerConfiguration> hashSet = null;
        if (this.topologyService == null) {
            hashSet = new HashSet<ContainerConfiguration>();
            hashSet.add(this.containerConfiguration);
        } else {
            hashSet = this.topologyService.getContainersConfiguration(null);
        }
        this.log.end();
        return hashSet;
    }

    private Set<SubDomainConfiguration> getSubDomainsConfiguration() throws PetalsException {
        this.log.start();
        Set<Object> set = null;
        if (this.topologyService == null) {
            set = new HashSet();
            set.add(this.subDomainConfiguration);
        } else {
            set = this.topologyService.getSubDomainsConfiguration();
        }
        this.log.end();
        return set;
    }

    private Map<String, String> getDomainMap() {
        this.log.start();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", "domain");
        hashMap.put("domainName", this.domainConfiguration.getName());
        if (this.domainConfiguration.getDescription() != null) {
            hashMap.put("domainDescription", this.domainConfiguration.getDescription());
        }
        if (DomainConfiguration.DomainMode.STATIC.equals((Object)this.domainConfiguration.getMode())) {
            hashMap.put("domainMode", "static");
        } else {
            hashMap.put("domainMode", "standalone");
        }
        if (this.domainConfiguration.getJndiConfiguration() != null) {
            if (this.domainConfiguration.getJndiConfiguration().getJndiFactory() != null) {
                hashMap.put("jndiFactory", this.domainConfiguration.getJndiConfiguration().getJndiFactory());
            }
            hashMap.put("jndiProviderUrl", this.domainConfiguration.getJndiConfiguration().getJndiProviderUrl().toString());
            hashMap.put("jndiSecurityPrincipal", this.domainConfiguration.getJndiConfiguration().getJndiSecurityPrincipal());
            hashMap.put("jndiSecurityCredentials", this.domainConfiguration.getJndiConfiguration().getJndiSecurityCredentials());
            hashMap.put("jndiPoolSize", Integer.toString(this.domainConfiguration.getJndiConfiguration().getJndiPoolSize()));
            hashMap.put("jndiBatchSize", Integer.toString(this.domainConfiguration.getJndiConfiguration().getJndiBatchSize()));
        }
        this.log.end();
        return hashMap;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("deployment")) {
            if (!DeploymentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DeploymentService.class.getName());
            }
            this.deployment = (DeploymentService)object;
            return;
        }
        if (string.equals("installation")) {
            if (!InstallationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + InstallationService.class.getName());
            }
            this.installation = (InstallationService)object;
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.registry = (EndpointRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("deployment");
        arrayList.add("installation");
        arrayList.add("topology");
        arrayList.add("configuration");
        arrayList.add("endpoint");
        return arrayList.toArray(new String[0]);
    }

    private Map<String, String> getSubdomainMap(SubDomainConfiguration subDomainConfiguration) {
        this.log.start();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", "subdomain");
        hashtable.put("subdomainName", subDomainConfiguration.getName());
        if (subDomainConfiguration.getDescription() != null) {
            hashtable.put("subdomainDescription", subDomainConfiguration.getDescription());
        }
        hashtable.put("networkTimeSynchronized", Boolean.toString(subDomainConfiguration.isNetworkTimeSynchronized()));
        this.log.end();
        return hashtable;
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("deployment")) {
            return this.deployment;
        }
        if (string.equals("installation")) {
            return this.installation;
        }
        if (string.equals("topology")) {
            return this.topologyService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("endpoint")) {
            return this.registry;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("deployment")) {
            this.deployment = null;
            return;
        }
        if (string.equals("installation")) {
            this.installation = null;
            return;
        }
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("endpoint")) {
            this.registry = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private Map<String, String> getContainerMap(ContainerConfiguration containerConfiguration) {
        this.log.start();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", "container");
        hashtable.put("containerName", containerConfiguration.getName());
        hashtable.put("nodeType", containerConfiguration.getRegistryMode().toString());
        if (containerConfiguration.getDescription() != null) {
            hashtable.put("containerDescription", containerConfiguration.getDescription());
        }
        hashtable.put("subdomainName", containerConfiguration.getSubdomainName());
        hashtable.put("host", containerConfiguration.getHost());
        hashtable.put("user", containerConfiguration.getUser());
        hashtable.put("password", containerConfiguration.getPassword());
        hashtable.put("jmxRMIPort", Integer.toString(containerConfiguration.getJmxRMIConnectorPort()));
        if (containerConfiguration.getWebservicePort() != 0) {
            hashtable.put("webserviceHTTPPort", Integer.toString(containerConfiguration.getWebservicePort()));
        }
        hashtable.put("webserviceURLPrefix", containerConfiguration.getWebservicePrefix());
        if (containerConfiguration.getTCPPort() != 0) {
            hashtable.put("transportTCPPort", Integer.toString(containerConfiguration.getTCPPort()));
        }
        if (containerConfiguration.getRegistryPort() != 0) {
            hashtable.put("registryPort", Integer.toString(containerConfiguration.getRegistryPort()));
        }
        if (ContainerConfiguration.ContainerState.STARTED.equals((Object)containerConfiguration.getState())) {
            hashtable.put("state", "STARTED");
        } else {
            hashtable.put("state", "STOPPED");
        }
        this.log.end();
        return hashtable;
    }

    @Override
    public boolean ping() {
        return this.topologyService.isContainerStarted(this.containerConfiguration.getName());
    }
}

