/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.configuration;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.kernel.configuration.ConfigurationException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.ContainerConfigurationHelper;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.configuration.JndiConfiguration;
import org.ow2.petals.kernel.configuration.SubDomainConfiguration;
import org.ow2.petals.topology.TopologyBuilder;
import org.ow2.petals.topology.TopologyException;
import org.ow2.petals.topology.TopologyHelper;
import org.ow2.petals.topology.generated.Container;
import org.ow2.petals.topology.generated.Domain;
import org.ow2.petals.topology.generated.DomainMode;
import org.ow2.petals.topology.generated.JmxService;
import org.ow2.petals.topology.generated.NodeType;
import org.ow2.petals.topology.generated.RegistryService;
import org.ow2.petals.topology.generated.Subdomain;
import org.ow2.petals.topology.generated.SubdomainMode;
import org.ow2.petals.topology.generated.Topology;
import org.ow2.petals.topology.generated.TransportService;
import org.ow2.petals.topology.generated.WebServiceService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ConfigurationService.class)})
public class ConfigurationServiceImpl
implements LifeCycleController,
ConfigurationService {
    protected LoggingUtil log;
    private ContainerConfiguration containerConfiguration;
    private Map<String, ContainerConfiguration> containersConfig;
    private DomainConfiguration domainConfiguration;
    private Properties serverProperties;
    private SubDomainConfiguration subDomainConfiguration;
    private Map<String, SubDomainConfiguration> subDomainsConfig;
    private Topology topology;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public synchronized void addContainerConfiguration(ContainerConfiguration containerConfiguration) throws ConfigurationException {
        Object object3;
        if (containerConfiguration == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can't add a null container to the local topology");
            throw new ConfigurationException(stringBuilder.toString());
        }
        String string = this.containerConfiguration.getName();
        String string2 = null;
        if (containerConfiguration.getName() == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can't retrieve the container name");
            throw new ConfigurationException(stringBuilder.toString());
        }
        string2 = containerConfiguration.getName();
        if (string2.equals(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can't add a container with the same name as the current one");
            throw new ConfigurationException(stringBuilder.toString());
        }
        String string3 = containerConfiguration.getSubdomainName();
        if (string3 == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Null subdomain found for the added container : " + containerConfiguration);
            throw new ConfigurationException(stringBuilder.toString());
        }
        if (this.containersConfig.containsKey(containerConfiguration.getName())) {
            this.removeContainerConfiguration(containerConfiguration);
        }
        List list = this.topology.getDomain().getSubDomain();
        Object object2 = null;
        for (Object object3 : list) {
            if (!object3.getName().equals(string3)) continue;
            object2 = object3;
            break;
        }
        if (object2 == null) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("No subdomain found for the added container : " + containerConfiguration);
            throw new ConfigurationException(((StringBuilder)object3).toString());
        }
        object3 = new Container();
        object3.setName(containerConfiguration.getName());
        object3.setDescription(containerConfiguration.getDescription());
        object3.setHost(containerConfiguration.getHost());
        object3.setUser(containerConfiguration.getUser());
        object3.setPassword(containerConfiguration.getPassword());
        JmxService jmxService = new JmxService();
        jmxService.setRmiPort(containerConfiguration.getJmxRMIConnectorPort());
        object3.setJmxService(jmxService);
        WebServiceService webServiceService = new WebServiceService();
        webServiceService.setPort(containerConfiguration.getWebservicePort());
        webServiceService.setPrefix(containerConfiguration.getWebservicePrefix());
        object3.setWebserviceService(webServiceService);
        RegistryService registryService = new RegistryService();
        registryService.setPort(Integer.valueOf(containerConfiguration.getRegistryPort()));
        object3.setRegistryService(registryService);
        TransportService transportService = new TransportService();
        transportService.setTcpPort(containerConfiguration.getTCPPort());
        object3.setTransportService(transportService);
        switch (containerConfiguration.getRegistryMode()) {
            case PEER: {
                object3.setType(NodeType.PEER);
                break;
            }
            case MASTER: {
                object3.setType(NodeType.MASTER);
                break;
            }
            case SLAVE: {
                object3.setType(NodeType.SLAVE);
                break;
            }
            case STANDALONE: {
                object3.setType(NodeType.STANDALONE);
                break;
            }
            default: {
                throw new ConfigurationException("Unknown registry mode");
            }
        }
        object2.getContainer().add(object3);
        this.containersConfig.put(string2, containerConfiguration);
    }

    @Override
    public synchronized void addSubdomainConfiguration(SubDomainConfiguration subDomainConfiguration) throws ConfigurationException {
        if (subDomainConfiguration == null) {
            throw new ConfigurationException("Can't add a null subdomain to the local topology");
        }
        if (this.subDomainsConfig.containsKey(subDomainConfiguration.getName())) {
            throw new ConfigurationException("Subdomain already registered for name : " + subDomainConfiguration.getName());
        }
        this.subDomainsConfig.put(subDomainConfiguration.getName(), subDomainConfiguration);
        Subdomain subdomain = new Subdomain();
        subdomain.setName(subDomainConfiguration.getName());
        subdomain.setDescription(subDomainConfiguration.getDescription());
        subdomain.setMode(subDomainConfiguration.getMode());
        subdomain.setNetworkTimeSynchronized(Boolean.valueOf(subDomainConfiguration.isNetworkTimeSynchronized()));
        this.topology.getDomain().getSubDomain().add(subdomain);
    }

    @Override
    public void backupTopology() throws ConfigurationException {
        URL uRL;
        if (this.serverProperties == null) {
            throw new ConfigurationException("server properties are null");
        }
        File file = null;
        String string = this.serverProperties.getProperty("petals.topology.url");
        if (string != null && string.trim().length() > 0) {
            try {
                uRL = new URL(string);
                File file2 = new File(this.containerConfiguration.getWorkDirectoryPath());
                file = new File(file2, "topology.xml");
                FileUtils.copyURLToFile((URL)uRL, (File)file);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ConfigurationException("Bad topology URL '" + string + "'");
            }
            catch (IOException iOException) {
                throw new ConfigurationException("Can copy topology file from '" + string + "'");
            }
        }
        uRL = this.getClass().getResource("/topology.xml");
        if (uRL == null) {
            throw new ConfigurationException("Failed to get resource '/topology.xml'");
        }
        try {
            file = new File(uRL.toURI().normalize());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ConfigurationException(uRISyntaxException.getMessage());
        }
        try {
            TopologyBuilder.marshallTopologyFile((File)file, (Topology)this.topology);
        }
        catch (TopologyException topologyException) {
            throw new ConfigurationException(topologyException.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    @Override
    public Properties getServerProperties() {
        Properties properties = new Properties();
        properties.put("petals.repository.path", this.containerConfiguration.getRepositoryDirectoryPath());
        properties.put("petals.exchange.validation", Boolean.toString(this.containerConfiguration.isExchangeValidation()));
        properties.put("petals.transport.queue.max-size", Integer.toString(this.containerConfiguration.getTransporterQueueMaxSize()));
        properties.put("petals.transport.queue.offering.timeout", Long.toString(this.containerConfiguration.getTransporterQueueOfferingTimeout()));
        properties.put("petals.transport.tcp.receivers", Integer.toString(this.containerConfiguration.getTCPReceivers()));
        properties.put("petals.transport.tcp.senders", Integer.toString(this.containerConfiguration.getTCPSenders()));
        properties.put("petals.transport.tcp.connection.timeout", Long.toString(this.containerConfiguration.getTCPConnectionTimeout()));
        properties.put("petals.transport.tcp.send.timeout", Long.toString(this.containerConfiguration.getTCPSendTimeout()));
        properties.put("petals.transport.tcp.send.evictor.delay", Long.toString(this.containerConfiguration.getTCPSenderEvictorDelay()));
        properties.put("petals.transport.tcp.send.evictable.delay", Long.toString(this.containerConfiguration.getTCPSenderEvictableDelay()));
        properties.put("petals.router.qos", this.containerConfiguration.getRouterQOS());
        properties.put("petals.router.strategy", this.containerConfiguration.getRouterStrategy());
        properties.put("petals.router.send.attempt", Short.toString(this.containerConfiguration.getRouterSendAttempt()));
        properties.put("petals.router.send.delay", Integer.toString(this.containerConfiguration.getRouterSendDelay()));
        properties.put("petals.task.timeout", Long.toString(this.containerConfiguration.getTaskTimeout()));
        properties.put("petals.classloaders.isolated", Boolean.toString(this.containerConfiguration.isIsolateJBIClassLoaders()));
        properties.put("petals.autoloader", Boolean.toString(this.containerConfiguration.isActivateAutoloader()));
        properties.put("petals.autoloader.scan.period", Long.toString(this.containerConfiguration.getAutoloaderScanPeriod()));
        properties.put("petals.ssl.key.password", this.containerConfiguration.getSSLKeyPassword() == null ? "" : this.containerConfiguration.getSSLKeyPassword());
        properties.put("petals.ssl.keystore.file", this.containerConfiguration.getSSLKeystore() == null ? "" : this.containerConfiguration.getSSLKeystore());
        properties.put("petals.ssl.keystore.password", this.containerConfiguration.getSSLKeystorePassword() == null ? "" : this.containerConfiguration.getSSLKeystorePassword());
        properties.put("petals.ssl.truststore.file", this.containerConfiguration.getSSLTruststore() == null ? "" : this.containerConfiguration.getSSLTruststore());
        properties.put("petals.ssl.truststore.password", this.containerConfiguration.getSSLTruststorePassword() == null ? "" : this.containerConfiguration.getSSLTruststorePassword());
        properties.put("registry.transport.timeout", Integer.toString(this.containerConfiguration.getRegistryTransportTimeout()));
        properties.put("registry.synchro.period", Integer.toString(this.containerConfiguration.getRegistrySynchroPeriod()));
        properties.put("registry.repository", this.containerConfiguration.getRegistryRepository() == null ? "" : this.containerConfiguration.getRegistryRepository());
        properties.put("registry.db.driver", this.containerConfiguration.getRegistryDatabaseDriver());
        properties.put("registry.db.url", this.containerConfiguration.getRegistryDatabaseUrl());
        properties.put("registry.db.user", this.containerConfiguration.getRegistryDatabaseUser());
        properties.put("registry.db.password", this.containerConfiguration.getRegistryDatabasePassword());
        properties.put("registry.db.dialect", this.containerConfiguration.getRegistryDatabaseDialect() == null ? "" : this.containerConfiguration.getRegistryDatabaseDialect());
        properties.put("petals.persistence.duration", Long.toString(this.containerConfiguration.getPersistenceDuration()));
        properties.put("petals.persistence.fetch-size", Integer.toString(this.containerConfiguration.getPersistenceFetchSize()));
        properties.put("topology.update.period", Long.toString(this.containerConfiguration.getTopologyUpdatePeriod()));
        properties.put("petals.recovery.corepoolsize", Integer.toString(this.containerConfiguration.getRecoveryCorePoolSize()));
        properties.put("petals.recovery.maxpoolsize", Integer.toString(this.containerConfiguration.getRecoveryMaxPoolSize()));
        properties.put("petals.recovery.keepalivetime", Long.toString(this.containerConfiguration.getRecoveryKeepAliveTime()));
        return properties;
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public synchronized ContainerConfiguration getContainerConfiguration(String string) {
        ContainerConfiguration containerConfiguration = null;
        containerConfiguration = this.containerConfiguration.getName().equals(string) ? this.getContainerConfiguration() : this.containersConfig.get(string);
        return containerConfiguration;
    }

    @Override
    public synchronized Set<ContainerConfiguration> getContainersConfiguration() {
        HashSet<ContainerConfiguration> hashSet = new HashSet<ContainerConfiguration>(this.containersConfig.size());
        for (ContainerConfiguration containerConfiguration : this.containersConfig.values()) {
            hashSet.add(containerConfiguration);
        }
        return hashSet;
    }

    @Override
    public synchronized DomainConfiguration getDomainConfiguration() {
        this.log.call();
        return this.domainConfiguration;
    }

    @Override
    public synchronized SubDomainConfiguration getSubDomainConfiguration() {
        this.log.call();
        return this.subDomainConfiguration;
    }

    @Override
    public synchronized Set<SubDomainConfiguration> getSubDomainsConfiguration() {
        HashSet<SubDomainConfiguration> hashSet = new HashSet<SubDomainConfiguration>(this.subDomainsConfig.size());
        for (SubDomainConfiguration subDomainConfiguration : this.subDomainsConfig.values()) {
            hashSet.add(subDomainConfiguration);
        }
        return hashSet;
    }

    @Override
    public synchronized Topology getTopology() throws ConfigurationException {
        this.log.call();
        return this.topology;
    }

    @Override
    public synchronized void loadTopology() throws ConfigurationException {
        URL uRL;
        if (this.serverProperties == null) {
            throw new ConfigurationException("server properties are null");
        }
        File file = null;
        String string = this.serverProperties.getProperty("petals.topology.url");
        if (string != null && string.trim().length() > 0) {
            try {
                uRL = new URL(string);
                File file2 = new File(this.containerConfiguration.getWorkDirectoryPath());
                file = new File(file2, "topology.xml");
                FileUtils.copyURLToFile((URL)uRL, (File)file);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ConfigurationException("Bad topology URL '" + string + "'");
            }
            catch (IOException iOException) {
                throw new ConfigurationException("Can copy topology file from '" + string + "'");
            }
        }
        uRL = this.getClass().getResource("/topology.xml");
        if (uRL == null) {
            throw new ConfigurationException("Failed to get resource '/topology.xml'");
        }
        try {
            file = new File(uRL.toURI().normalize());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ConfigurationException(uRISyntaxException.getMessage());
        }
        try {
            this.topology = TopologyBuilder.createTopology((File)file);
        }
        catch (TopologyException topologyException) {
            if (topologyException.getCause() != null) {
                throw new ConfigurationException(topologyException);
            }
            throw new ConfigurationException(topologyException.getMessage());
        }
    }

    @Override
    public synchronized void removeContainerConfiguration(ContainerConfiguration containerConfiguration) throws ConfigurationException {
        if (containerConfiguration == null) {
            throw new ConfigurationException("Can't remove container : null");
        }
        if (!this.containersConfig.containsKey(containerConfiguration.getName())) {
            throw new ConfigurationException("No container found for name : " + containerConfiguration.getName());
        }
        String string = containerConfiguration.getSubdomainName();
        if (string == null) {
            throw new ConfigurationException("No subdomain name found for the removed container");
        }
        List list = this.topology.getDomain().getSubDomain();
        Subdomain subdomain = null;
        for (Subdomain subdomain2 : list) {
            if (!subdomain2.getName().equals(string)) continue;
            subdomain = subdomain2;
            break;
        }
        if (subdomain == null) {
            throw new ConfigurationException("No subdomain found for the added container : " + containerConfiguration);
        }
        for (Subdomain subdomain2 : subdomain.getContainer()) {
            if (!subdomain2.getName().equals(containerConfiguration.getName())) continue;
            subdomain.getContainer().remove(subdomain2);
            break;
        }
        this.containersConfig.remove(containerConfiguration.getName());
    }

    @Override
    public synchronized void removeSubdomainConfiguration(String string) throws ConfigurationException {
        if (string == null) {
            throw new ConfigurationException("Can't remove subdomain : null");
        }
        if (!this.subDomainsConfig.containsKey(string)) {
            throw new ConfigurationException("No subdomain found for name : " + string);
        }
        Subdomain subdomain = null;
        for (Subdomain subdomain2 : this.topology.getDomain().getSubDomain()) {
            if (!subdomain2.getName().equals(string)) continue;
            this.topology.getDomain().getSubDomain().remove(subdomain2);
            subdomain = subdomain2;
            break;
        }
        if (subdomain == null) {
            throw new ConfigurationException("No subdomain found for name : " + string);
        }
        this.subDomainsConfig.remove(string);
        this.removeSubdomainContainers(string);
    }

    @Override
    public synchronized void setContainerState(ContainerConfiguration.ContainerState containerState) {
        this.containerConfiguration.setState(containerState);
    }

    @Override
    public void validateDynamicTopology() throws ConfigurationException {
        try {
            this.verifyDomain(this.domainConfiguration);
            for (Map.Entry<String, SubDomainConfiguration> entry : this.subDomainsConfig.entrySet()) {
                this.verifySubDomain(entry.getValue());
            }
            for (Map.Entry<String, Serializable> entry : this.containersConfig.entrySet()) {
                this.verifyContainer((ContainerConfiguration)entry.getValue());
            }
        }
        catch (TopologyException topologyException) {
            throw new ConfigurationException(topologyException);
        }
    }

    @Override
    public synchronized void verifyContainerTopology(ContainerConfiguration containerConfiguration, SubDomainConfiguration subDomainConfiguration, DomainConfiguration domainConfiguration) throws TopologyException {
        this.log.start();
        this.verifyDomain(domainConfiguration);
        this.verifySubDomain(subDomainConfiguration);
        this.verifyContainer(containerConfiguration);
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws Exception {
        this.log = new LoggingUtil(Logger.getLogger("Petals.ConfigurationService"));
        this.log.start();
        try {
            URL uRL = this.getClass().getResource("/server.properties");
            if (uRL == null) {
                throw new IOException("Failed to reach the resource '/server.properties'");
            }
            File file = new File(uRL.toURI().normalize());
            this.containersConfig = new HashMap<String, ContainerConfiguration>();
            this.subDomainsConfig = new HashMap<String, SubDomainConfiguration>();
            this.containerConfiguration = new ContainerConfiguration();
            this.containerConfiguration.init();
            this.subDomainConfiguration = new SubDomainConfiguration();
            this.domainConfiguration = new DomainConfiguration();
            this.createConfiguration(file);
            this.containersConfig.put(this.containerConfiguration.getName(), this.containerConfiguration);
        }
        catch (IOException iOException) {
            this.log.error((Object)"Failed to start configuration service", (Throwable)iOException);
            throw iOException;
        }
        catch (ConfigurationException configurationException) {
            this.log.error((Object)"Failed to start configuration service", (Throwable)((Object)configurationException));
            throw configurationException;
        }
        catch (JAXBException jAXBException) {
            this.log.error((Object)"Failed to start configuration service", (Throwable)jAXBException);
            throw jAXBException;
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws Exception {
        this.log.call();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void createConfiguration(File file) throws IOException, JAXBException, ConfigurationException {
        this.log.start();
        this.serverProperties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.serverProperties.load(fileInputStream);
            String string = this.serverProperties.getProperty("petals.container.name");
            if (string == null) {
                string = System.getProperty("petals.container.name");
            }
            this.loadTopology();
            SubDomainAndContainerNames subDomainAndContainerNames = this.validateTopology(string);
            this.fillGlobalTopology();
            this.fillSubDomainTopology(subDomainAndContainerNames.subDomainName);
            this.fillLocalTopology(subDomainAndContainerNames.containerName);
            this.fillLocalProperties();
            this.fillGlobalContainerConfig();
            this.fillGlobalDomainConfig();
            if (DomainConfiguration.DomainMode.STANDALONE.equals((Object)this.domainConfiguration.getMode())) {
                this.containerConfiguration.setState(ContainerConfiguration.ContainerState.STARTED);
            } else {
                this.postValidate();
            }
            if (this.domainConfiguration.getMode() == DomainConfiguration.DomainMode.STANDALONE) {
                throw new ConfigurationException("Standalone mode is not supported anymore");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Configuration used :");
                this.log.debug((Object)this.containerConfiguration);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            fileInputStream.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        fileInputStream.close();
        this.log.end();
    }

    private void fillGlobalContainerConfig() {
        Collection collection = TopologyHelper.findAllContainers((Topology)this.topology);
        for (Container container : collection) {
            ContainerConfiguration containerConfiguration = new ContainerConfiguration();
            ContainerConfigurationHelper.fill(containerConfiguration, container);
            containerConfiguration.setSubdomainName(TopologyHelper.findSubdomain((Container)container, (Topology)this.topology).getName());
            this.containersConfig.put(containerConfiguration.getName(), containerConfiguration);
        }
    }

    private void fillGlobalDomainConfig() {
        List list = this.topology.getDomain().getSubDomain();
        for (Subdomain subdomain : list) {
            SubDomainConfiguration subDomainConfiguration = new SubDomainConfiguration();
            subDomainConfiguration.setDescription(subdomain.getDescription());
            subDomainConfiguration.setName(subdomain.getName());
            subDomainConfiguration.setMode(subdomain.getMode());
            this.subDomainsConfig.put(subDomainConfiguration.getName(), subDomainConfiguration);
        }
    }

    private void fillGlobalTopology() throws ConfigurationException {
        this.log.start();
        this.domainConfiguration.setName(this.topology.getDomain().getName());
        this.domainConfiguration.setDescription(this.topology.getDomain().getDescription());
        if (DomainMode.STANDALONE.equals((Object)this.topology.getDomain().getMode())) {
            this.domainConfiguration.setMode(DomainConfiguration.DomainMode.STANDALONE);
            this.containerConfiguration.setRouterStrategy("standalone");
        } else if (DomainMode.STATIC.equals((Object)this.topology.getDomain().getMode())) {
            this.domainConfiguration.setMode(DomainConfiguration.DomainMode.STATIC);
        } else if (DomainMode.DYNAMIC.equals((Object)this.topology.getDomain().getMode())) {
            this.domainConfiguration.setMode(DomainConfiguration.DomainMode.DYNAMIC);
        } else {
            throw new ConfigurationException("Unknown domain mode");
        }
        if (this.topology.getDomain().getJndi() != null) {
            JndiConfiguration jndiConfiguration = new JndiConfiguration();
            jndiConfiguration.setJndiFactory(this.topology.getDomain().getJndi().getFactory());
            try {
                jndiConfiguration.setJndiProviderUrl(new URI(this.topology.getDomain().getJndi().getProviderUrl()));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ConfigurationException(uRISyntaxException);
            }
            jndiConfiguration.setJndiSecurityPrincipal(this.topology.getDomain().getJndi().getSecurityPrincipal());
            jndiConfiguration.setJndiSecurityCredentials(this.topology.getDomain().getJndi().getSecurityCredentials());
            jndiConfiguration.setJndiPoolSize(this.topology.getDomain().getJndi().getPoolSize());
            jndiConfiguration.setJndiBatchSize(this.topology.getDomain().getJndi().getBatchSize());
            this.domainConfiguration.setJndiConfiguration(jndiConfiguration);
        }
        this.log.end();
    }

    private void fillLocalProperties() {
        this.log.start();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object : this.serverProperties.keySet()) {
            if (!(object instanceof String)) continue;
            if (((String)object).equals("petals.repository.path")) {
                this.containerConfiguration.setRepositoryDirectoryPath(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("petals.exchange.validation")) {
                this.containerConfiguration.setExchangeValidation(Boolean.parseBoolean(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.transport.queue.max-size")) {
                this.containerConfiguration.setTransporterQueueMaxSize(Integer.parseInt(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.transport.queue.offering.timeout")) {
                this.containerConfiguration.setTransporterQueueOfferingTimeout(Long.parseLong(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.transport.tcp.receivers")) {
                this.containerConfiguration.setTCPReceivers(Integer.parseInt(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.transport.tcp.senders")) {
                this.containerConfiguration.setTCPSenders(Integer.parseInt(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.transport.tcp.connection.timeout")) {
                this.containerConfiguration.setTCPConnectionTimeout(Long.parseLong(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.transport.tcp.send.timeout")) {
                this.containerConfiguration.setTCPSendTimeout(Long.parseLong(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.transport.tcp.send.evictor.delay")) {
                this.containerConfiguration.setTCPSenderEvictorDelay(Long.parseLong(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.transport.tcp.send.evictable.delay")) {
                this.containerConfiguration.setTCPSenderEvictableDelay(Long.parseLong(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.router.qos")) {
                this.containerConfiguration.setRouterQOS(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("petals.router.strategy")) {
                this.containerConfiguration.setRouterStrategy(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("petals.router.send.attempt")) {
                this.containerConfiguration.setRouterSendAttempt(Short.parseShort(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.router.send.delay")) {
                this.containerConfiguration.setRouterSendDelay(Integer.parseInt(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.task.timeout")) {
                this.containerConfiguration.setTaskTimeout(Long.parseLong(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.classloaders.isolated")) {
                this.containerConfiguration.setIsolateJBIClassLoaders(Boolean.parseBoolean(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.autoloader")) {
                this.containerConfiguration.setActivateAutoloader(Boolean.parseBoolean(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.autoloader.scan.period")) {
                this.containerConfiguration.setAutoloaderScanPeriod(Long.parseLong(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.ssl.key.password")) {
                this.containerConfiguration.setSSLKeyPassword(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("petals.ssl.keystore.file")) {
                this.containerConfiguration.setSSLKeystore(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("petals.ssl.keystore.password")) {
                this.containerConfiguration.setSSLKeystorePassword(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("petals.ssl.truststore.file")) {
                this.containerConfiguration.setSSLTruststore(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("petals.ssl.truststore.password")) {
                this.containerConfiguration.setSSLTruststorePassword(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("registry.transport.timeout")) {
                this.containerConfiguration.setRegistryTransportTimeout(Integer.parseInt(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("registry.synchro.period")) {
                this.containerConfiguration.setRegistrySynchroPeriod(Integer.parseInt(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("registry.repository")) {
                this.containerConfiguration.setRegistryRepository(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("registry.db.driver")) {
                this.containerConfiguration.setRegistryDatabaseDriver(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("registry.db.url")) {
                this.containerConfiguration.setRegistryDatabaseUrl(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("registry.db.user")) {
                this.containerConfiguration.setRegistryDatabaseUser(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("registry.db.password")) {
                this.containerConfiguration.setRegistryDatabasePassword(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("registry.db.dialect")) {
                this.containerConfiguration.setRegistryDatabaseDialect(this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("petals.persistence.duration")) {
                this.containerConfiguration.setPersistenceDuration(Long.parseLong(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.persistence.fetch-size")) {
                this.containerConfiguration.setPersistenceFetchSize(Integer.parseInt(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("topology.update.period")) {
                this.containerConfiguration.setTopologyUpdatePeriod(Long.parseLong(this.serverProperties.getProperty((String)object, "30")));
                continue;
            }
            if (((String)object).startsWith("user.")) {
                hashMap.put((String)object, this.serverProperties.getProperty((String)object));
                continue;
            }
            if (((String)object).equals("petals.recovery.corepoolsize")) {
                this.containerConfiguration.setRecoveryCorePoolSize(Integer.parseInt(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (((String)object).equals("petals.recovery.maxpoolsize")) {
                this.containerConfiguration.setRecoveryMaxPoolSize(Integer.parseInt(this.serverProperties.getProperty((String)object)));
                continue;
            }
            if (!((String)object).equals("petals.recovery.keepalivetime")) continue;
            this.containerConfiguration.setRecoveryKeepAliveTime(Long.parseLong(this.serverProperties.getProperty((String)object)));
        }
        if (hashMap.size() > 0) {
            this.containerConfiguration.setUserConfiguration(hashMap);
        }
        this.log.end();
    }

    private void fillLocalTopology(String string) throws ConfigurationException {
        this.log.start();
        Container container = TopologyHelper.findContainer((String)string, (Topology)this.topology);
        if (container == null) {
            throw new ConfigurationException("Failed to retrieve the container configuration for the container named '" + string + "'");
        }
        ContainerConfigurationHelper.fill(this.containerConfiguration, container);
        this.containerConfiguration.setName(string);
        this.containerConfiguration.setSubdomainName(TopologyHelper.findSubdomain((Container)container, (Topology)this.topology).getName());
        this.log.end();
    }

    private void fillSubDomainTopology(String string) throws ConfigurationException {
        this.log.start();
        Subdomain subdomain = TopologyHelper.findSubdomain((String)string, (Topology)this.topology);
        if (subdomain == null) {
            throw new ConfigurationException("Failed to retrieve the sub-domain configuration for the sub-domain named '" + string + "'");
        }
        this.subDomainConfiguration.setName(string);
        this.subDomainConfiguration.setDescription(subdomain.getDescription());
        if (subdomain.isNetworkTimeSynchronized() != null) {
            this.subDomainConfiguration.setNetworkTimeSynchronized(subdomain.isNetworkTimeSynchronized());
        }
        this.log.end();
    }

    private void postValidate() throws ConfigurationException {
        if ("fast".equals(this.containerConfiguration.getRouterQOS()) && this.containerConfiguration.getTCPPort() == 0) {
            throw new ConfigurationException("The router transport QOS 'fast' is not compatible with the transport protocols configuration");
        }
        if ("secure".equals(this.containerConfiguration.getRouterQOS())) {
            throw new ConfigurationException("The default router QOS 'secure' is not compatible with the transport protocols configuration");
        }
    }

    private synchronized void removeSubdomainContainers(String string) throws ConfigurationException {
        for (Map.Entry<String, ContainerConfiguration> entry : this.containersConfig.entrySet()) {
            if (!entry.getValue().getSubdomainName().equals(string)) continue;
            this.containersConfig.remove(entry.getKey());
        }
    }

    private void validateStaticTopology() throws ConfigurationException {
        Subdomain subdomain2;
        this.log.start();
        HashSet<String> hashSet = new HashSet<String>();
        for (Subdomain subdomain2 : this.topology.getDomain().getSubDomain()) {
            if (hashSet.add(subdomain2.getName())) continue;
            throw new ConfigurationException("Duplicate sub-domain name '" + subdomain2.getName() + "'");
        }
        subdomain2 = new HashSet();
        Hashtable hashtable = new Hashtable();
        for (Container container : TopologyHelper.findAllContainers((Topology)this.topology)) {
            HashSet hashSet2;
            if (container.getHost() == null) {
                throw new ConfigurationException("The container named '" + container.getName() + "' must declare its host element in static distributed mode");
            }
            if (!hashtable.containsKey(container.getHost())) {
                hashSet2 = new HashSet();
                hashtable.put(container.getHost(), hashSet2);
            } else {
                hashSet2 = (HashSet)hashtable.get(container.getHost());
            }
            if (container.getWebserviceService() != null && container.getWebserviceService().getPort() != 0 && !hashSet2.add(container.getWebserviceService().getPort())) {
                throw new ConfigurationException("Duplicate port " + container.getWebserviceService().getPort() + " on host '" + container.getHost() + "'");
            }
            if (container.getRegistryService() != null && container.getRegistryService().getPort() != null && !hashSet2.add(container.getRegistryService().getPort())) {
                throw new ConfigurationException("Duplicate port " + container.getWebserviceService().getPort() + " on host '" + container.getHost() + "'");
            }
            if (container.getJmxService().getRmiPort() != 0 && !hashSet2.add(container.getJmxService().getRmiPort())) {
                throw new ConfigurationException("Duplicate port " + container.getJmxService().getRmiPort() + " on host '" + container.getHost() + "'");
            }
            if (container.getTransportService() != null && container.getTransportService().getTcpPort() >= 0 && !hashSet2.add(container.getTransportService().getTcpPort())) {
                throw new ConfigurationException("Duplicate port " + container.getTransportService().getTcpPort() + " on host '" + container.getHost() + "'");
            }
            if (subdomain2.add(container.getName())) continue;
            throw new ConfigurationException("Duplicate container name '" + container.getName() + "'");
        }
        this.log.end();
    }

    private SubDomainAndContainerNames validateTopology(String string) throws ConfigurationException {
        SubdomainMode subdomainMode;
        Object object;
        Object object22;
        this.log.start();
        SubDomainAndContainerNames subDomainAndContainerNames = new SubDomainAndContainerNames();
        Domain domain = this.topology.getDomain();
        List list = domain.getSubDomain();
        if (domain.getMode().equals((Object)DomainMode.STANDALONE)) {
            if (list.size() > 1) {
                throw new ConfigurationException("Standalone topology mode accepts only one subdomain definition");
            }
            object22 = (Subdomain)list.get(0);
            if (object22.getContainer().size() > 1) {
                throw new ConfigurationException("Standalone topology mode accepts only one container definition");
            }
            if (!object22.getMode().equals((Object)SubdomainMode.STANDALONE)) {
                throw new ConfigurationException("Standalone topology mode accepts only standalone subdomains");
            }
            object = (Container)object22.getContainer().get(0);
            if (!object.getType().equals((Object)NodeType.STANDALONE)) {
                throw new ConfigurationException("Standalone topology moded accepts only one container");
            }
            subDomainAndContainerNames.containerName = object.getName();
        } else if (domain.getMode().equals((Object)DomainMode.STATIC) || domain.getMode().equals((Object)DomainMode.DYNAMIC)) {
            if (string == null) {
                throw new ConfigurationException("The property petals.container.name must be set in the server.properties file while being in distributed mode");
            }
            if (TopologyHelper.findContainer((String)string, (Topology)this.topology) == null) {
                throw new ConfigurationException("Cannot find the definition for the container " + string + " in the topology.xml file");
            }
            this.validateStaticTopology();
            subDomainAndContainerNames.containerName = string;
        } else {
            throw new ConfigurationException("Unsupported domain mode");
        }
        subDomainAndContainerNames.subDomainName = TopologyHelper.findSubdomain((Container)TopologyHelper.findContainer((String)subDomainAndContainerNames.containerName, (Topology)this.topology), (Topology)this.topology).getName();
        if (this.topology.getDomain().getJndi() != null) {
            if ("".equals(this.topology.getDomain().getJndi().getFactory().trim())) {
                throw new ConfigurationException("JNDI factory classname must be set to reference an external JNDI server");
            }
            if (this.topology.getDomain().getJndi().getProviderUrl() == null) {
                throw new ConfigurationException("JNDI Provider URL must be set as an JNDI server factory is set '");
            }
        }
        if (!DomainMode.STANDALONE.equals((Object)this.topology.getDomain().getMode())) {
            object22 = TopologyHelper.findAllContainers((Topology)this.topology);
            subdomainMode = object22.iterator();
            while (subdomainMode.hasNext()) {
                object = (Container)subdomainMode.next();
                if (object.getTransportService() != null) continue;
                throw new ConfigurationException("Transport service must be defined in the container '" + object.getName() + "' configuration");
            }
        }
        for (Object object22 : list) {
            Object object32;
            subdomainMode = object22.getMode();
            boolean bl = false;
            List list2 = object22.getContainer();
            for (Object object32 : list2) {
                NodeType nodeType = object32.getType();
                if (subdomainMode.equals((Object)SubdomainMode.FLOODING) && !nodeType.equals((Object)NodeType.PEER)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("When a subdomain is in flooding mode, all its ");
                    stringBuilder.append("containers must be of \"peer\" type");
                    throw new ConfigurationException(stringBuilder.toString());
                }
                if (subdomainMode.equals((Object)SubdomainMode.STANDALONE) && !nodeType.equals((Object)NodeType.STANDALONE)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("When a subdomain is in standalone mode, the container ");
                    stringBuilder.append("must be in of \"standalone\" type");
                    throw new ConfigurationException(stringBuilder.toString());
                }
                if (subdomainMode.equals((Object)SubdomainMode.MASTER_SLAVE) && !nodeType.equals((Object)NodeType.MASTER) && !nodeType.equals((Object)NodeType.SLAVE)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("When a subdomain is in master-slave mode, ");
                    stringBuilder.append("all its container must be either of ");
                    stringBuilder.append("\"master\" or \"slave\" type");
                    throw new ConfigurationException(stringBuilder.toString());
                }
                if (!nodeType.equals((Object)NodeType.MASTER)) continue;
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Master node already defined for this subdomain");
                    throw new ConfigurationException(stringBuilder.toString());
                }
                bl = true;
            }
            if (bl || !subdomainMode.equals((Object)SubdomainMode.MASTER_SLAVE)) continue;
            object32 = new StringBuilder();
            ((StringBuilder)object32).append("No master node found for the current master-slave subdomain");
            throw new ConfigurationException(((StringBuilder)object32).toString());
        }
        this.log.end();
        return subDomainAndContainerNames;
    }

    private void verifyContainer(ContainerConfiguration containerConfiguration) throws TopologyException {
        this.log.debug((Object)"Check the container configuration of the new Container.");
        if (DomainMode.STATIC.equals((Object)this.topology.getDomain().getMode())) {
            Container container = TopologyHelper.findContainer((String)containerConfiguration.getName(), (Topology)this.topology);
            if (container == null) {
                throw new TopologyException("Container name unknown");
            }
            this.log.debug((Object)("Check container " + container.getName() + " ..."));
            if (!StringHelper.equal((String)container.getUser(), (String)containerConfiguration.getUser())) {
                throw new TopologyException("User mismatch");
            }
            if (!StringHelper.equal((String)container.getPassword(), (String)containerConfiguration.getPassword())) {
                throw new TopologyException("Password mismatch");
            }
            if (container.getJmxService().getRmiPort() != containerConfiguration.getJmxRMIConnectorPort()) {
                throw new TopologyException("JMX RMI connector port mismatch");
            }
            if (container.getTransportService() == null) {
                throw new TopologyException("Can't find transport service configuration");
            }
            if (container.getTransportService().getTcpPort() == 0) {
                throw new TopologyException("Tranport service TCP port not set");
            }
            if (container.getTransportService().getTcpPort() != containerConfiguration.getTCPPort()) {
                throw new TopologyException("TCP port mismatch");
            }
        } else if (containerConfiguration.getHost().equals(this.containerConfiguration.getHost()) && containerConfiguration.getName().equals(this.containerConfiguration.getName())) {
            throw new TopologyException("Duplicate container name '" + this.containerConfiguration.getName() + "'");
        }
        this.log.debug((Object)"Container configuration of the new Container is OK");
    }

    private void verifyDomain(DomainConfiguration domainConfiguration) throws TopologyException {
        this.log.debug((Object)"Check the domain configuration of the new Container...");
        if (!domainConfiguration.getMode().equals((Object)this.domainConfiguration.getMode())) {
            throw new TopologyException("Domain mode mismatch");
        }
        if (!StringHelper.equal((String)domainConfiguration.getJndiConfiguration().getJndiFactory(), (String)this.domainConfiguration.getJndiConfiguration().getJndiFactory())) {
            throw new TopologyException("JNDI factory mismatch");
        }
        if (domainConfiguration.getJndiConfiguration().getJndiProviderUrl() == null && this.domainConfiguration.getJndiConfiguration().getJndiProviderUrl() != null || domainConfiguration.getJndiConfiguration().getJndiProviderUrl() != null && this.domainConfiguration.getJndiConfiguration().getJndiProviderUrl() == null || domainConfiguration.getJndiConfiguration().getJndiProviderUrl() != null && this.domainConfiguration.getJndiConfiguration().getJndiProviderUrl() != null && domainConfiguration.getJndiConfiguration().getJndiProviderUrl().toString().equals(this.domainConfiguration.toString())) {
            throw new TopologyException("JNDI Provider Url mismatch");
        }
        if (!StringHelper.equal((String)domainConfiguration.getJndiConfiguration().getJndiSecurityPrincipal(), (String)this.domainConfiguration.getJndiConfiguration().getJndiSecurityPrincipal())) {
            throw new TopologyException("JNDI Security Principal mismatch");
        }
        if (!StringHelper.equal((String)domainConfiguration.getJndiConfiguration().getJndiSecurityCredentials(), (String)this.domainConfiguration.getJndiConfiguration().getJndiSecurityCredentials())) {
            throw new TopologyException("JNDI Security Credentials mismatch");
        }
        if (domainConfiguration.getJndiConfiguration().getJndiPoolSize() != this.domainConfiguration.getJndiConfiguration().getJndiPoolSize()) {
            throw new TopologyException("JNDI Pool Size mismatch");
        }
        if (domainConfiguration.getJndiConfiguration().getJndiBatchSize() != this.domainConfiguration.getJndiConfiguration().getJndiBatchSize()) {
            throw new TopologyException("JNDI Batch Size mismatch");
        }
        this.log.debug((Object)"Domain configuration of the new Container is OK");
    }

    private void verifySubDomain(SubDomainConfiguration subDomainConfiguration) throws TopologyException {
        this.log.debug((Object)"Check the sub-domain configuration of the new Container...");
        if (DomainMode.STATIC.equals((Object)this.topology.getDomain().getMode())) {
            Subdomain subdomain = TopologyHelper.findSubdomain((String)subDomainConfiguration.getName(), (Topology)this.topology);
            if (subdomain == null) {
                throw new TopologyException("Subdomain of the Container unknown");
            }
            if (subdomain.isNetworkTimeSynchronized() == null ? subDomainConfiguration.isNetworkTimeSynchronized() : subdomain.isNetworkTimeSynchronized().booleanValue() != subDomainConfiguration.isNetworkTimeSynchronized()) {
                throw new TopologyException("Network synchronization mismatch");
            }
        } else if (subDomainConfiguration.getName().equals(this.subDomainConfiguration.getName()) && subDomainConfiguration.isNetworkTimeSynchronized() != this.subDomainConfiguration.isNetworkTimeSynchronized()) {
            throw new TopologyException("Network synchronization mismatch");
        }
        this.log.debug((Object)"Sub-domain configuration of the new Container is OK");
    }

    private class SubDomainAndContainerNames {
        protected String containerName;
        protected String subDomainName;

        private SubDomainAndContainerNames() {
        }
    }
}

