/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.configuration;

import java.io.Serializable;
import org.ow2.petals.topology.generated.SubdomainMode;

public class SubDomainConfiguration
implements Serializable {
    private static final long serialVersionUID = 6441320022067994394L;
    private String name;
    private String description;
    private SubdomainMode mode;
    private boolean networkTimeSynchronized;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SubdomainMode getMode() {
        return this.mode;
    }

    public boolean isNetworkTimeSynchronized() {
        return this.networkTimeSynchronized;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Sub-domain ").append(this.name);
        if (this.description != null) {
            stringBuilder.append("\n\t\t\tDescription :\n\t\t\t  ").append(this.description);
        }
        stringBuilder.append("\n\t\t\tConfiguration :\n\t\t\t  - Time-synchronized:" + String.valueOf(this.networkTimeSynchronized));
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof SubDomainConfiguration) {
            SubDomainConfiguration subDomainConfiguration = (SubDomainConfiguration)object;
            if (!subDomainConfiguration.name.equals(this.name) || subDomainConfiguration.networkTimeSynchronized != this.networkTimeSynchronized) {
                return false;
            }
            if (this.description == null && subDomainConfiguration.description != null) {
                return false;
            }
            return this.description.equals(subDomainConfiguration.description);
        }
        return false;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setMode(SubdomainMode subdomainMode) {
        this.mode = subdomainMode;
    }

    public void setNetworkTimeSynchronized(boolean bl) {
        this.networkTimeSynchronized = bl;
    }
}

