/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.server;

import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import com.ebmwebsourcing.easycommons.properties.PropertiesHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.LogManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.util.Fractal;
import org.ow2.petals.commons.log.Level;
import org.ow2.petals.commons.log.PetalsExecutionContext;
import org.ow2.petals.communication.jndi.client.JNDIService;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.recovery.SystemRecoveryService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.kernel.admin.PetalsAdminInterface;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.api.server.PetalsServer;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.server.FractalHelper;
import org.ow2.petals.kernel.server.MBeanHelper;
import org.ow2.petals.kernel.server.PetalsStopThread;
import org.ow2.petals.service.ServiceEndpointImpl;
import org.ow2.petals.tools.ws.WebServiceException;
import org.ow2.petals.tools.ws.WebServiceManager;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.util.JNDIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetalsServerImpl
implements PetalsServer {
    private PetalsServerImpl instance = this;
    private final PetalsStopThread petalsStopThread = new PetalsStopThread(this);
    private DomainConfiguration domainConfiguration;
    private ContainerConfiguration containerConfiguration;
    private Component petalsComposite;
    private ContentController petalsContentController;
    private EndpointRegistry registry;
    private static final String DEFAULT_LOGGER_FILENAME = "loggers.properties";

    public PetalsServerImpl() throws PetalsException {
        this(false);
    }

    public PetalsServerImpl(boolean bl) throws PetalsException {
    }

    public void init() throws PetalsException {
        System.setProperty("javax.management.builder.initial", "mx4j.server.MX4JMBeanServerBuilder");
        try {
            this.initializeLogging();
            this.initializePetalsComposite();
        }
        catch (Exception exception) {
            throw new PetalsException("Problem while initializing Petals", (Throwable)exception);
        }
    }

    public void start() throws PetalsException {
        try {
            this.startPetalsComposite();
            this.registerPetalsServer();
            MBeanHelper.registerMBeans(this.petalsComposite);
            this.startTools();
            this.recoverSystem();
            this.startupDone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.petalsComposite != null) {
                System.err.println("Problem while starting PEtALS, try to stop PEtALS cleanly...");
                try {
                    FractalHelper.stopComponent(this.petalsComposite);
                }
                catch (Throwable throwable) {
                    System.err.println("Failed to stop PEtALS cleanly");
                }
            }
            throw new PetalsException("Failed to start PEtALS", (Throwable)exception);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (PetalsServerImpl.this.instance != null) {
                        PetalsServerImpl.this.instance.stop();
                    }
                }
                catch (PetalsException petalsException) {
                    System.err.println("ERROR: " + petalsException.getMessage());
                }
            }
        });
        System.out.println("Server STARTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws PetalsException {
        Exception exception = null;
        try {
            this.stopPetalsComposite();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception == null) {
            System.out.println("Server STOPPED");
        } else {
            System.err.println("ERROR: " + exception.getMessage());
        }
        PetalsServerImpl petalsServerImpl = this;
        synchronized (petalsServerImpl) {
            this.instance = null;
            this.notifyAll();
        }
        if (exception != null) {
            if (exception instanceof PetalsException) {
                throw (PetalsException)((Object)exception);
            }
            throw new PetalsException((Throwable)exception);
        }
    }

    public String getContainerConfiguration() throws PetalsException {
        if (this.containerConfiguration == null) {
            throw new PetalsException("The container configuration is not properly set");
        }
        return this.containerConfiguration.toString();
    }

    public String browseJNDI() throws PetalsException {
        if (this.containerConfiguration == null) {
            throw new PetalsException("The container configuration is not properly set");
        }
        String string = null;
        Component component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "JNDIServiceImpl");
        try {
            JNDIService jNDIService = (JNDIService)component.getFcInterface("service");
            InitialContext initialContext = jNDIService.getInitialContext();
            if (this.domainConfiguration.getJndiConfiguration() == null) {
                string = JNDIUtil.browseJNDI(initialContext, null, 0);
            } else {
                URI uRI = this.domainConfiguration.getJndiConfiguration().getJndiProviderUrl();
                string = JNDIUtil.browseJNDI(initialContext, uRI.getHost(), uRI.getPort());
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException((Throwable)noSuchInterfaceException);
        }
        catch (NamingException namingException) {
            throw new PetalsException((Throwable)namingException);
        }
        return string;
    }

    public List<org.ow2.petals.kernel.api.service.ServiceEndpoint> getServiceEndpoints(boolean bl) throws PetalsException {
        ArrayList<org.ow2.petals.kernel.api.service.ServiceEndpoint> arrayList = new ArrayList<org.ow2.petals.kernel.api.service.ServiceEndpoint>();
        try {
            List<ServiceEndpoint> list = this.registry.getEndpoints();
            if (list != null) {
                for (org.ow2.petals.kernel.api.service.ServiceEndpoint serviceEndpoint : list) {
                    ServiceEndpointImpl serviceEndpointImpl = new ServiceEndpointImpl();
                    serviceEndpointImpl.setInterfacesName(serviceEndpoint.getInterfacesName());
                    serviceEndpointImpl.setEndpointName(serviceEndpoint.getEndpointName());
                    serviceEndpointImpl.setServiceName(serviceEndpoint.getServiceName());
                    serviceEndpointImpl.setDescription(serviceEndpoint.getDescription());
                    serviceEndpointImpl.setLocation(serviceEndpoint.getLocation());
                    arrayList.add(serviceEndpointImpl);
                }
            }
        }
        catch (RegistryException registryException) {
            throw new PetalsException("Can not get endpoints");
        }
        return arrayList;
    }

    private void initializePetalsComposite() throws PetalsException {
        try {
            this.petalsComposite = FractalHelper.createNewComponent("Petals");
            this.petalsContentController = Fractal.getContentController((Component)this.petalsComposite);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new PetalsException("Error creating PEtALS Fractal Composite", (Throwable)noSuchInterfaceException);
        }
        catch (ADLException aDLException) {
            throw new PetalsException("Error creating PEtALS Fractal Composite", (Throwable)aDLException);
        }
    }

    private void startPetalsComposite() throws ADLException, NoSuchInterfaceException, IllegalBindingException, IllegalContentException, IllegalLifeCycleException, PetalsException {
        BindingController bindingController;
        Component component;
        Component component2 = FractalHelper.getComponentByName(this.petalsContentController, "ConfigurationServiceImpl");
        if (!FractalHelper.startComponent(component2)) {
            throw new PetalsException("Failed to start PEtALS Fractal component ConfigurationServiceImpl");
        }
        ConfigurationService configurationService = (ConfigurationService)component2.getFcInterface("service");
        this.containerConfiguration = configurationService.getContainerConfiguration();
        PetalsExecutionContext.putContainerName((String)this.containerConfiguration.getName());
        this.domainConfiguration = configurationService.getDomainConfiguration();
        if (!this.containerConfiguration.isActivateAutoloader()) {
            component = FractalHelper.getComponentByName(this.petalsContentController, "AutoLoaderServiceImpl");
            bindingController = Fractal.getBindingController((Component)component);
            String[] stringArray = bindingController.listFc();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                bindingController.unbindFc(string);
                ++n2;
            }
            this.petalsContentController.removeFcSubComponent(component);
        }
        if (!FractalHelper.startComponent(component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "Communication"))) {
            throw new PetalsException("Failed to start PEtALS Fractal composite Communication");
        }
        if (!FractalHelper.startComponent(this.petalsComposite)) {
            throw new PetalsException("Failed to start PEtALS Fractal components");
        }
        bindingController = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "EndpointRegistryImpl");
        if (bindingController == null) {
            throw new PetalsException("Can not find the registry component EndpointRegistryImpl");
        }
        this.registry = (EndpointRegistry)bindingController.getFcInterface("service");
    }

    private void stopPetalsComposite() throws Exception {
        LifeCycleController lifeCycleController = Fractal.getLifeCycleController((Component)this.petalsComposite);
        if ("STARTED".equals(lifeCycleController.getFcState())) {
            Object object;
            Component component4;
            Component component22;
            Component component3 = FractalHelper.getComponentByName(this.petalsContentController, "Container");
            ContentController contentController = Fractal.getContentController((Component)component3);
            List<Component> list = FractalHelper.getComponentListByPrefix(contentController, "ServiceAssemblyLifeCycle.");
            Collections.reverse(list);
            for (Component component22 : list) {
                FractalHelper.stopComponent(component22);
            }
            component22 = FractalHelper.getComponentListByPrefix(contentController, "ComponentLifeCycle.");
            Collections.reverse(component22);
            for (Component component4 : component22) {
                FractalHelper.stopComponent(component4);
            }
            if (DomainConfiguration.DomainMode.STANDALONE.equals((Object)this.domainConfiguration.getMode())) {
                component4 = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "StandaloneTransporter");
                object = (Transporter)component4.getFcInterface("service");
                object.stopTraffic();
            } else {
                component4 = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "TcpTransporter");
                object = (Transporter)component4.getFcInterface("service");
                object.stopTraffic();
                Component component5 = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "LocalTransporter");
                Transporter transporter = (Transporter)component5.getFcInterface("service");
                transporter.stopTraffic();
            }
            component4 = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "RouterServiceImpl");
            object = (RouterService)component4.getFcInterface("service");
            object.stopTraffic();
            FractalHelper.stopComposite(this.petalsComposite);
        }
    }

    private void registerPetalsServer() throws NoSuchInterfaceException, PetalsException {
        Component component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "PetalsAdminServiceImpl");
        PetalsAdminInterface petalsAdminInterface = (PetalsAdminInterface)component.getFcInterface("service");
        petalsAdminInterface.setPetalsStopThread(this.petalsStopThread);
    }

    private void recoverSystem() throws ADLException, NoSuchInterfaceException, IllegalBindingException, IllegalContentException, IllegalLifeCycleException, ManagementException, PetalsException {
        Component component = FractalHelper.getComponentByName(this.petalsContentController, "JBI-Management");
        ContentController contentController = Fractal.getContentController((Component)component);
        Component component2 = FractalHelper.getComponentByName(contentController, "SystemRecoveryServiceImpl");
        SystemRecoveryService systemRecoveryService = (SystemRecoveryService)component2.getFcInterface("service");
        systemRecoveryService.recoverAllEntities();
        FractalHelper.stopComponent(component2);
        BindingController bindingController = Fractal.getBindingController((Component)component2);
        String[] stringArray = bindingController.listFc();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            bindingController.unbindFc(string);
            ++n2;
        }
        contentController.removeFcSubComponent(component2);
    }

    private void startupDone() throws Exception {
        Component component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "TopologyServiceImpl");
        if (component == null) {
            if (!DomainConfiguration.DomainMode.STANDALONE.equals((Object)this.domainConfiguration.getMode())) {
                throw new NullPointerException("The topology fractal component is null");
            }
        } else {
            TopologyService topologyService = (TopologyService)component.getFcInterface("service");
            topologyService.setContainerState(this.containerConfiguration.getName(), ContainerConfiguration.ContainerState.STARTED);
        }
        this.containerConfiguration.setState(ContainerConfiguration.ContainerState.STARTED);
    }

    private void startTools() throws NoSuchInterfaceException, PetalsException {
        Component component = FractalHelper.getRecursiveComponentByName(this.petalsContentController, "WebServiceManagerImpl");
        if (component != null) {
            WebServiceManager webServiceManager = (WebServiceManager)component.getFcInterface("service");
            try {
                webServiceManager.exposeServices();
            }
            catch (WebServiceException webServiceException) {
                throw new PetalsException("Fail to expose services : " + webServiceException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeLogging() throws PropertiesException, IOException {
        Level.initialize();
        String string = System.getProperty("java.util.logging.config.file");
        if (string != null) {
            LogManager.getLogManager().readConfiguration();
            return;
        }
        InputStream inputStream = null;
        try {
            try {
                URL uRL = this.getClass().getResource("/loggers.properties");
                if (uRL == null) {
                    throw new IOException("Failed to reach the resource [loggers.properties]");
                }
                File file = new File(uRL.toURI().normalize());
                inputStream = new FileInputStream(file);
                String string2 = System.getProperty("petals.home");
                assert (!StringHelper.isNullOrEmpty((String)string2));
                Properties properties = new Properties();
                properties.put("petals.home", string2);
                inputStream = PropertiesHelper.resolvePropertiesForInputStream((InputStream)inputStream, (Properties)properties);
                LogManager.getLogManager().readConfiguration(inputStream);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            IOHelper.close(inputStream);
            throw throwable;
        }
        {
            Object var7_10 = null;
            IOHelper.close((Closeable)inputStream);
            return;
        }
    }
}

