/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.ow2.petals.system.classloader.PetalsClassLoader;
import org.ow2.petals.system.classloader.SharedLibrariesClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentClassLoader
extends PetalsClassLoader {
    private SharedLibrariesClassLoader sharedLibrariesClassLoader;
    private List<String> sharedLibrariesNameList;

    public ComponentClassLoader(URL[] uRLArray, List<String> list, SharedLibrariesClassLoader sharedLibrariesClassLoader, List<String> list2) throws IOException {
        super(uRLArray, list, (ClassLoader)sharedLibrariesClassLoader);
        this.sharedLibrariesNameList = list2;
        this.sharedLibrariesClassLoader = sharedLibrariesClassLoader;
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        if (this.isParentFirst()) {
            uRL = this.sharedLibrariesClassLoader.getResource(string, this.sharedLibrariesNameList);
            if (uRL == null) {
                uRL = super.getResource(string);
            }
        } else {
            uRL = super.getResource(string);
            if (uRL == null) {
                uRL = this.sharedLibrariesClassLoader.getResource(string, this.sharedLibrariesNameList);
            }
        }
        return uRL;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.isParentFirst()) {
            inputStream = this.sharedLibrariesClassLoader.getResourceAsStream(string, this.sharedLibrariesNameList);
            if (inputStream == null) {
                inputStream = super.getResourceAsStream(string);
            }
        } else {
            inputStream = super.getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = this.sharedLibrariesClassLoader.getResourceAsStream(string, this.sharedLibrariesNameList);
            }
        }
        return inputStream;
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz == null) {
            if (this.useParentFirst(string, true)) {
                try {
                    clazz = this.sharedLibrariesClassLoader.loadClass(string, bl, this.sharedLibrariesNameList);
                }
                catch (Throwable throwable) {
                    clazz = this.findClass(string);
                }
            } else {
                try {
                    clazz = this.findClass(string);
                }
                catch (Throwable throwable) {
                    clazz = this.sharedLibrariesClassLoader.loadClass(string, bl, this.sharedLibrariesNameList);
                }
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

