/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.repository.artifact;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceAssembly;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.system.repository.artifact.Artifact;
import org.ow2.petals.system.repository.artifact.ArtifactRepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalArtifactRepositoryService
implements ArtifactRepositoryService {
    private static final String COMPONENTS = "components";
    private static final String SA = "sa";
    private static final String SL = "sl";
    private File rootPath;
    private File componentPath;
    private File slPath;
    private File saPath;

    public LocalArtifactRepositoryService(File file) {
        this.rootPath = file;
        if (!file.exists()) {
            file.mkdirs();
        }
        this.componentPath = new File(file, COMPONENTS);
        if (!this.componentPath.exists()) {
            this.componentPath.mkdirs();
        }
        this.slPath = new File(file, SL);
        if (!this.slPath.exists()) {
            this.slPath.mkdirs();
        }
        this.saPath = new File(file, SA);
        if (!this.saPath.exists()) {
            this.saPath.mkdirs();
        }
    }

    @Override
    public List<Artifact> getComponents() {
        File[] fileArray;
        Jbi jbi = null;
        ArrayList<Artifact> arrayList = null;
        ArrayList<File> arrayList2 = new ArrayList<File>();
        File[] fileArray2 = fileArray = this.componentPath.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            jbi = this.readDescriptor(file);
            if (jbi != null && jbi.getComponent() != null) {
                arrayList2.add(file);
            }
            ++n2;
        }
        arrayList = new ArrayList<Artifact>(arrayList2.size());
        for (File file : arrayList2) {
            Artifact artifact = new Artifact();
            artifact.setFile(file);
            artifact.setName(this.getComponentName(file));
            arrayList.add(artifact);
        }
        return arrayList;
    }

    @Override
    public List<Artifact> getServiceAssemblies() {
        File[] fileArray;
        Jbi jbi = null;
        ArrayList<Artifact> arrayList = null;
        ArrayList<File> arrayList2 = new ArrayList<File>();
        File[] fileArray2 = fileArray = this.saPath.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            jbi = this.readDescriptor(file);
            if (jbi != null && jbi.getServiceAssembly() != null) {
                arrayList2.add(file);
            }
            ++n2;
        }
        arrayList = new ArrayList<Artifact>(arrayList2.size());
        for (File file : arrayList2) {
            Artifact artifact = new Artifact();
            artifact.setFile(file);
            artifact.setName(this.getServiceAssemblyName(file));
            arrayList.add(artifact);
        }
        return arrayList;
    }

    @Override
    public List<String> getComponentsName() {
        List<Artifact> list = this.getComponents();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Artifact artifact : list) {
            arrayList.add(artifact.getName());
        }
        return arrayList;
    }

    @Override
    public File getComponentsPath() {
        return this.componentPath;
    }

    public File getSaPath() {
        return this.saPath;
    }

    @Override
    public File getRootPath() {
        return this.rootPath;
    }

    @Override
    public boolean addArtifact(Artifact artifact) throws PetalsException {
        boolean bl = true;
        if (artifact != null && artifact.getFile() != null && artifact.getFile().exists()) {
            File file = artifact.getFile();
            Jbi jbi = this.readDescriptor(file);
            try {
                File file2 = null;
                if (jbi != null && jbi.getComponent() != null) {
                    file2 = new File(this.componentPath, String.valueOf(jbi.getComponent().getIdentification().getName()) + ".zip");
                    FileUtils.copyFile((File)file, (File)file2);
                } else if (jbi != null && jbi.getServiceAssembly() != null) {
                    file2 = new File(this.saPath, String.valueOf(jbi.getServiceAssembly().getIdentification().getName()) + ".zip");
                    FileUtils.copyFile((File)file, (File)file2);
                } else if (jbi != null && jbi.getSharedLibrary() != null) {
                    file2 = new File(this.saPath, String.valueOf(jbi.getSharedLibrary().getIdentification().getName()) + ".zip");
                    FileUtils.copyFile((File)file, (File)file2);
                } else {
                    bl = false;
                }
            }
            catch (IOException iOException) {
                throw new PetalsException(iOException.getMessage());
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Jbi readDescriptor(File file) {
        Jbi jbi = null;
        InputStream inputStream = null;
        try {
            try {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry zipEntry = zipFile.getEntry("META-INF/jbi.xml");
                inputStream = zipFile.getInputStream(zipEntry);
                jbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)inputStream);
            }
            catch (JBIDescriptorException jBIDescriptorException) {
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return jbi;
        }
        if (inputStream == null) return jbi;
        inputStream.close();
        return jbi;
    }

    protected String getComponentName(File file) {
        Component component;
        String string = null;
        Jbi jbi = this.readDescriptor(file);
        if (jbi != null && (component = jbi.getComponent()) != null) {
            string = component.getIdentification().getName();
        }
        return string;
    }

    protected String getSharedLibraryName(File file) {
        Jbi.SharedLibrary sharedLibrary;
        String string = null;
        Jbi jbi = this.readDescriptor(file);
        if (jbi != null && (sharedLibrary = jbi.getSharedLibrary()) != null) {
            string = sharedLibrary.getIdentification().getName();
        }
        return string;
    }

    protected String getServiceAssemblyName(File file) {
        ServiceAssembly serviceAssembly;
        String string = null;
        Jbi jbi = this.readDescriptor(file);
        if (jbi != null && (serviceAssembly = jbi.getServiceAssembly()) != null) {
            string = serviceAssembly.getIdentification().getName();
        }
        return string;
    }

    @Override
    public List<String> getServiceAssembliesName() {
        List<Artifact> list = this.getServiceAssemblies();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Artifact artifact : list) {
            arrayList.add(artifact.getName());
        }
        return arrayList;
    }

    @Override
    public File getServiceAssemblyPath() {
        return this.saPath;
    }

    @Override
    public List<String> getSharedLibrariesName() {
        List<Artifact> list = this.getSharedLibraries();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Artifact artifact : list) {
            arrayList.add(artifact.getName());
        }
        return arrayList;
    }

    @Override
    public File getSharedLibraryPath() {
        return this.slPath;
    }

    @Override
    public List<Artifact> getSharedLibraries() {
        File[] fileArray;
        Jbi jbi = null;
        ArrayList<Artifact> arrayList = null;
        ArrayList<File> arrayList2 = new ArrayList<File>();
        File[] fileArray2 = fileArray = this.slPath.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            jbi = this.readDescriptor(file);
            if (jbi != null && jbi.getSharedLibrary() != null) {
                arrayList2.add(file);
            }
            ++n2;
        }
        arrayList = new ArrayList<Artifact>(arrayList2.size());
        for (File file : arrayList2) {
            Artifact artifact = new Artifact();
            artifact.setFile(file);
            artifact.setName(this.getSharedLibraryName(file));
            arrayList.add(artifact);
        }
        return arrayList;
    }
}

