/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.exchange.PersistedMessageExchangeWrapper;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.transport.TransportException;
import org.ow2.petals.transport.TransportListener;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.transport.platform.nio.client.NioClientObjectPool;
import org.ow2.petals.transport.platform.nio.selector.NioClient;
import org.ow2.petals.transport.platform.nio.server.NioReceiver;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.transport.util.TransporterUtil;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=Transporter.class), @Interface(name="receiver", signature=NioReceiver.class)})
public class NioTransporterImpl
implements BindingController,
LifeCycleController,
Transporter,
NioReceiver {
    @Requires(name="transportlistener", signature=TransportListener.class)
    private TransportListener transportListener;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="clientsPool", signature=NioClientObjectPool.class)
    private NioClientObjectPool clientConnections;
    private boolean stopTraffic;
    private Map<String, MessageExchangeWrapper> pendingSyncExchanges;
    private LoggingUtil log;
    private long sendTimeout;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object object) {
        this.log.start();
        if (object instanceof MessageExchangeImpl) {
            MessageExchangeImpl messageExchangeImpl = (MessageExchangeImpl)object;
            PersistedMessageExchangeWrapper persistedMessageExchangeWrapper = new PersistedMessageExchangeWrapper(messageExchangeImpl, null);
            if (TransporterUtil.getSyncMode(persistedMessageExchangeWrapper, true)) {
                MessageExchangeWrapper messageExchangeWrapper;
                this.log.debug((Object)("The message " + messageExchangeImpl.getExchangeId() + " is a synchronized response"));
                TransporterUtil.updateSyncProperties(persistedMessageExchangeWrapper);
                MessageExchangeWrapper messageExchangeWrapper2 = messageExchangeWrapper = this.pendingSyncExchanges.put(messageExchangeImpl.getExchangeId(), persistedMessageExchangeWrapper);
                synchronized (messageExchangeWrapper2) {
                    messageExchangeWrapper.notify();
                }
            } else {
                this.log.debug((Object)("The message " + persistedMessageExchangeWrapper.getExchangeId() + " is not a synchronized response"));
                this.transportListener.onExchange(persistedMessageExchangeWrapper);
            }
        } else {
            this.log.warning((Object)"Unexpected received data. Data are discarded");
        }
        this.log.end();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(MessageExchangeWrapper messageExchangeWrapper, TransportSendContext transportSendContext) throws TransportException {
        this.log.start((Object)("Send exchange to destination '" + transportSendContext.destination + "'"));
        this.checkTransporterState();
        try {
            NioClient nioClient = this.clientConnections.borrowObject(transportSendContext.destination.getContainerName());
            try {
                nioClient.send(messageExchangeWrapper.getMessageExchange(), this.sendTimeout);
                this.transportListener.exchangeSent(messageExchangeWrapper);
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.clientConnections.returnObject(transportSendContext.destination.getContainerName(), nioClient);
                throw throwable;
            }
            {
                Object var4_9 = null;
                this.clientConnections.returnObject(transportSendContext.destination.getContainerName(), nioClient);
            }
        }
        catch (IOException iOException) {
            throw new TransportException(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new TransportException(interruptedException);
        }
        catch (Exception exception) {
            throw new TransportException(exception);
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSync(MessageExchangeWrapper messageExchangeWrapper, TransportSendContext transportSendContext) throws TransportException {
        MessageExchangeWrapper messageExchangeWrapper2;
        this.log.start((Object)("Send synchronous exchange to destination : " + transportSendContext.destination));
        this.checkTransporterState();
        try {
            TransporterUtil.setSendSyncProperties(messageExchangeWrapper);
        }
        catch (MessagingException messagingException) {
            throw new TransportException(messagingException);
        }
        this.pendingSyncExchanges.put(messageExchangeWrapper.getExchangeId(), messageExchangeWrapper);
        try {
            MessageExchangeWrapper messageExchangeWrapper3 = messageExchangeWrapper;
            synchronized (messageExchangeWrapper3) {
                this.send(messageExchangeWrapper, transportSendContext);
                messageExchangeWrapper.wait(transportSendContext.timeout);
            }
            messageExchangeWrapper2 = this.pendingSyncExchanges.remove(messageExchangeWrapper.getExchangeId());
        }
        catch (InterruptedException interruptedException) {
            TransporterUtil.updateSyncProperties(messageExchangeWrapper);
            this.pendingSyncExchanges.remove(messageExchangeWrapper.getExchangeId());
            throw new TransportException("Failed to receive the response message of a synchronous send", interruptedException);
        }
        if (messageExchangeWrapper2 == messageExchangeWrapper) {
            this.checkTransporterState();
            messageExchangeWrapper.setTimeout(true);
            this.log.warning((Object)("Failed to send synchronously the exchange: " + messageExchangeWrapper.getExchangeId() + ". Timeout occured"));
            this.log.end();
        } else {
            try {
                messageExchangeWrapper.setMessageExchange(messageExchangeWrapper2.getMessageExchange());
            }
            catch (MessagingException messagingException) {
                throw new TransportException(messagingException);
            }
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTraffic() {
        this.log.start();
        this.stopTraffic = true;
        boolean bl = true;
        while (bl) {
            try {
                Iterator<MessageExchangeWrapper> iterator = this.pendingSyncExchanges.values().iterator();
                while (iterator.hasNext()) {
                    MessageExchange messageExchange;
                    MessageExchange messageExchange2 = messageExchange = (MessageExchange)iterator.next();
                    synchronized (messageExchange2) {
                        messageExchange.notify();
                    }
                }
                bl = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    public void start() throws NoSuchInterfaceException, IllegalLifeCycleException {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Transporter.NioTransporter"));
        this.log.start();
        this.sendTimeout = this.configurationService.getContainerConfiguration().getTCPSendTimeout();
        this.pendingSyncExchanges = new ConcurrentHashMap<String, MessageExchangeWrapper>(100);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() throws Exception {
        this.log.call();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("transportlistener")) {
            if (!TransportListener.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TransportListener.class.getName());
            }
            this.transportListener = (TransportListener)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("clientsPool")) {
            if (!NioClientObjectPool.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NioClientObjectPool.class.getName());
            }
            this.clientConnections = (NioClientObjectPool)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private void checkTransporterState() throws TransportException {
        if (this.stopTraffic) {
            Thread.currentThread().interrupt();
            throw new TransportException("The Transporter traffic is stopped", new InterruptedException());
        }
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("transportlistener");
        arrayList.add("configuration");
        arrayList.add("clientsPool");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("transportlistener")) {
            return this.transportListener;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("clientsPool")) {
            return this.clientConnections;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("transportlistener")) {
            this.transportListener = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("clientsPool")) {
            this.clientConnections = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

