/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.jbi.management.deployment.AtomicDeploymentService;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.ws.api.DeploymentService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.system.repository.artifact.Artifact;
import org.ow2.petals.system.repository.artifact.ArtifactRepositoryService;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="webservice", signature=DeploymentService.class), @Interface(name="service", signature=KernelWebService.class)})
public class DeploymentServiceImpl
implements BindingController,
LifeCycleController,
DeploymentService,
KernelWebService {
    private Component component;
    @Requires(name="deployment", signature=AtomicDeploymentService.class)
    private AtomicDeploymentService deploymentService;
    @Requires(name="artifactrepository", signature=ArtifactRepositoryService.class)
    private ArtifactRepositoryService artifactRepositoryService;
    private LoggingUtil log;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.WS.DeploymentService"));
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public boolean deploy(String string) throws PEtALSWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : deploy with params saId = " + string));
        }
        boolean bl = true;
        List<Artifact> list = this.artifactRepositoryService.getServiceAssemblies();
        Iterator<Artifact> iterator = list.iterator();
        boolean bl2 = false;
        Artifact artifact = null;
        while (iterator.hasNext() && !bl2) {
            Artifact artifact2 = iterator.next();
            if (artifact2.getName() == null || !artifact2.getName().equals(string)) continue;
            artifact = artifact2;
            bl2 = true;
        }
        if (artifact == null) {
            throw new PEtALSWebServiceException("Can not find artifact " + string + " in the repository");
        }
        try {
            bl = this.deploymentService.deploy(artifact.getFile().toURL());
        }
        catch (Exception exception) {
            String string2 = "Can not deploy the SA with ID " + string;
            this.log.warning((Object)string2, (Throwable)exception);
            throw new PEtALSWebServiceException(String.valueOf(string2) + "(" + exception.getMessage() + ")");
        }
        return bl;
    }

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean shutdown(String string) throws PEtALSWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : shutdown with params saId = " + string));
        }
        boolean bl = true;
        try {
            bl = this.deploymentService.shutdown(string);
        }
        catch (PetalsException petalsException) {
            String string2 = "Can not shutdown the SA with ID " + string;
            this.log.warning((Object)string2, (Throwable)petalsException);
            throw new PEtALSWebServiceException(String.valueOf(string2) + "(" + petalsException.getMessage() + ")");
        }
        return bl;
    }

    public boolean start(String string) throws PEtALSWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : start with params saId = " + string));
        }
        boolean bl = true;
        try {
            bl = this.deploymentService.start(string);
        }
        catch (PetalsException petalsException) {
            String string2 = "Can not start the SA with ID " + string;
            this.log.warning((Object)string2, (Throwable)petalsException);
            throw new PEtALSWebServiceException(String.valueOf(string2) + "(" + petalsException.getMessage() + ")");
        }
        return bl;
    }

    public boolean stop(String string) throws PEtALSWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : stop with params saId = " + string));
        }
        boolean bl = true;
        try {
            bl = this.deploymentService.stop(string);
        }
        catch (PetalsException petalsException) {
            String string2 = "Can not stop the SA with ID " + string;
            this.log.warning((Object)string2, (Throwable)petalsException);
            throw new PEtALSWebServiceException(String.valueOf(string2) + "(" + petalsException.getMessage() + ")");
        }
        return bl;
    }

    public boolean undeploy(String string) throws PEtALSWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : undeploy with params saId = " + string));
        }
        boolean bl = true;
        try {
            bl = this.deploymentService.undeploy(string);
        }
        catch (PetalsException petalsException) {
            String string2 = "Can not undeploy the SA with ID " + string;
            this.log.warning((Object)string2, (Throwable)petalsException);
            throw new PEtALSWebServiceException(String.valueOf(string2) + "(" + petalsException.getMessage() + ")");
        }
        return bl;
    }

    public Component getComponent() {
        return this.component;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("deployment")) {
            if (!AtomicDeploymentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AtomicDeploymentService.class.getName());
            }
            this.deploymentService = (AtomicDeploymentService)object;
            return;
        }
        if (string.equals("artifactrepository")) {
            if (!ArtifactRepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ArtifactRepositoryService.class.getName());
            }
            this.artifactRepositoryService = (ArtifactRepositoryService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("deployment");
        arrayList.add("artifactrepository");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("deployment")) {
            return this.deploymentService;
        }
        if (string.equals("artifactrepository")) {
            return this.artifactRepositoryService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("deployment")) {
            this.deploymentService = null;
            return;
        }
        if (string.equals("artifactrepository")) {
            this.artifactRepositoryService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

