/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jbi.management.ComponentLifeCycleMBean;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.container.lifecycle.SharedLibraryLifeCycle;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.kernel.ws.api.JBIArtefactsService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.to.Component;
import org.ow2.petals.kernel.ws.api.to.ServiceAssembly;
import org.ow2.petals.kernel.ws.api.to.SharedLib;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="webservice", signature=JBIArtefactsService.class), @Interface(name="service", signature=KernelWebService.class)})
public class JBIArtefactsServiceImpl
implements BindingController,
LifeCycleController,
JBIArtefactsService,
KernelWebService {
    private LoggingUtil log;
    private org.objectweb.fractal.api.Component component;
    @Requires(name="adminService", signature=AdminService.class)
    private AdminService adminService;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.WS.JBIArtefactsService"));
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    @Override
    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    public String getFcState() {
        return null;
    }

    public List<ServiceAssembly> getServiceAssemblies() throws PEtALSWebServiceException {
        ArrayList<ServiceAssembly> arrayList = new ArrayList<ServiceAssembly>();
        Map<String, ServiceAssemblyLifeCycle> map = this.adminService.getServiceAssemblies();
        if (map != null) {
            for (String string : map.keySet()) {
                ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = map.get(string);
                ServiceAssembly serviceAssembly = new ServiceAssembly();
                serviceAssembly.setState(serviceAssemblyLifeCycle.getCurrentState());
                serviceAssembly.setName(string);
                if (serviceAssemblyLifeCycle.getServiceAssembly().getIdentification() != null) {
                    serviceAssembly.setDescription(serviceAssemblyLifeCycle.getServiceAssembly().getIdentification().getDescription());
                }
                arrayList.add(serviceAssembly);
            }
        }
        return arrayList;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public List<Component> getComponents() throws PEtALSWebServiceException {
        Component component;
        ComponentLifeCycleMBean componentLifeCycleMBean;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Map<String, ComponentLifeCycleMBean> map = this.adminService.getBindingComponentsLifeCycles();
        if (map != null) {
            for (String string : map.keySet()) {
                componentLifeCycleMBean = map.get(string);
                component = new Component();
                component.setState(componentLifeCycleMBean.getCurrentState());
                component.setName(string);
                component.setType("binding");
                arrayList.add(component);
            }
        }
        if ((map = this.adminService.getServiceEnginesLifeCycles()) != null) {
            for (String string : map.keySet()) {
                componentLifeCycleMBean = map.get(string);
                component = new Component();
                component.setState(componentLifeCycleMBean.getCurrentState());
                component.setName(string);
                component.setType("engine");
                arrayList.add(component);
            }
        }
        return arrayList;
    }

    public List<SharedLib> getSharedLibraries() throws PEtALSWebServiceException {
        ArrayList<SharedLib> arrayList = new ArrayList<SharedLib>();
        Map<String, SharedLibraryLifeCycle> map = this.adminService.getSharedLibraries();
        if (map != null) {
            for (String string : map.keySet()) {
                SharedLibraryLifeCycle sharedLibraryLifeCycle = map.get(string);
                SharedLib sharedLib = new SharedLib();
                sharedLib.setState(sharedLibraryLifeCycle.getState());
                sharedLib.setName(string);
                arrayList.add(sharedLib);
            }
        }
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)object;
            return;
        }
        if (string.equals("adminService")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("adminService");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("adminService")) {
            return this.adminService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("adminService")) {
            this.adminService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

