/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.configuration.JndiConfiguration;
import org.ow2.petals.kernel.configuration.SubDomainConfiguration;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.TopologyService;
import org.ow2.petals.kernel.ws.api.to.ContainerInformation;
import org.ow2.petals.kernel.ws.api.to.DomainInformation;
import org.ow2.petals.kernel.ws.api.to.JmxServiceInformation;
import org.ow2.petals.kernel.ws.api.to.JndiInformation;
import org.ow2.petals.kernel.ws.api.to.RegistryServiceInformation;
import org.ow2.petals.kernel.ws.api.to.SubdomainInformation;
import org.ow2.petals.kernel.ws.api.to.TransportServiceInformation;
import org.ow2.petals.kernel.ws.api.to.WebServiceServiceInformation;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.topology.generated.SubdomainMode;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.ws.adapters.TopologyConfigurationToTopologyInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="webservice", signature=TopologyService.class), @Interface(name="service", signature=KernelWebService.class)})
public class TopologyServiceImpl
implements BindingController,
LifeCycleController,
TopologyService,
KernelWebService {
    private LoggingUtil log;
    private Component component;
    @Requires(name="topology", signature=org.ow2.petals.communication.topology.TopologyService.class)
    private org.ow2.petals.communication.topology.TopologyService topologyService;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.WS.TopologyService"));
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public String getFcState() {
        return null;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public JndiInformation getJndiInformation() throws PEtALSWebServiceException {
        JndiInformation jndiInformation = null;
        DomainConfiguration domainConfiguration = this.topologyService.getDomainConfiguration();
        if (domainConfiguration == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can't retrieve the domain configuration.");
            throw new PEtALSWebServiceException(stringBuilder.toString());
        }
        JndiConfiguration jndiConfiguration = domainConfiguration.getJndiConfiguration();
        if (jndiConfiguration == null) {
            return jndiInformation;
        }
        if (StringHelper.isNullOrEmpty((String)jndiConfiguration.getJndiFactory())) {
            return jndiInformation;
        }
        if (jndiConfiguration.getJndiProviderUrl() == null || StringHelper.isNullOrEmpty((String)jndiConfiguration.getJndiProviderUrl().toASCIIString())) {
            return jndiInformation;
        }
        jndiInformation = new JndiInformation();
        jndiInformation.setProviderUrl(jndiConfiguration.getJndiProviderUrl().toString());
        jndiInformation.setFactory(jndiConfiguration.getJndiFactory());
        if (!StringHelper.isNullOrEmpty((String)jndiConfiguration.getJndiSecurityPrincipal())) {
            jndiInformation.setSecurityPrincipal(jndiConfiguration.getJndiSecurityPrincipal());
        }
        if (!StringHelper.isNullOrEmpty((String)jndiConfiguration.getJndiSecurityCredentials())) {
            jndiInformation.setSecurityPrincipal(jndiConfiguration.getJndiSecurityCredentials());
        }
        jndiInformation.setBatchSize(domainConfiguration.getJndiConfiguration().getJndiBatchSize());
        jndiInformation.setPoolSize(domainConfiguration.getJndiConfiguration().getJndiPoolSize());
        return jndiInformation;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void addContainerInformation(ContainerInformation containerInformation, String string) throws PEtALSWebServiceException {
        this.addContainerInformation(containerInformation, string, true);
    }

    private void addContainerInformation(ContainerInformation containerInformation, String string, boolean bl) throws PEtALSWebServiceException {
        ContainerConfiguration containerConfiguration = null;
        if (!this.topologyService.hasValidLocalContainerDynamicTopologyConfiguration()) {
            throw new PEtALSWebServiceException("No dynamic configuration found on the target container");
        }
        if (containerInformation == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Can't add a null container to the topology");
            throw new PEtALSWebServiceException(stringBuilder.toString());
        }
        try {
            boolean bl2 = false;
            Set<SubDomainConfiguration> set = this.topologyService.getSubDomainsConfiguration();
            for (SubDomainConfiguration serializable2 : set) {
                if (!serializable2.getName().equals(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("You must register a new subdomain with name : " + string);
                throw new PEtALSWebServiceException(stringBuilder.toString());
            }
            containerConfiguration = new ContainerConfiguration();
            containerConfiguration.setHost(containerInformation.getHost());
            containerConfiguration.setName(containerInformation.getName());
            containerConfiguration.setDescription(containerInformation.getDescription());
            containerConfiguration.setUser(containerInformation.getUser());
            containerConfiguration.setPassword(containerInformation.getPassword());
            containerConfiguration.setSubdomainName(string);
            RegistryServiceInformation registryServiceInformation = containerInformation.getRegistryService();
            if (registryServiceInformation == null) {
                throw new PEtALSWebServiceException("Can't find remote container registry configuration");
            }
            containerConfiguration.setRegistryPort(registryServiceInformation.getPort());
            JmxServiceInformation jmxServiceInformation = containerInformation.getJmxService();
            if (jmxServiceInformation == null) {
                throw new PEtALSWebServiceException("Can't find remote container JMX configuration");
            }
            containerConfiguration.setJmxRMIConnectorPort(jmxServiceInformation.getRmiPort());
            TransportServiceInformation transportServiceInformation = containerInformation.getTransportService();
            if (transportServiceInformation == null) {
                throw new PEtALSWebServiceException("Can't find remote container transporter configuration");
            }
            containerConfiguration.setTCPPort(transportServiceInformation.getTcpPort());
            WebServiceServiceInformation webServiceServiceInformation = containerInformation.getWebserviceService();
            if (webServiceServiceInformation == null) {
                throw new PEtALSWebServiceException("Can't find remote container webservice service configuration");
            }
            containerConfiguration.setWebservicePort(webServiceServiceInformation.getPort());
            containerConfiguration.setWebservicePrefix(webServiceServiceInformation.getPrefix());
            switch (containerInformation.getNodeType()) {
                case STANDALONE: {
                    containerConfiguration.setRegistryMode(ContainerConfiguration.RegistryMode.STANDALONE);
                    break;
                }
                case MASTER: {
                    containerConfiguration.setRegistryMode(ContainerConfiguration.RegistryMode.MASTER);
                    break;
                }
                case SLAVE: {
                    containerConfiguration.setRegistryMode(ContainerConfiguration.RegistryMode.SLAVE);
                    break;
                }
                case PEER: {
                    containerConfiguration.setRegistryMode(ContainerConfiguration.RegistryMode.PEER);
                    break;
                }
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Try to add a node with an invalid node type");
                    throw new PEtALSWebServiceException(stringBuilder.toString());
                }
            }
            this.topologyService.addContainerConfiguration(containerConfiguration);
        }
        catch (PetalsException petalsException) {
            throw new PEtALSWebServiceException((Throwable)petalsException);
        }
    }

    public void removeContainerInformation(String string) throws PEtALSWebServiceException {
        if (!this.topologyService.hasValidLocalContainerDynamicTopologyConfiguration()) {
            throw new PEtALSWebServiceException("No dynamic configuration found on the target container");
        }
        try {
            ContainerConfiguration containerConfiguration = new ContainerConfiguration();
            containerConfiguration.setName(string);
            this.topologyService.removeContainerConfiguration(containerConfiguration);
        }
        catch (PetalsException petalsException) {
            throw new PEtALSWebServiceException((Throwable)petalsException);
        }
    }

    public List<ContainerInformation> getAllContainerInformation() throws PEtALSWebServiceException {
        Set<ContainerConfiguration> set = this.topologyService.getContainersConfiguration(null);
        ArrayList<ContainerInformation> arrayList = new ArrayList<ContainerInformation>();
        for (ContainerConfiguration containerConfiguration : set) {
            try {
                arrayList.add(TopologyConfigurationToTopologyInformation.containerConfigurationToContainerInformation(containerConfiguration));
            }
            catch (PetalsException petalsException) {
                throw new PEtALSWebServiceException("Can't transform ContainerConfiguration to ContainerInformation");
            }
        }
        return arrayList;
    }

    public List<ContainerInformation> getMasterContainerInformation() throws PEtALSWebServiceException {
        Set<ContainerConfiguration> set = this.topologyService.getContainersConfiguration(null);
        ArrayList<ContainerInformation> arrayList = new ArrayList<ContainerInformation>();
        for (ContainerConfiguration containerConfiguration : set) {
            try {
                if (!containerConfiguration.isMaster()) continue;
                arrayList.add(TopologyConfigurationToTopologyInformation.containerConfigurationToContainerInformation(containerConfiguration));
            }
            catch (PetalsException petalsException) {
                throw new PEtALSWebServiceException("Can't transform ContainerConfiguration to ContainerInformation");
            }
        }
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("topology")) {
            if (!org.ow2.petals.communication.topology.TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + org.ow2.petals.communication.topology.TopologyService.class.getName());
            }
            this.topologyService = (org.ow2.petals.communication.topology.TopologyService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public List<ContainerInformation> getAllSlaveContainerInformationForLocalSubdomain() throws PEtALSWebServiceException {
        Set<ContainerConfiguration> set = this.topologyService.getContainersConfiguration(null);
        ArrayList<ContainerInformation> arrayList = new ArrayList<ContainerInformation>();
        for (ContainerConfiguration containerConfiguration : set) {
            try {
                if (!containerConfiguration.isSlave()) continue;
                arrayList.add(TopologyConfigurationToTopologyInformation.containerConfigurationToContainerInformation(containerConfiguration));
            }
            catch (PetalsException petalsException) {
                throw new PEtALSWebServiceException("Can't transform ContainerConfiguration to ContainerInformation");
            }
        }
        return arrayList;
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("topology");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("topology")) {
            return this.topologyService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public List<ContainerInformation> getAllPeerContainerInformationForLocalSubdomain() throws PEtALSWebServiceException {
        Set<ContainerConfiguration> set = this.topologyService.getContainersConfiguration(null);
        ArrayList<ContainerInformation> arrayList = new ArrayList<ContainerInformation>();
        for (ContainerConfiguration containerConfiguration : set) {
            try {
                if (!containerConfiguration.isPeer()) continue;
                arrayList.add(TopologyConfigurationToTopologyInformation.containerConfigurationToContainerInformation(containerConfiguration));
            }
            catch (PetalsException petalsException) {
                throw new PEtALSWebServiceException("Can't transform ContainerConfiguration to ContainerInformation");
            }
        }
        return arrayList;
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public ContainerInformation getContainerInformation(String string) throws PEtALSWebServiceException {
        ContainerInformation containerInformation = null;
        ContainerConfiguration containerConfiguration = this.topologyService.getContainerConfiguration(string);
        if (containerConfiguration == null) {
            throw new PEtALSWebServiceException("This is not a valid container name (" + string + " not found in topology)");
        }
        try {
            containerInformation = TopologyConfigurationToTopologyInformation.containerConfigurationToContainerInformation(containerConfiguration);
        }
        catch (PetalsException petalsException) {
            throw new PEtALSWebServiceException("Can't transform ContainerConfiguration to ContainerInformation : ", (Throwable)petalsException);
        }
        return containerInformation;
    }

    public void addSubdomain(String string, String string2, SubdomainInformation.SubdomainMode subdomainMode, boolean bl) throws PEtALSWebServiceException {
        SubDomainConfiguration subDomainConfiguration = new SubDomainConfiguration();
        subDomainConfiguration.setName(string);
        subDomainConfiguration.setDescription(string2);
        subDomainConfiguration.setNetworkTimeSynchronized(bl);
        if (!this.topologyService.hasValidLocalContainerDynamicTopologyConfiguration()) {
            throw new PEtALSWebServiceException("No dynamic configuration found on the target container");
        }
        switch (subdomainMode) {
            case FLOODING: {
                subDomainConfiguration.setMode(SubdomainMode.FLOODING);
                break;
            }
            case MASTERSLAVE: {
                subDomainConfiguration.setMode(SubdomainMode.MASTER_SLAVE);
                break;
            }
            case STANDALONE: {
                subDomainConfiguration.setMode(SubdomainMode.STANDALONE);
                break;
            }
            default: {
                throw new PEtALSWebServiceException("Unsupported subdomain mode");
            }
        }
        try {
            this.topologyService.addSubdomainConfiguration(subDomainConfiguration);
        }
        catch (PetalsException petalsException) {
            throw new PEtALSWebServiceException((Throwable)petalsException);
        }
    }

    public void removeSubdomain(String string) throws PEtALSWebServiceException {
        if (!this.topologyService.hasValidLocalContainerDynamicTopologyConfiguration()) {
            throw new PEtALSWebServiceException("No dynamic configuration found on the target container");
        }
        try {
            this.topologyService.removeSubdomainConfiguration(string);
        }
        catch (PetalsException petalsException) {
            throw new PEtALSWebServiceException(petalsException.getMessage(), (Throwable)petalsException);
        }
    }

    public void addSubdomainWithContainers(SubdomainInformation subdomainInformation) throws PEtALSWebServiceException {
        if (subdomainInformation == null) {
            throw new PEtALSWebServiceException("No subdomain found");
        }
        if (!this.topologyService.hasValidLocalContainerDynamicTopologyConfiguration()) {
            throw new PEtALSWebServiceException("No dynamic configuration found on the target container");
        }
        String string = subdomainInformation.getName();
        String string2 = subdomainInformation.getDescription();
        boolean bl = subdomainInformation.isNetworkTimeSynchronized();
        SubdomainInformation.SubdomainMode subdomainMode = subdomainInformation.getSubdomainMode();
        this.addSubdomain(string, string2, subdomainMode, bl);
        List list = subdomainInformation.getContainers();
        for (ContainerInformation containerInformation : list) {
            this.addContainerInformation(containerInformation, string, false);
        }
    }

    public SubdomainInformation getSubdomainByName(String string) throws PEtALSWebServiceException {
        SubDomainConfiguration object = null;
        SubdomainInformation subdomainInformation = null;
        if (string == null) {
            throw new PEtALSWebServiceException("No subdomain name found");
        }
        try {
            Set<SubDomainConfiguration> set = this.topologyService.getSubDomainsConfiguration();
            if (set != null) {
                for (SubDomainConfiguration object22 : set) {
                    if (!object22.getName().equals(string)) continue;
                    object = object22;
                    break;
                }
            }
            if (object == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Can't retrieve subdomain for name " + string);
            }
            subdomainInformation = TopologyConfigurationToTopologyInformation.subDomainConfigurationToSubdomainInformation(object);
            Set<ContainerConfiguration> set2 = this.topologyService.getContainersConfigurationsForLocalSubdomain();
            ArrayList arrayList = new ArrayList();
            for (ContainerConfiguration containerConfiguration : set2) {
                arrayList.add(TopologyConfigurationToTopologyInformation.containerConfigurationToContainerInformation(containerConfiguration));
            }
            subdomainInformation.setContainers((List)arrayList);
        }
        catch (PetalsException petalsException) {
            throw new PEtALSWebServiceException((Throwable)petalsException);
        }
        return subdomainInformation;
    }

    public DomainInformation getDomainInformation() throws PEtALSWebServiceException {
        DomainInformation domainInformation = new DomainInformation();
        try {
            domainInformation.setName(this.topologyService.getDomainConfiguration().getName());
            domainInformation.setDescription(this.topologyService.getDomainConfiguration().getDescription());
            domainInformation.setJndiInformation(this.getJndiInformation());
            domainInformation.setMode(this.domainModeTransformer(this.topologyService.getDomainConfiguration().getMode()));
            ArrayList<SubdomainInformation> arrayList = new ArrayList<SubdomainInformation>();
            for (SubDomainConfiguration subDomainConfiguration : this.topologyService.getSubDomainsConfiguration()) {
                SubdomainInformation subdomainInformation = TopologyConfigurationToTopologyInformation.subDomainConfigurationToSubdomainInformation(subDomainConfiguration);
                arrayList.add(subdomainInformation);
            }
            domainInformation.setSubdomains(arrayList);
        }
        catch (PetalsException petalsException) {
            throw new PEtALSWebServiceException((Throwable)petalsException);
        }
        return domainInformation;
    }

    private DomainInformation.DomainMode domainModeTransformer(DomainConfiguration.DomainMode domainMode) throws PetalsException {
        switch (domainMode) {
            case STATIC: {
                return DomainInformation.DomainMode.STATIC;
            }
            case STANDALONE: {
                return DomainInformation.DomainMode.STANDALONE;
            }
        }
        throw new PetalsException("Invalid domain mode");
    }
}

