/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import spoon.processing.Builder;
import spoon.processing.FileGenerator;
import spoon.processing.Severity;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtElement;
import spoon.support.DefaultCoreFactory;
import spoon.support.JavaOutputProcessor;
import spoon.support.QueueProcessingManager;
import spoon.support.StandardEnvironment;
import spoon.support.builder.CtFile;
import spoon.support.builder.CtResource;
import spoon.support.builder.FileFactory;
import spoon.support.builder.support.CtFolderZip;
import spoon.support.processing.SpoonletXmlHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLauncher {
    private String[] args = new String[0];
    private JSAPResult arguments;
    private Factory factory;
    private List<CtResource> inputResources = new ArrayList<CtResource>();
    protected JSAP jsapArgs;
    private List<String> processors = new ArrayList<String>();
    private List<CtResource> templateResources = new ArrayList<CtResource>();

    protected AbstractLauncher() throws JSAPException {
        this.jsapArgs = this.defineArgs();
    }

    protected AbstractLauncher(String[] args) throws JSAPException {
        this();
        this.args = args;
    }

    public void addInputResource(CtResource resource) {
        this.inputResources.add(resource);
    }

    public void addProcessor(String name) {
        this.processors.add(name);
    }

    public void addTemplateResource(CtResource resource) {
        this.templateResources.add(resource);
    }

    protected boolean build() {
        boolean success;
        block7: {
            Builder builder;
            block6: {
                builder = this.getFactory().getBuilder();
                try {
                    for (CtResource f : this.getInputSources()) {
                        builder.addInputSource(f);
                    }
                    for (CtResource f : this.getTemplateSources()) {
                        builder.addTemplateSource(f);
                    }
                }
                catch (IOException e) {
                    this.getFactory().getEnvironment().report(null, Severity.ERROR, "Error while loading resource : " + e.getMessage());
                    if (!this.getFactory().getEnvironment().isDebug()) break block6;
                    e.printStackTrace();
                }
            }
            success = false;
            try {
                success = builder.build();
            }
            catch (Exception e) {
                this.getFactory().getEnvironment().report(null, Severity.ERROR, "Error while loading resource : " + e.getMessage());
                if (!this.getFactory().getEnvironment().isDebug()) break block7;
                e.printStackTrace();
            }
        }
        return success;
    }

    protected Factory createFactory() {
        StandardEnvironment env = new StandardEnvironment();
        Factory factory = new Factory(new DefaultCoreFactory(), env);
        env.setComplianceLevel(this.getArguments().getInt("compliance"));
        env.setVerbose(true);
        env.setXmlRootFolder(this.getArguments().getFile("properties"));
        JavaOutputProcessor printer = new JavaOutputProcessor(this.getArguments().getFile("output"));
        env.setDefaultFileGenerator(printer);
        env.setVerbose(this.getArguments().getBoolean("verbose") || this.getArguments().getBoolean("debug"));
        env.setDebug(this.getArguments().getBoolean("debug"));
        env.setTabulationSize(this.getArguments().getInt("tabsize"));
        env.useTabulations(this.getArguments().getBoolean("tabs"));
        env.useSourceCodeFragments(this.getArguments().getBoolean("fragments"));
        return factory;
    }

    protected JSAP defineArgs() throws JSAPException {
        JSAP jsap = new JSAP();
        Switch sw1 = new Switch("help");
        sw1.setShortFlag('h');
        sw1.setLongFlag("help");
        sw1.setDefault("false");
        jsap.registerParameter(sw1);
        sw1 = new Switch("verbose");
        sw1.setShortFlag('v');
        sw1.setLongFlag("verbose");
        sw1.setDefault("false");
        sw1.setHelp("Output messages about what the compiler is doing");
        jsap.registerParameter(sw1);
        sw1 = new Switch("tabs");
        sw1.setLongFlag("tabs");
        sw1.setDefault("false");
        sw1.setHelp("Use tabulations instead of spaces in the generated code (use spaces by default)");
        jsap.registerParameter(sw1);
        sw1 = new Switch("fragments");
        sw1.setLongFlag("fragments");
        sw1.setShortFlag('f');
        sw1.setDefault("false");
        sw1.setHelp("Use source code fragments to generate source code (preserve formatting)");
        jsap.registerParameter(sw1);
        FlaggedOption opt2 = new FlaggedOption("tabsize");
        opt2.setLongFlag("tabsize");
        opt2.setStringParser(JSAP.INTEGER_PARSER);
        opt2.setDefault("4");
        opt2.setHelp("Define tabulation size");
        jsap.registerParameter(opt2);
        sw1 = new Switch("debug");
        sw1.setLongFlag("vvv");
        sw1.setDefault("false");
        sw1.setHelp("Generate all debugging info");
        jsap.registerParameter(sw1);
        opt2 = new FlaggedOption("compliance");
        opt2.setLongFlag("compliance");
        opt2.setHelp("set java compliance level (1,2,3,4,5 or 6)");
        opt2.setStringParser(JSAP.INTEGER_PARSER);
        opt2.setDefault("5");
        jsap.registerParameter(opt2);
        opt2 = new FlaggedOption("spoonlet");
        opt2.setShortFlag('s');
        opt2.setLongFlag("spoonlet");
        opt2.setStringParser(JSAP.STRING_PARSER);
        opt2.setRequired(false);
        opt2.setHelp("List of spoonlet files to load");
        jsap.registerParameter(opt2);
        opt2 = new FlaggedOption("input");
        opt2.setShortFlag('i');
        opt2.setLongFlag("input");
        opt2.setStringParser(JSAP.STRING_PARSER);
        opt2.setRequired(false);
        opt2.setHelp("List of path to sources files");
        jsap.registerParameter(opt2);
        opt2 = new FlaggedOption("processors");
        opt2.setShortFlag('p');
        opt2.setLongFlag("processors");
        opt2.setHelp("List of processor's qualified name to be used");
        opt2.setStringParser(JSAP.STRING_PARSER);
        opt2.setRequired(false);
        jsap.registerParameter(opt2);
        opt2 = new FlaggedOption("template");
        opt2.setShortFlag('t');
        opt2.setLongFlag("template");
        opt2.setHelp("list of source templates");
        opt2.setStringParser(JSAP.STRING_PARSER);
        opt2.setRequired(false);
        opt2.setHelp("list of path to templates java files");
        jsap.registerParameter(opt2);
        opt2 = new FlaggedOption("output");
        opt2.setShortFlag('o');
        opt2.setLongFlag("output");
        opt2.setDefault("spooned");
        opt2.setHelp("specify where to place generated java files");
        opt2.setStringParser(FileStringParser.getParser());
        opt2.setRequired(false);
        jsap.registerParameter(opt2);
        opt2 = new FlaggedOption("properties");
        opt2.setLongFlag("properties");
        opt2.setStringParser(FileStringParser.getParser());
        opt2.setRequired(false);
        opt2.setHelp("Directory to search for spoon properties files");
        jsap.registerParameter(opt2);
        UnflaggedOption opt3 = new UnflaggedOption("class");
        opt3.setStringParser(JSAP.STRING_PARSER);
        opt3.setRequired(false);
        opt3.setHelp("class to launch within the Spoon context (Main class)");
        jsap.registerParameter(opt3);
        opt3 = new UnflaggedOption("arguments");
        opt3.setStringParser(JSAP.STRING_PARSER);
        opt3.setRequired(false);
        opt3.setGreedy(true);
        opt3.setHelp("parameters to be passed to the main method");
        jsap.registerParameter(opt3);
        return jsap;
    }

    protected final JSAPResult getArguments() {
        if (this.arguments == null) {
            try {
                this.arguments = this.parseArgs(this.args);
            }
            catch (JSAPException e) {
                throw new RuntimeException(e);
            }
        }
        return this.arguments;
    }

    public final Factory getFactory() {
        if (this.factory == null) {
            this.factory = this.createFactory();
        }
        return this.factory;
    }

    protected void processArguments() {
        if (this.getArguments().getString("input") != null) {
            for (String s : this.getArguments().getString("input").split("[" + File.pathSeparatorChar + "]")) {
                try {
                    this.inputResources.add(FileFactory.createResource(new File(s)));
                }
                catch (FileNotFoundException e) {
                    this.getFactory().getEnvironment().report(null, Severity.ERROR, "Unable to add source file : " + e.getMessage());
                    if (!this.getFactory().getEnvironment().isDebug()) continue;
                    e.printStackTrace();
                }
            }
        }
        if (this.getArguments().getString("spoonlet") != null) {
            for (String s : this.getArguments().getString("spoonlet").split("[" + File.pathSeparatorChar + "]")) {
                this.loadSpoonlet(new File(s));
            }
        }
        if (this.getArguments().getString("template") != null) {
            for (String s : this.getArguments().getString("template").split("[" + File.pathSeparatorChar + "]")) {
                try {
                    this.addTemplateResource(FileFactory.createResource(new File(s)));
                }
                catch (FileNotFoundException e) {
                    this.getFactory().getEnvironment().report(null, Severity.ERROR, "Unable to add template file: " + e.getMessage());
                    if (!this.getFactory().getEnvironment().isDebug()) continue;
                    e.printStackTrace();
                }
            }
        }
        if (this.getArguments().getString("processors") != null) {
            for (String processorName : this.getArguments().getString("processors").split(File.pathSeparator)) {
                this.addProcessor(processorName);
            }
        }
    }

    protected List<CtResource> getInputSources() {
        return this.inputResources;
    }

    protected List<String> getProcessorTypes() {
        return this.processors;
    }

    protected List<CtResource> getTemplateSources() {
        return this.templateResources;
    }

    protected void loadSpoonlet(File spoonletFile) {
        CtFolderZip folder;
        try {
            folder = new CtFolderZip(spoonletFile);
        }
        catch (IOException e) {
            this.getFactory().getEnvironment().report(null, Severity.ERROR, "Unable to load spoonlet: " + e.getMessage());
            if (this.getFactory().getEnvironment().isDebug()) {
                e.printStackTrace();
            }
            return;
        }
        ArrayList<CtResource> spoonletIndex = new ArrayList<CtResource>();
        CtFile configFile = null;
        for (CtFile file : folder.getAllFiles()) {
            if (file.isJava()) {
                spoonletIndex.add(file);
                continue;
            }
            if (!file.getName().endsWith("spoon.xml")) continue;
            configFile = file;
        }
        if (configFile == null) {
            this.getFactory().getEnvironment().report(null, Severity.ERROR, "No configuration file in spoonlet " + spoonletFile.getName());
        } else {
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                SpoonletXmlHandler loader = new SpoonletXmlHandler(this, spoonletIndex);
                xr.setContentHandler(loader);
                InputStream stream = configFile.getContent();
                xr.parse(new InputSource(stream));
                stream.close();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected JSAPResult parseArgs(String[] args) throws JSAPException {
        JSAPResult arguments = this.jsapArgs.parse(args);
        if (!arguments.success()) {
            Iterator errs = arguments.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
        }
        if (!arguments.success() || arguments.getBoolean("help")) {
            System.err.println();
            System.err.println("Usage: java <launcher name> [option(s)]");
            System.err.println();
            System.err.println("Options : ");
            System.err.println();
            System.err.println(this.jsapArgs.getHelp());
            System.exit(-1);
        }
        return arguments;
    }

    protected void print() {
        if (this.getFactory().getEnvironment().getDefaultFileGenerator() != null) {
            QueueProcessingManager processing = new QueueProcessingManager(this.getFactory());
            processing.addProcessor(this.getFactory().getEnvironment().getDefaultFileGenerator());
            processing.process();
        }
    }

    protected void process() {
        QueueProcessingManager processing = new QueueProcessingManager(this.getFactory());
        for (String processorName : this.getProcessorTypes()) {
            processing.addProcessor(processorName);
            this.getFactory().getEnvironment().debugMessage("Loaded processor " + processorName + ".");
        }
        processing.process();
    }

    public void run() throws Exception {
        long t;
        this.getFactory().getEnvironment().debugMessage("loading command-line arguments...");
        this.processArguments();
        if (this.arguments.getBoolean("fragments")) {
            this.getFactory().getEnvironment().reportProgressMessage("running in 'fragments' mode: AST changes will be ignored");
        }
        this.getFactory().getEnvironment().reportProgressMessage("start processing...");
        long tstart = t = System.currentTimeMillis();
        this.build();
        this.getFactory().getEnvironment().debugMessage("model built in " + (System.currentTimeMillis() - t) + " ms");
        t = System.currentTimeMillis();
        this.process();
        this.getFactory().getEnvironment().debugMessage("model processed in " + (System.currentTimeMillis() - t) + " ms");
        t = System.currentTimeMillis();
        this.print();
        FileGenerator<? extends CtElement> fg = this.getFactory().getEnvironment().getDefaultFileGenerator();
        if (fg != null) {
            if (this.arguments.getBoolean("compile")) {
                this.getFactory().getEnvironment().debugMessage("generated bytecode in " + (System.currentTimeMillis() - t) + " ms");
            } else {
                this.getFactory().getEnvironment().debugMessage("generated source in " + (System.currentTimeMillis() - t) + " ms");
            }
            this.getFactory().getEnvironment().debugMessage("output directory: " + fg.getOutputDirectory());
        }
        t = System.currentTimeMillis();
        this.getFactory().getEnvironment().debugMessage("program spooning done in " + (t - tstart) + " ms");
        this.getFactory().getEnvironment().reportEnd();
        String progClass = this.getArguments().getString("class");
        String[] progArgs = this.getArguments().getStringArray("arguments");
        if (progClass != null) {
            this.getFactory().getEnvironment().debugMessage("running class: '" + progClass + "'...");
            Class<?> clas = this.getClass().getClassLoader().loadClass(progClass);
            Class[] mainArgType = new Class[]{new String[0].getClass()};
            Method main = clas.getMethod("main", mainArgType);
            Object[] argsArray = new Object[]{progArgs};
            main.invoke(null, argsArray);
        }
    }
}

