/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;

public class SpoonTask
extends Java {
    String classname;
    boolean compile = false;
    File input;
    int javaCompliance = 5;
    boolean nooutput = false;
    File output;
    File build;
    File spoonlet;
    Vector<FileSet> spoonletfileset = new Vector();
    List<ProcessorType> processorTypes = new ArrayList<ProcessorType>();
    File properties;
    Vector<FileSet> sourcefilesets = new Vector();
    boolean stats = false;
    File template;
    Vector<FileSet> templatefilesets = new Vector();
    boolean verbose = false;
    boolean debug = false;
    boolean tabs = false;
    boolean fragments = false;
    int tabSize = 4;

    public SpoonTask() {
        this.setClassname("spoon.Launcher");
        this.setFailonerror(true);
    }

    public void addProcessor(ProcessorType processorType) {
        this.processorTypes.add(processorType);
    }

    public void addSourceSet(FileSet set) {
        this.sourcefilesets.addElement(set);
    }

    public void addTemplateSet(FileSet set) {
        this.templatefilesets.addElement(set);
    }

    public void addSpoonletSet(FileSet set) {
        this.spoonletfileset.addElement(set);
    }

    public void execute() throws BuildException {
        int j;
        String[] srcs;
        File dir;
        DirectoryScanner ds;
        FileSet fs;
        int i;
        String f;
        this.setFork(true);
        if (this.verbose) {
            this.createArg().setValue("-v");
        }
        if (this.debug) {
            this.createArg().setValue("--vvv");
        }
        if (this.fragments) {
            this.createArg().setValue("--fragments");
        }
        if (this.tabs) {
            this.createArg().setValue("--tabs");
        }
        this.createArg().setValue("--tabsize");
        this.createArg().setValue("" + this.tabSize);
        if (this.nooutput) {
            this.createArg().setValue("--no");
        } else if (this.compile) {
            this.createArg().setValue("--compile");
            this.createArg().setValue("--build");
            this.createArg().setFile(this.build);
        }
        this.createArg().setValue("--compliance");
        this.createArg().setValue("" + this.javaCompliance);
        if (this.spoonlet != null || this.spoonletfileset.size() > 0) {
            this.createArg().setValue("-s");
            f = "";
            if (this.spoonlet != null) {
                f = f + this.spoonlet.getAbsolutePath() + File.pathSeparator;
            }
            for (i = 0; i < this.spoonletfileset.size(); ++i) {
                fs = this.spoonletfileset.elementAt(i);
                ds = fs.getDirectoryScanner(this.getProject());
                dir = fs.getDir(this.getProject());
                srcs = ds.getIncludedFiles();
                for (j = 0; j < srcs.length; ++j) {
                    f = f + dir.getAbsolutePath() + File.separatorChar + srcs[j] + File.pathSeparator;
                }
            }
            this.createArg().setValue(f);
        }
        if (this.output != null) {
            if (this.output.exists() && !this.output.isDirectory()) {
                throw new BuildException("Output must be a directory");
            }
            this.createArg().setValue("-o");
            this.createArg().setValue(this.output.getAbsolutePath());
        }
        if (this.input != null || this.sourcefilesets.size() > 0) {
            this.createArg().setValue("-i");
            f = "";
            if (this.input != null) {
                f = f + this.input.getAbsolutePath() + File.pathSeparator;
            }
            for (i = 0; i < this.sourcefilesets.size(); ++i) {
                fs = this.sourcefilesets.elementAt(i);
                ds = fs.getDirectoryScanner(this.getProject());
                dir = fs.getDir(this.getProject());
                srcs = ds.getIncludedFiles();
                for (j = 0; j < srcs.length; ++j) {
                    f = f + dir.getAbsolutePath() + File.separatorChar + srcs[j] + File.pathSeparator;
                }
            }
            this.createArg().setValue(f);
        }
        if (this.template != null || this.templatefilesets.size() > 0) {
            this.createArg().setValue("-t");
            f = "";
            if (this.template != null) {
                if (!this.template.exists()) {
                    throw new BuildException("template file or directory does not exist (" + this.template.getAbsolutePath() + ")");
                }
                f = f + this.template.getAbsolutePath() + File.pathSeparator;
            }
            for (i = 0; i < this.templatefilesets.size(); ++i) {
                fs = this.templatefilesets.elementAt(i);
                ds = fs.getDirectoryScanner(this.getProject());
                dir = fs.getDir(this.getProject());
                srcs = ds.getIncludedFiles();
                for (j = 0; j < srcs.length; ++j) {
                    f = f + dir.getAbsolutePath() + File.separatorChar + srcs[j] + File.pathSeparator;
                }
            }
            this.createArg().setValue(f);
        }
        if (this.properties != null) {
            this.createArg().setValue("--properties");
            if (!this.properties.exists()) {
                throw new BuildException("properties directory does not exist (" + this.properties.getAbsolutePath() + ")");
            }
            this.createArg().setValue(this.properties.getAbsolutePath());
        }
        if (this.processorTypes != null && this.processorTypes.size() > 0) {
            this.createArg().setValue("-p");
            String process = "";
            for (ProcessorType t : this.processorTypes) {
                process = process + t.type + File.pathSeparator;
            }
            this.createArg().setValue(process);
        }
        if (this.classname != null) {
            this.createArg().setValue(this.classname);
        }
        super.execute();
    }

    public void setClassName(String classname) {
        this.classname = classname;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
    }

    public void setInput(File input) {
        this.input = input;
    }

    public void setSpoonlet(File spoonlet) {
        this.spoonlet = spoonlet;
    }

    public void setJavaCompliance(int javaCompliance) {
        this.javaCompliance = javaCompliance;
    }

    public void setNoOutput(boolean nooutput) {
        this.nooutput = nooutput;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setBuild(File build) {
        this.build = build;
    }

    public void setProperties(File properties) {
        this.properties = properties;
    }

    public void setStats(boolean stats) {
        this.stats = stats;
    }

    public void setTemplate(File template) {
        this.template = template;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTabs(boolean tabs) {
        this.tabs = tabs;
    }

    public void setFragments(boolean fragments) {
        this.fragments = fragments;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public static class ProcessorType {
        String type;

        public ProcessorType() {
        }

        public ProcessorType(String type) {
            this.setType(type);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

