/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.eval;

import java.util.ArrayList;
import java.util.List;
import spoon.reflect.eval.StepKind;
import spoon.reflect.eval.SymbolicEvaluationStep;
import spoon.reflect.eval.SymbolicEvaluator;
import spoon.reflect.eval.SymbolicHeap;
import spoon.reflect.eval.SymbolicStackFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolicEvaluationPath {
    List<SymbolicEvaluationStep> steps = new ArrayList<SymbolicEvaluationStep>();

    public void addStep(StepKind kind, SymbolicEvaluator evaluator) {
        this.steps.add(new SymbolicEvaluationStep(kind, new SymbolicStackFrame(evaluator.getStack().getFrameStack().peek()), new SymbolicHeap(evaluator.getHeap())));
    }

    public SymbolicEvaluationStep getStep(int i) {
        return this.steps.get(i);
    }

    public List<SymbolicEvaluationStep> getSteps() {
        return this.steps;
    }

    public int getStepCount() {
        return this.steps.size();
    }

    public void dump() {
        for (int i = 0; i < this.steps.size(); ++i) {
            System.out.println(i + 1 + "\t" + (Object)((Object)this.steps.get(i).getKind()) + " " + this.steps.get(i).getFrame());
            this.steps.get(i).getHeap().dump();
        }
    }

    public String toString() {
        String res = "";
        for (int i = 0; i < this.steps.size(); ++i) {
            res = res + (Object)((Object)this.steps.get(i).getKind()) + "(" + this.steps.get(i).getFrame().getExecutable().getSimpleName() + ");";
        }
        return res;
    }

    public SymbolicEvaluationPath getEnterSteps() {
        SymbolicEvaluationPath res = new SymbolicEvaluationPath();
        for (SymbolicEvaluationStep s : this.getSteps()) {
            if (s.kind != StepKind.ENTER) continue;
            res.getSteps().add(s);
        }
        return res;
    }

    public SymbolicEvaluationPath getExitSteps() {
        SymbolicEvaluationPath res = new SymbolicEvaluationPath();
        for (SymbolicEvaluationStep s : this.getSteps()) {
            if (s.kind != StepKind.EXIT) continue;
            res.getSteps().add(s);
        }
        return res;
    }
}

