/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.eval.SymbolicInstance;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtVariableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolicStackFrame {
    private Map<CtVariableReference, SymbolicInstance> variables = new HashMap<CtVariableReference, SymbolicInstance>();
    private SymbolicInstance target;
    private SymbolicInstance caller;
    private CtAbstractInvocation invocation;
    private CtExecutableReference executable;
    List<SymbolicInstance> arguments;
    private SymbolicInstance result = null;

    public SymbolicStackFrame(SymbolicStackFrame frame) {
        for (Map.Entry<CtVariableReference, SymbolicInstance> e : frame.variables.entrySet()) {
            SymbolicInstance i = e.getValue();
            this.variables.put(e.getKey(), i == null ? null : i.getClone());
        }
        this.caller = frame.caller == null ? null : frame.caller.getClone();
        this.target = frame.target == null ? null : frame.target.getClone();
        this.result = frame.result == null ? null : frame.result.getClone();
        this.invocation = frame.invocation;
        this.executable = frame.executable;
        if (frame.arguments != null) {
            this.arguments = new ArrayList<SymbolicInstance>();
            for (SymbolicInstance i : frame.arguments) {
                this.arguments.add(i == null ? null : i.getClone());
            }
        }
    }

    public boolean equals(Object obj) {
        SymbolicStackFrame f = (SymbolicStackFrame)obj;
        return (this.target == null ? this.target == f.target : this.target.equals(f.target)) && this.invocation == f.invocation && this.executable.equals(f.executable) && ((Object)this.variables).equals(f.variables);
    }

    public CtAbstractInvocation getInvocation() {
        return this.invocation;
    }

    public SymbolicInstance getThis() {
        return this.target;
    }

    public SymbolicInstance getCaller() {
        return this.caller;
    }

    public Map<CtVariableReference, SymbolicInstance> getVariables() {
        return this.variables;
    }

    public List<SymbolicInstance> getArguments() {
        return this.arguments;
    }

    public SymbolicStackFrame(CtAbstractInvocation invocation, SymbolicInstance caller, SymbolicInstance instance, CtExecutableReference executable, List<SymbolicInstance> arguments, Map<CtVariableReference, SymbolicInstance> variables) {
        this.variables = variables;
        this.caller = caller;
        this.target = instance;
        this.invocation = invocation;
        this.executable = executable;
        this.arguments = arguments;
    }

    public String toString() {
        return "" + this.executable.getDeclaringType().getSimpleName() + "#" + this.executable.getSimpleName() + " on " + this.target + " variables=" + this.variables + " arguments=" + this.arguments + " result=" + this.result;
    }

    public CtExecutableReference getExecutable() {
        return this.executable;
    }

    public SymbolicInstance getResult() {
        return this.result;
    }

    public void setResult(SymbolicInstance result) {
        this.result = result;
    }
}

