/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import spoon.reflect.Factory;
import spoon.reflect.code.CtBlock;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableFactory
extends SubFactory {
    private static final long serialVersionUID = 1L;

    public ExecutableFactory(Factory factory) {
        super(factory);
    }

    public CtAnonymousExecutable createAnonymous(CtClass<?> target, CtBlock body) {
        CtAnonymousExecutable a = this.factory.Core().createAnonymousExecutable();
        target.getAnonymousExecutables().add(a);
        a.setParent(target);
        a.setBody(body);
        body.setParent(a);
        return a;
    }

    public <T> CtParameter<T> createParameter(CtExecutable<?> parent, CtTypeReference<T> type, String name) {
        CtParameter<T> parameter = this.factory.Core().createParameter();
        parameter.setType(type);
        parameter.setSimpleName(name);
        if (parent != null) {
            parent.getParameters().add(parameter);
            parameter.setParent(parent);
        }
        return parameter;
    }

    public <T> CtParameterReference<T> createParameterReference(CtParameter<T> parameter) {
        CtParameterReference ref = this.factory.Core().createParameterReference();
        if (parameter.getParent() != null) {
            ref.setDeclaringExecutable(this.factory.Executable().createReference(parameter.getParent()));
        }
        ref.setSimpleName(parameter.getSimpleName());
        ref.setType(parameter.getType());
        return ref;
    }

    public <T> CtExecutableReference<T> createReference(CtExecutable<T> e) {
        CtTypeReference[] refs = new CtTypeReference[e.getParameters().size()];
        int i = 0;
        for (CtParameter<?> param : e.getParameters()) {
            refs[i++] = param.getType();
        }
        if (e instanceof CtMethod) {
            return this.createReference(e.getDeclaringType().getReference(), ((CtMethod)e).getType(), e.getSimpleName(), refs);
        }
        return this.createReference(e.getDeclaringType().getReference(), ((CtConstructor)e).getType(), e.getSimpleName(), refs);
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, CtTypeReference<T> type, String methodName, CtTypeReference<?> ... parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList();
        for (CtTypeReference<?> ref : parameterTypes) {
            l.add(ref);
        }
        methodRef.setParameterTypes(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, boolean isStatic, CtTypeReference<T> type, String methodName, CtTypeReference<?> ... parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setStatic(isStatic);
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList();
        for (CtTypeReference<?> ref : parameterTypes) {
            l.add(ref);
        }
        methodRef.setParameterTypes(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, boolean isStatic, CtTypeReference<T> type, String methodName, List<CtTypeReference<?>> parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setStatic(isStatic);
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList();
        for (CtTypeReference<?> ref : parameterTypes) {
            l.add(ref);
        }
        methodRef.setParameterTypes(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, CtTypeReference<T> type, String methodName, List<CtTypeReference<?>> parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList();
        for (CtTypeReference<?> ref : parameterTypes) {
            l.add(ref);
        }
        methodRef.setParameterTypes(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(String signature) {
        CtExecutableReference executableRef = this.factory.Core().createExecutableReference();
        String type = signature.substring(0, signature.indexOf(" "));
        String declaringType = signature.substring(signature.indexOf(" ") + 1, signature.indexOf("#"));
        String executableName = signature.substring(signature.indexOf("#") + 1, signature.indexOf("("));
        executableRef.setSimpleName(executableName);
        executableRef.setDeclaringType(this.factory.Type().createReference(declaringType));
        CtTypeReference typeRef = this.factory.Type().createReference(type);
        executableRef.setType(typeRef);
        String parameters = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
        StringTokenizer t = new StringTokenizer(parameters, ",");
        while (t.hasMoreTokens()) {
            String paramType = t.nextToken();
            executableRef.getParameterTypes().add(this.factory.Type().createReference(paramType));
        }
        return executableRef;
    }
}

