/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import spoon.processing.Environment;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.JavaPrettyPrinter;
import spoon.support.reflect.CtLineElementComparator;
import spoon.support.util.SortedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaPrettyPrinter
implements CtVisitor,
JavaPrettyPrinter {
    Map<Integer, Integer> lineNumberMapping = new HashMap<Integer, Integer>();
    public Printingcontext context = new Printingcontext();
    private ImportScanner importsContext = new ImportScanner();
    private StringBuffer sbf = new StringBuffer();
    Environment env;
    int line = 1;

    public DefaultJavaPrettyPrinter(Environment env) {
        this.env = env;
    }

    public DefaultJavaPrettyPrinter decTab() {
        --this.context.nbTabs;
        return this;
    }

    protected void enterCtExpression(CtExpression<?> e) {
        if (e.getPosition() != null) {
            this.lineNumberMapping.put(this.line, e.getPosition().getLine());
        }
        if (this.shouldSetBracket(e)) {
            this.context.parenthesedExpression.push(e);
            this.write("(");
        }
        if (!e.getTypeCasts().isEmpty()) {
            for (CtTypeReference<?> r : e.getTypeCasts()) {
                this.write("(");
                this.scan(r);
                this.write(")");
                this.write("(");
                this.context.parenthesedExpression.push(e);
            }
        }
    }

    protected void enterCtStatement(CtStatement s) {
        if (s.getPosition() != null) {
            this.lineNumberMapping.put(this.line, s.getPosition().getLine());
        }
        this.writeAnnotations(s);
        if (s.getLabel() != null) {
            this.write(s.getLabel()).write(" : ");
        }
    }

    protected void exitCtExpression(CtExpression<?> e) {
        while (this.context.parenthesedExpression.size() > 0 && e.equals(this.context.parenthesedExpression.peek())) {
            this.context.parenthesedExpression.pop();
            this.write(")");
        }
    }

    public Collection<CtTypeReference<?>> getImports() {
        return this.importsContext.imports.values();
    }

    @Override
    public String getPackageDeclaration() {
        StringBuffer bck = this.sbf;
        this.sbf = new StringBuffer();
        Map<String, CtTypeReference<?>> tmp = this.importsContext.imports;
        this.importsContext.imports = new TreeMap();
        for (CtAnnotation<? extends Annotation> a : this.context.currentTopLevel.getPackage().getAnnotations()) {
            a.accept(this);
        }
        if (!this.context.currentTopLevel.getPackage().getQualifiedName().equals("unnamed package")) {
            this.write("package " + this.context.currentTopLevel.getPackage().getQualifiedName() + ";");
        }
        String ret = this.sbf.toString();
        this.sbf = bck;
        this.importsContext.imports = tmp;
        return ret;
    }

    @Override
    public StringBuffer getResult() {
        return this.sbf;
    }

    public DefaultJavaPrettyPrinter incTab() {
        ++this.context.nbTabs;
        return this;
    }

    public DefaultJavaPrettyPrinter setTabCount(int tabCount) {
        this.context.nbTabs = tabCount;
        return this;
    }

    private boolean isHiddenByField(CtType<?> container, CtTypeReference<?> type) {
        if (container == null) {
            return false;
        }
        if (container.getSimpleName() == null || container.getSimpleName().equals("")) {
            return false;
        }
        for (CtFieldReference f : container.getReference().getAllFields()) {
            if (!f.getSimpleName().equals(type.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private boolean isWhite(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public void makeImports(CtSimpleType<?> type) {
        this.context.currentTopLevel = type;
        this.importsContext.addImport(this.context.currentTopLevel.getReference());
        this.importsContext.scan(this.context.currentTopLevel);
    }

    protected void postWriteUnaryOperator(UnaryOperatorKind o) {
        switch (o) {
            case POSTINC: {
                this.write("++");
                break;
            }
            case POSTDEC: {
                this.write("--");
            }
        }
    }

    void preWriteUnaryOperator(UnaryOperatorKind o) {
        switch (o) {
            case POS: {
                this.write("+");
                break;
            }
            case NEG: {
                this.write("-");
                break;
            }
            case NOT: {
                this.write("!");
                break;
            }
            case COMPL: {
                this.write("~");
                break;
            }
            case PREINC: {
                this.write("++");
                break;
            }
            case PREDEC: {
                this.write("--");
            }
        }
    }

    protected DefaultJavaPrettyPrinter removeLastChar() {
        while (this.isWhite(this.sbf.charAt(this.sbf.length() - 1))) {
            this.sbf.deleteCharAt(this.sbf.length() - 1);
        }
        this.sbf.deleteCharAt(this.sbf.length() - 1);
        while (this.isWhite(this.sbf.charAt(this.sbf.length() - 1))) {
            this.sbf.deleteCharAt(this.sbf.length() - 1);
        }
        return this;
    }

    public DefaultJavaPrettyPrinter scan(CtElement e) {
        if (e != null) {
            e.accept(this);
        }
        return this;
    }

    public DefaultJavaPrettyPrinter scan(CtReference ref) {
        if (ref != null) {
            ref.accept(this);
        }
        return this;
    }

    private boolean shouldSetBracket(CtExpression<?> e) {
        if (e.getTypeCasts().size() != 0) {
            return true;
        }
        if (e.getParent() instanceof CtBinaryOperator || e.getParent() instanceof CtUnaryOperator) {
            return e instanceof CtTargetedExpression || e instanceof CtAssignment || e instanceof CtConditional || e instanceof CtUnaryOperator;
        }
        if (e.getParent() instanceof CtTargetedExpression) {
            return e instanceof CtBinaryOperator || e instanceof CtAssignment || e instanceof CtConditional;
        }
        return false;
    }

    public String toString() {
        return this.sbf.toString();
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.writeAnnotations(annotation);
        this.write("@");
        this.scan(annotation.getAnnotationType());
        if (annotation.getElementValues().size() > 0) {
            this.write("(");
            for (Map.Entry<String, Object> e : annotation.getElementValues().entrySet()) {
                this.write(e.getKey() + " = ");
                this.writeAnnotationElement(e.getValue());
                this.write(", ");
            }
            this.removeLastChar();
            this.write(")");
        }
        this.writeln();
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.visitCtSimpleType(annotationType);
        this.write("@interface " + annotationType.getSimpleName() + " {").incTab();
        SortedList<CtElement> lst = new SortedList<CtElement>(new CtLineElementComparator());
        lst.addAll(annotationType.getNestedTypes());
        lst.addAll(annotationType.getFields());
        for (CtElement el : lst) {
            this.writeln().scan(el).writeln();
        }
        this.decTab().writeln().write("}");
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable impl) {
        this.writeAnnotations(impl);
        this.writeModifiers(impl);
        impl.getBody().accept(this);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        this.enterCtExpression(arrayAccess);
        this.scan((CtElement)arrayAccess.getTarget());
        this.write("[").scan(arrayAccess.getIndexExpression()).write("]");
        this.exitCtExpression(arrayAccess);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.scan(reference.getComponentType());
        if (!this.context.skipArray) {
            this.write("[]");
        }
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.enterCtStatement(asserted);
        this.write("assert ");
        this.scan(asserted.getAssertExpression());
        if (asserted.getExpression() != null) {
            this.write(" : ");
            this.scan(asserted.getExpression());
        }
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.enterCtStatement(assignement);
        this.enterCtExpression(assignement);
        this.scan(assignement.getAssigned());
        this.write(" = ");
        this.scan(assignement.getAssignment());
        this.exitCtExpression(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        boolean paren;
        this.enterCtExpression(operator);
        boolean bl = paren = operator.getParent() instanceof CtBinaryOperator || operator.getParent() instanceof CtUnaryOperator;
        if (paren) {
            this.write("(");
        }
        this.scan(operator.getLeftHandOperand());
        this.write(" ").writeOperator(operator.getKind()).write(" ");
        this.scan(operator.getRightHandOperand());
        if (paren) {
            this.write(")");
        }
        this.exitCtExpression(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.enterCtStatement(block);
        this.write("{").incTab();
        for (CtStatement e : block.getStatements()) {
            if (e.isImplicit()) continue;
            this.writeln();
            this.writeStatement(e);
        }
        this.decTab().writeln().write("}");
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.enterCtStatement(breakStatement);
        this.write("break");
        if (breakStatement.getTargetLabel() != null) {
            this.write(" " + breakStatement.getTargetLabel());
        }
    }

    public <E> void visitCtCase(CtCase<E> caseStatement) {
        this.enterCtStatement(caseStatement);
        if (caseStatement.getCaseExpression() != null) {
            this.write("case ");
            if (caseStatement.getCaseExpression() instanceof CtFieldAccess && ((CtFieldAccess)caseStatement.getCaseExpression()).getVariable().getType().getQualifiedName().equals(((CtFieldAccess)caseStatement.getCaseExpression()).getVariable().getDeclaringType().getQualifiedName())) {
                this.write(((CtFieldAccess)caseStatement.getCaseExpression()).getVariable().getSimpleName());
            } else {
                this.scan(caseStatement.getCaseExpression());
            }
        } else {
            this.write("default");
        }
        this.write(" :").incTab();
        for (CtStatement s : caseStatement.getStatements()) {
            this.writeln().writeStatement(s);
        }
        this.decTab();
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.write(" catch (");
        this.scan(catchBlock.getParameter());
        this.write(") ");
        this.scan(catchBlock.getBody());
    }

    public DefaultJavaPrettyPrinter writeExtendsClause(CtClass<?> c) {
        if (c.getSuperclass() != null) {
            this.write(" extends ");
            this.scan(c.getSuperclass());
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeImplementsClause(CtType<?> t) {
        if (t.getSuperInterfaces().size() > 0) {
            this.write(" implements ");
            for (CtTypeReference<?> ref : t.getSuperInterfaces()) {
                this.scan(ref);
                this.write(" , ");
            }
            this.removeLastChar();
        }
        return this;
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        SortedList<CtElement> lst = new SortedList<CtElement>(new CtLineElementComparator());
        if (ctClass.getSimpleName() != null && ctClass.getSimpleName().length() > 0) {
            this.visitCtType(ctClass);
            this.write("class " + ctClass.getSimpleName());
            this.writeGenericsParameter(ctClass.getFormalTypeParameters());
            this.writeExtendsClause(ctClass);
            this.writeImplementsClause(ctClass);
            for (CtConstructor c : ctClass.getConstructors()) {
                if (c.isImplicit()) continue;
                lst.add(c);
            }
        }
        lst.addAll(ctClass.getAnonymousExecutables());
        lst.addAll(ctClass.getNestedTypes());
        lst.addAll(ctClass.getFields());
        lst.addAll(ctClass.getMethods());
        this.context.currentThis.push(ctClass.getReference());
        this.write(" {").incTab();
        for (CtElement el : lst) {
            this.writeln().scan(el).writeln();
        }
        this.decTab().writeln().write("}");
        this.context.currentThis.pop();
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.enterCtExpression(conditional);
        this.scan(conditional.getCondition());
        this.write(" ? ");
        this.scan(conditional.getThenExpression());
        this.write(" : ");
        this.scan(conditional.getElseExpression());
        this.exitCtExpression(conditional);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        this.visitCtNamedElement(c);
        this.writeGenericsParameter(c.getFormalTypeParameters());
        this.write(c.getDeclaringType().getSimpleName());
        this.write("(");
        if (c.getParameters().size() > 0) {
            for (CtParameter<?> ctParameter : c.getParameters()) {
                this.visitCtParameter(ctParameter);
                this.write(" ,");
            }
            this.removeLastChar();
        }
        this.write(") ");
        if (c.getThrownTypes() != null && c.getThrownTypes().size() > 0) {
            this.write("throws ");
            for (CtTypeReference ctTypeReference : c.getThrownTypes()) {
                this.scan(ctTypeReference);
                this.write(" , ");
            }
            this.removeLastChar();
            this.write(" ");
        }
        this.scan(c.getBody());
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.enterCtStatement(continueStatement);
        this.write("continue");
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.enterCtStatement(doLoop);
        this.write("do ");
        this.writeStatement(doLoop.getBody());
        this.write(" while (");
        this.scan(doLoop.getLoopingExpression());
        this.write(" )");
    }

    private void writeEnumField(CtField f) {
        this.write(f.getSimpleName());
        if (f.getDefaultExpression() != null) {
            CtNewClass nc = (CtNewClass)f.getDefaultExpression();
            if (nc.getArguments().size() > 0) {
                this.write("(" + nc.getArguments().get(0) + ")");
            }
            this.scan(nc.getAnonymousClass());
        }
    }

    @Override
    public <T extends Enum> void visitCtEnum(CtEnum<T> ctEnum) {
        this.visitCtSimpleType(ctEnum);
        this.write("enum " + ctEnum.getSimpleName());
        if (ctEnum.getSuperInterfaces().size() > 0) {
            this.write(" implements ");
            for (CtTypeReference<?> ref : ctEnum.getSuperInterfaces()) {
                this.scan(ref);
                this.write(" , ");
            }
            this.removeLastChar();
        }
        this.write(" {").incTab().writeln();
        ArrayList l1 = new ArrayList();
        ArrayList l2 = new ArrayList();
        for (CtField<Object> ec : ctEnum.getFields()) {
            if (ec.getType() == null) {
                l1.add(ec);
                continue;
            }
            l2.add(ec);
        }
        if (l1.size() > 0) {
            for (CtField<Object> ec : l1) {
                this.writeEnumField(ec);
                this.write(", ");
            }
            this.removeLastChar();
            this.write(";");
        }
        for (CtField<Object> ec : l2) {
            this.writeln().scan(ec);
        }
        for (CtConstructor c : ctEnum.getConstructors()) {
            if (c.isImplicit()) continue;
            this.writeln().scan(c);
        }
        this.decTab().writeln().write("}");
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.scan(reference.getDeclaringType());
        this.write(".");
        if (reference.getSimpleName().equals("<init>")) {
            this.write(reference.getDeclaringType().getSimpleName());
        } else {
            this.write(reference.getSimpleName());
        }
        this.writeGenericsParameter(reference.getActualTypeArguments());
        this.writeParameters(reference.getParameterTypes());
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.visitCtNamedElement(f);
        this.scan(f.getType());
        this.write(" ");
        this.write(f.getSimpleName());
        if (f.getParent() == null || !CtAnnotationType.class.isAssignableFrom(f.getParent().getClass())) {
            if (f.getDefaultExpression() != null) {
                this.write(" = ");
                this.scan(f.getDefaultExpression());
            }
        } else {
            this.write("()");
            if (f.getDefaultExpression() != null) {
                this.write(" default ");
                this.scan(f.getDefaultExpression());
            }
        }
        this.write(";");
    }

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> fieldAccess) {
        this.enterCtExpression(fieldAccess);
        if (fieldAccess.getTarget() != null) {
            this.scan((CtElement)fieldAccess.getTarget());
            this.write(".");
        }
        this.context.ignoreGenerics = true;
        this.scan(fieldAccess.getVariable());
        this.context.ignoreGenerics = false;
        this.exitCtExpression(fieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        if (reference.getSimpleName().equals("this")) {
            if (this.context.currentThis.isEmpty() || !reference.getType().equals(this.context.currentThis.peek())) {
                this.context.ignoreGenerics = true;
                this.scan(reference.getDeclaringType());
                this.write(".");
                this.context.ignoreGenerics = false;
            }
        } else {
            boolean isStatic = false;
            isStatic = reference.getSimpleName().equals("class") ? true : (reference.getSimpleName().equals("super") ? false : reference.isStatic());
            boolean printType = true;
            if (reference.isFinal() && reference.isStatic()) {
                if (this.context.currentTopLevel != null) {
                    CtTypeReference<?> ref = reference.getDeclaringType();
                    CtTypeReference<?> ref2 = this.context.currentTopLevel.getReference();
                    printType = !ref.getSimpleName().equals("") && !ref.equals(ref2);
                } else {
                    printType = true;
                }
            }
            if (isStatic && printType) {
                this.context.ignoreGenerics = true;
                this.scan(reference.getDeclaringType());
                this.context.ignoreGenerics = false;
                this.write(".");
            }
        }
        this.write(reference.getSimpleName());
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.enterCtStatement(forLoop);
        this.write("for (");
        List<CtStatement> st = forLoop.getForInit();
        if (st.size() > 0) {
            this.scan(st.get(0));
        }
        if (st.size() > 1) {
            this.context.noTypeDecl = true;
            for (int i = 1; i < st.size(); ++i) {
                this.write(", ");
                this.scan(st.get(i));
            }
            this.context.noTypeDecl = false;
        }
        this.write(" ; ");
        this.scan(forLoop.getExpression());
        this.write(" ; ");
        for (CtStatement s : forLoop.getForUpdate()) {
            this.scan(s);
            this.write(" , ");
        }
        if (forLoop.getForUpdate().size() > 0) {
            this.removeLastChar();
        }
        this.write(")");
        if (forLoop.getBody() instanceof CtBlock) {
            this.write(" ");
            this.scan(forLoop.getBody());
        } else {
            this.incTab().writeln();
            this.writeStatement(forLoop.getBody());
            this.decTab();
        }
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.enterCtStatement(foreach);
        this.write("for (");
        this.scan(foreach.getVariable());
        this.write(" : ");
        this.scan(foreach.getExpression());
        this.write(")");
        if (foreach.getBody() instanceof CtBlock) {
            this.write(" ");
            this.scan(foreach.getBody());
        } else {
            this.incTab().writeln();
            this.writeStatement(foreach.getBody());
            this.decTab();
        }
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.enterCtStatement(ifElement);
        this.write("if (");
        this.scan(ifElement.getCondition());
        this.write(")");
        if (ifElement.getThenStatement() instanceof CtBlock) {
            this.write(" ");
            this.scan(ifElement.getThenStatement());
            this.write(" ");
        } else {
            this.incTab().writeln();
            this.writeStatement(ifElement.getThenStatement());
            this.decTab().writeln();
        }
        if (ifElement.getElseStatement() != null) {
            this.write("else");
            if (ifElement.getElseStatement() instanceof CtIf) {
                this.write(" ");
                this.scan(ifElement.getElseStatement());
            } else if (ifElement.getElseStatement() instanceof CtBlock) {
                this.write(" ");
                this.scan(ifElement.getElseStatement());
            } else {
                this.incTab().writeln();
                this.writeStatement(ifElement.getElseStatement());
                this.decTab().writeln();
            }
        }
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.visitCtType(intrface);
        this.write("interface " + intrface.getSimpleName());
        if (intrface.getFormalTypeParameters() != null) {
            this.writeGenericsParameter(intrface.getFormalTypeParameters());
        }
        if (intrface.getSuperInterfaces().size() > 0) {
            this.write(" extends ");
            for (CtTypeReference<?> ref : intrface.getSuperInterfaces()) {
                this.scan(ref);
                this.write(" , ");
            }
            this.removeLastChar();
        }
        this.write(" {").incTab();
        SortedList<CtElement> lst = new SortedList<CtElement>(new CtLineElementComparator());
        lst.addAll(intrface.getNestedTypes());
        lst.addAll(intrface.getFields());
        lst.addAll(intrface.getMethods());
        for (CtElement e : lst) {
            this.writeln().scan(e);
        }
        this.decTab().writeln().write("}");
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.enterCtStatement(invocation);
        this.enterCtExpression(invocation);
        if (invocation.getExecutable().getSimpleName().equals("<init>")) {
            CtType parentType = invocation.getParent(CtType.class);
            if (parentType != null && parentType.getQualifiedName() != null && parentType.getQualifiedName().equals(invocation.getExecutable().getDeclaringType().getQualifiedName())) {
                this.write("this");
            } else {
                this.write("super");
            }
        } else {
            if (invocation.getExecutable().isStatic()) {
                CtTypeReference<?> type = invocation.getExecutable().getDeclaringType();
                if (this.isHiddenByField(invocation.getParent(CtType.class), type)) {
                    this.importsContext.imports.remove(type.getSimpleName());
                }
                this.context.ignoreGenerics = true;
                this.scan(type);
                this.context.ignoreGenerics = false;
                this.write(".");
            } else if (invocation.getTarget() != null) {
                this.context.enterTarget();
                this.scan((CtElement)invocation.getTarget());
                this.context.exitTarget();
                this.write(".");
            }
            this.write(invocation.getExecutable().getSimpleName());
        }
        this.write("(");
        boolean remove = false;
        for (CtExpression<?> e : invocation.getArguments()) {
            this.scan(e);
            this.write(" ,");
            remove = true;
        }
        if (remove) {
            this.removeLastChar();
        }
        this.write(")");
        this.exitCtExpression(invocation);
    }

    public static String quote(String s) {
        StringBuffer buf = new StringBuffer();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    buf.append("\\n");
                    continue block10;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block10;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block10;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block10;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block10;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    buf.append("\\'");
                    continue block10;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block10;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.enterCtExpression(literal);
        if (literal.getValue() == null) {
            this.write("null");
        } else if (literal.getValue() instanceof Long) {
            this.write(literal.getValue() + "L");
        } else if (literal.getValue() instanceof Float) {
            this.write(literal.getValue() + "F");
        } else if (literal.getValue() instanceof Character) {
            this.write("'");
            this.write(DefaultJavaPrettyPrinter.quote(String.valueOf(literal.getValue())));
            this.write("'");
        } else if (literal.getValue() instanceof String) {
            this.write("\"" + DefaultJavaPrettyPrinter.quote((String)literal.getValue()) + "\"");
        } else if (literal.getValue() instanceof Class) {
            this.write(((Class)literal.getValue()).getName());
        } else if (literal.getValue() instanceof CtReference) {
            this.scan((CtReference)literal.getValue());
        } else {
            this.write(literal.getValue().toString());
        }
        this.exitCtExpression(literal);
    }

    public <T> DefaultJavaPrettyPrinter writeLocalVariable(CtLocalVariable<T> localVariable) {
        if (!this.context.noTypeDecl) {
            this.writeModifiers(localVariable);
            this.scan(localVariable.getType());
            this.write(" ");
        }
        this.write(localVariable.getSimpleName());
        if (localVariable.getDefaultExpression() != null) {
            this.write(" = ");
            this.scan(localVariable.getDefaultExpression());
        }
        return this;
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.enterCtStatement(localVariable);
        this.writeLocalVariable(localVariable);
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.write(reference.getSimpleName());
    }

    public DefaultJavaPrettyPrinter writeTypeReference(CtTypeReference<?> t) {
        this.scan(t);
        return this;
    }

    public DefaultJavaPrettyPrinter writeExecutableParameters(CtExecutable<?> e) {
        if (e.getParameters().size() > 0) {
            for (CtParameter<?> p : e.getParameters()) {
                this.visitCtParameter(p);
                this.write(", ");
            }
            this.removeLastChar();
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeThrowsClause(CtExecutable<?> e) {
        if (e.getThrownTypes().size() > 0) {
            this.write(" throws ");
            for (CtTypeReference<Throwable> ref : e.getThrownTypes()) {
                this.scan(ref);
                this.write(", ");
            }
            this.removeLastChar();
        }
        return this;
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.visitCtNamedElement(m);
        this.writeGenericsParameter(m.getFormalTypeParameters());
        this.scan(m.getType());
        this.write(" ");
        this.write(m.getSimpleName());
        this.write("(");
        this.writeExecutableParameters(m);
        this.write(")");
        this.writeThrowsClause(m);
        if (m.getBody() != null) {
            this.write(" ");
            this.visitCtBlock(m.getBody());
            if (m.getBody().getPosition() != null && (m.getBody().getStatements().isEmpty() || !(m.getBody().getStatements().get(m.getBody().getStatements().size() - 1) instanceof CtReturn))) {
                this.lineNumberMapping.put(this.line, m.getBody().getPosition().getEndLine());
            }
        } else {
            this.write(";");
        }
    }

    public void reset() {
        this.importsContext = new ImportScanner();
        this.sbf = new StringBuffer();
    }

    public DefaultJavaPrettyPrinter writeModifiers(CtModifiable m) {
        for (ModifierKind mod : m.getModifiers()) {
            this.write(mod.toString().toLowerCase() + " ");
        }
        return this;
    }

    public void visitCtNamedElement(CtNamedElement e) {
        if (this.context.printDocs && e.getDocComment() != null) {
            this.write("/** ").writeln();
            for (String com : e.getDocComment().split("\n")) {
                this.write(" *" + com).writeln();
            }
            this.write(" */").writeln();
        }
        this.writeAnnotations(e);
        this.writeModifiers(e);
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.enterCtExpression(newArray);
        if (!(this.context.currentTopLevel instanceof CtAnnotationType)) {
            CtTypeReference<Object> ref = newArray.getType();
            if (ref != null) {
                this.write("new ");
            }
            this.context.skipArray = true;
            this.scan(ref);
            this.context.skipArray = false;
            int i = 0;
            while (ref instanceof CtArrayTypeReference) {
                this.write("[");
                if (newArray.getDimensionExpressions().size() > i) {
                    this.scan(newArray.getDimensionExpressions().get(i));
                }
                this.write("]");
                ref = ((CtArrayTypeReference)ref).getComponentType();
                ++i;
            }
        }
        if (newArray.getDimensionExpressions().size() == 0) {
            this.write("{ ");
            for (CtExpression<?> e : newArray.getElements()) {
                this.scan(e);
                this.write(" , ");
            }
            if (newArray.getElements().size() > 0) {
                this.removeLastChar();
            }
            this.write(" }");
        }
        this.exitCtExpression(newArray);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.enterCtStatement(newClass);
        this.enterCtExpression(newClass);
        if (newClass.getTarget() != null) {
            this.scan((CtElement)newClass.getTarget()).write(".");
        }
        if (newClass.getAnonymousClass() != null) {
            this.write("new ");
            if (newClass.getAnonymousClass().getSuperclass() != null) {
                this.scan(newClass.getAnonymousClass().getSuperclass());
            } else if (newClass.getAnonymousClass().getSuperInterfaces().size() > 0) {
                for (CtTypeReference ctTypeReference : newClass.getAnonymousClass().getSuperInterfaces()) {
                    this.scan(ctTypeReference);
                }
            }
            this.write("(");
            for (CtExpression ctExpression : newClass.getArguments()) {
                this.scan(ctExpression);
                this.write(", ");
            }
            if (newClass.getArguments().size() > 0) {
                this.removeLastChar();
            }
            this.write(")");
            this.scan(newClass.getAnonymousClass());
        } else {
            this.write("new ").scan(newClass.getType());
            if (newClass.getExecutable() != null && newClass.getExecutable().getActualTypeArguments() != null) {
                this.writeGenericsParameter(newClass.getExecutable().getActualTypeArguments());
            }
            this.write("(");
            boolean remove = false;
            for (CtExpression<?> e : newClass.getArguments()) {
                this.scan(e);
                this.write(" , ");
                remove = true;
            }
            if (remove) {
                this.removeLastChar();
            }
            this.write(")");
        }
        this.exitCtExpression(newClass);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignement(CtOperatorAssignment<T, A> assignment) {
        this.enterCtStatement(assignment);
        this.enterCtExpression(assignment);
        this.scan(assignment.getAssigned());
        this.write(" ");
        this.writeOperator(assignment.getKind());
        this.write("= ");
        this.scan(assignment.getAssignment());
        this.exitCtExpression(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        if (!ctPackage.getQualifiedName().equals("unnamed package")) {
            if (this.context.currentTopLevel == null) {
                for (CtAnnotation<? extends Annotation> a : ctPackage.getAnnotations()) {
                    this.scan(a);
                }
            }
            this.write("package " + ctPackage.getQualifiedName() + ";");
        }
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.write(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.writeAnnotations(parameter);
        this.writeModifiers(parameter);
        if (parameter.isVarArgs()) {
            this.scan(((CtArrayTypeReference)parameter.getType()).getComponentType());
            this.write("...");
        } else {
            this.scan(parameter.getType());
        }
        this.write(" ");
        this.write(parameter.getSimpleName());
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.write(reference.getSimpleName());
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.enterCtStatement(returnStatement);
        this.write("return ");
        this.scan(returnStatement.getReturnedExpression());
    }

    <T> void visitCtSimpleType(CtSimpleType<T> type) {
        if (type.getPosition() != null) {
            this.lineNumberMapping.put(this.line, type.getPosition().getLine());
        }
        if (type.isTopLevel()) {
            this.context.currentTopLevel = type;
        }
        this.visitCtNamedElement(type);
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList<R> statements) {
        for (CtStatement s : statements.getStatements()) {
            this.scan(s);
        }
    }

    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        this.enterCtStatement(switchStatement);
        this.write("switch (");
        this.scan(switchStatement.getSelector());
        this.write(") {").incTab();
        for (CtCase<E> c : switchStatement.getCases()) {
            this.writeln().scan(c);
        }
        this.decTab().writeln().write("}");
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.enterCtStatement(synchro);
        this.write("synchronized");
        if (synchro.getExpression() != null) {
            this.write("(");
            this.scan(synchro.getExpression());
            this.write(") ");
        }
        this.scan(synchro.getBlock());
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.enterCtStatement(throwStatement);
        this.write("throw ");
        this.scan(throwStatement.getThrownExpression());
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.enterCtStatement(tryBlock);
        this.write("try ");
        this.scan(tryBlock.getBody());
        for (CtCatch c : tryBlock.getCatchers()) {
            this.scan(c);
        }
        if (tryBlock.getFinalizer() != null) {
            this.write(" finally ");
            this.scan(tryBlock.getFinalizer());
        }
    }

    <T> void visitCtType(CtType<T> type) {
        this.visitCtSimpleType(type);
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.write(typeParameter.getName());
        if (!typeParameter.getBounds().isEmpty()) {
            this.write(" extends ");
            for (CtTypeReference ref : typeParameter.getBounds()) {
                this.scan(ref);
                this.write(" & ");
            }
            this.removeLastChar();
        }
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        if (this.importsContext.isImported(ref) || this.context.printShortName) {
            this.write(ref.getSimpleName());
        } else {
            this.write(ref.getQualifiedName());
        }
        if (!this.context.ignoreGenerics) {
            this.writeGenericsParameter(ref.getActualTypeArguments());
        }
        if (!(ref.getBounds().isEmpty() || ref.getBounds().size() == 1 && ref.getBounds().get(0).getQualifiedName().equals("java.lang.Object"))) {
            if (ref.isUpper()) {
                this.write(" extends ");
            } else {
                this.write(" super ");
            }
            for (CtTypeReference b : ref.getBounds()) {
                this.scan(b);
                this.write(" & ");
            }
            this.removeLastChar();
        }
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> ref) {
        if (ref.isPrimitive()) {
            this.write(ref.getSimpleName());
            return;
        }
        if (this.importsContext.isImported(ref) && !this.context.ignoreImport || this.context.printShortName) {
            this.write(ref.getSimpleName());
        } else if (ref.getDeclaringType() != null) {
            if (this.context.currentTopLevel != null) {
                boolean ign = this.context.ignoreGenerics;
                this.context.ignoreGenerics = true;
                this.scan(ref.getDeclaringType());
                this.write(".");
                this.context.ignoreGenerics = ign;
            }
            this.write(ref.getSimpleName());
        } else {
            this.write(ref.getQualifiedName());
        }
        if (!this.context.ignoreGenerics) {
            this.writeGenericsParameter(ref.getActualTypeArguments());
        }
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.enterCtStatement(operator);
        this.enterCtExpression(operator);
        this.preWriteUnaryOperator(operator.getKind());
        this.context.enterTarget();
        this.scan(operator.getOperand());
        this.context.exitTarget();
        this.postWriteUnaryOperator(operator.getKind());
        this.exitCtExpression(operator);
    }

    @Override
    public <T> void visitCtVariableAccess(CtVariableAccess<T> variableAccess) {
        this.enterCtExpression(variableAccess);
        this.write(variableAccess.getVariable().getSimpleName());
        this.exitCtExpression(variableAccess);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.enterCtStatement(whileLoop);
        this.write("while (");
        this.scan(whileLoop.getLoopingExpression());
        this.write(")");
        if (whileLoop.getBody() instanceof CtBlock) {
            this.write(" ");
            this.scan(whileLoop.getBody());
        } else {
            this.incTab().writeln();
            this.writeStatement(whileLoop.getBody());
            this.decTab();
        }
    }

    public DefaultJavaPrettyPrinter write(String s) {
        if (s != null) {
            this.sbf.append(s);
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeAnnotations(CtElement e) {
        for (CtAnnotation<? extends Annotation> a : e.getAnnotations()) {
            a.accept(this);
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeAnnotationElement(Object value) {
        if (value instanceof CtTypeReference) {
            this.context.ignoreGenerics = true;
            this.scan((CtTypeReference)value).write(".class");
            this.context.ignoreGenerics = false;
        } else if (value instanceof CtFieldReference) {
            this.scan(((CtFieldReference)value).getDeclaringType());
            this.write("." + ((CtFieldReference)value).getSimpleName());
        } else if (value instanceof CtReference) {
            this.scan((CtReference)value);
        } else if (value instanceof CtElement) {
            this.scan((CtElement)value);
        } else if (value instanceof String) {
            this.write("\"" + value.toString() + "\"");
        } else if (value instanceof Collection) {
            this.write("{");
            if (!((Collection)value).isEmpty()) {
                for (Object obj : (Collection)value) {
                    this.writeAnnotationElement(obj);
                    this.write(" ,");
                }
                this.removeLastChar();
            }
            this.write("}");
        } else {
            this.write(value.toString());
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeGenericsParameter(Collection<CtTypeReference<?>> params) {
        if (params == null) {
            return this;
        }
        if (params.size() > 0) {
            this.write("<");
            this.context.ignoreImport = true;
            for (CtTypeReference<?> param : params) {
                this.scan(param);
                this.write(", ");
            }
            this.context.ignoreImport = false;
            this.removeLastChar();
            this.write("> ");
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeHeader(List<CtSimpleType<?>> types) {
        if (!types.isEmpty()) {
            CtPackage pack = types.get(0).getPackage();
            this.scan(pack).writeln().writeln();
            for (CtTypeReference<?> ref : this.importsContext.imports.values()) {
                if (ref.getPackage() == null || ref.getPackage().getSimpleName().equals("java.lang") || ref.getPackage().getSimpleName().equals(pack.getQualifiedName())) continue;
                this.write("import " + ref.getQualifiedName() + ";").writeln();
            }
            this.writeln();
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeln() {
        this.sbf.append(System.getProperty("line.separator"));
        ++this.line;
        return this.writeTabs();
    }

    public DefaultJavaPrettyPrinter writeTabs() {
        for (int i = 0; i < this.context.nbTabs; ++i) {
            if (this.env.isUsingTabulations()) {
                this.sbf.append("\t");
                continue;
            }
            for (int j = 0; j < this.env.getTabulationSize(); ++j) {
                this.sbf.append(" ");
            }
        }
        return this;
    }

    public DefaultJavaPrettyPrinter writeOperator(BinaryOperatorKind o) {
        switch (o) {
            case OR: {
                this.write("||");
                break;
            }
            case AND: {
                this.write("&&");
                break;
            }
            case BITOR: {
                this.write("|");
                break;
            }
            case BITXOR: {
                this.write("^");
                break;
            }
            case BITAND: {
                this.write("&");
                break;
            }
            case EQ: {
                this.write("==");
                break;
            }
            case NE: {
                this.write("!=");
                break;
            }
            case LT: {
                this.write("<");
                break;
            }
            case GT: {
                this.write(">");
                break;
            }
            case LE: {
                this.write("<=");
                break;
            }
            case GE: {
                this.write(">=");
                break;
            }
            case SL: {
                this.write("<<");
                break;
            }
            case SR: {
                this.write(">>");
                break;
            }
            case USR: {
                this.write(">>>");
                break;
            }
            case PLUS: {
                this.write("+");
                break;
            }
            case MINUS: {
                this.write("-");
                break;
            }
            case MUL: {
                this.write("*");
                break;
            }
            case DIV: {
                this.write("/");
                break;
            }
            case MOD: {
                this.write("%");
                break;
            }
            case INSTANCEOF: {
                this.write("instanceof");
            }
        }
        return this;
    }

    protected void writeParameters(Collection<CtTypeReference<?>> params) {
        if (params.size() > 0) {
            this.write("(");
            for (CtTypeReference<?> param : params) {
                this.scan(param);
                this.write(", ");
            }
            this.removeLastChar();
            this.write(")");
        }
    }

    protected void writeStatement(CtStatement e) {
        this.scan(e);
        if (!(e instanceof CtBlock || e instanceof CtIf || e instanceof CtFor || e instanceof CtForEach || e instanceof CtWhile || e instanceof CtTry || e instanceof CtSwitch || e instanceof CtSynchronized)) {
            this.write(";");
        }
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        this.write(expression.getValue());
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        this.write(statement.getValue());
    }

    @Override
    public void calculate(List<CtSimpleType<?>> types) {
        for (CtSimpleType<?> t : types) {
            this.makeImports(t);
        }
        this.writeHeader(types);
        for (CtSimpleType<?> t : types) {
            this.scan(t);
            this.writeln().writeln();
        }
    }

    @Override
    public Map<Integer, Integer> getLineNumberMapping() {
        return this.lineNumberMapping;
    }

    private class Printingcontext {
        boolean noTypeDecl = false;
        Stack<CtTypeReference<?>> currentThis = new Stack();
        CtSimpleType<?> currentTopLevel;
        boolean ignoreGenerics = false;
        boolean ignoreImport = false;
        int jumped = 0;
        int lineLength = 80;
        int lineLengthMargin = 5;
        int nbTabs = 0;
        Stack<CtExpression> parenthesedExpression = new Stack();
        boolean printDocs = true;
        boolean printShortName = false;
        boolean skipArray = false;
        int target = 0;

        private Printingcontext() {
        }

        void enterTarget() {
            ++this.target;
        }

        void exitTarget() {
            if (this.jumped > 0) {
                --this.jumped;
            } else {
                --this.target;
            }
        }

        void jumpTarget() {
            ++this.jumped;
            --this.target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImportScanner
    extends CtScanner {
        Map<String, CtTypeReference<?>> imports = new TreeMap();

        private ImportScanner() {
        }

        public <T> boolean addImport(CtTypeReference<T> ref) {
            if (this.imports.containsKey(ref.getSimpleName())) {
                return this.isImported(ref);
            }
            this.imports.put(ref.getSimpleName(), ref);
            return true;
        }

        @Override
        public <T> void visitCtFieldAccess(CtFieldAccess<T> fieldAccess) {
            this.enter(fieldAccess);
            this.scan(fieldAccess.getVariable());
            this.scan(fieldAccess.getAnnotations());
            this.scanReferences(fieldAccess.getTypeCasts());
            this.scan(fieldAccess.getVariable());
            this.scan((CtElement)fieldAccess.getTarget());
            this.exit(fieldAccess);
        }

        @Override
        public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
            this.enterReference(reference);
            this.scan(reference.getDeclaringType());
            this.exitReference(reference);
        }

        public <T> boolean isImported(CtTypeReference<T> ref) {
            CtTypeReference<?> exist;
            return this.imports.containsKey(ref.getSimpleName()) && (exist = this.imports.get(ref.getSimpleName())).getQualifiedName().equals(ref.getQualifiedName());
        }

        @Override
        public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
            this.enterReference(reference);
            this.scanReferences(reference.getParameterTypes());
            this.scanReferences(reference.getActualTypeArguments());
            this.exitReference(reference);
        }

        @Override
        public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
            if (!(reference instanceof CtArrayTypeReference)) {
                if (reference.getDeclaringType() == null) {
                    this.addImport(reference);
                } else {
                    this.addImport(reference.getDeclaringType());
                }
            }
            super.visitCtTypeReference(reference);
        }

        @Override
        public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
            this.addImport(annotationType.getReference());
            super.visitCtAnnotationType(annotationType);
        }

        @Override
        public <T extends Enum> void visitCtEnum(CtEnum<T> ctEnum) {
            this.addImport(ctEnum.getReference());
            super.visitCtEnum(ctEnum);
        }

        @Override
        public <T> void visitCtInterface(CtInterface<T> intrface) {
            this.addImport(intrface.getReference());
            for (CtSimpleType<?> t : intrface.getNestedTypes()) {
                this.addImport(t.getReference());
            }
            super.visitCtInterface(intrface);
        }

        @Override
        public <T> void visitCtClass(CtClass<T> ctClass) {
            this.addImport(ctClass.getReference());
            for (CtSimpleType<?> t : ctClass.getNestedTypes()) {
                this.addImport(t.getReference());
            }
            super.visitCtClass(ctClass);
        }
    }
}

